/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.DiskValidator;
import org.apache.hadoop.util.DiskValidatorFactory;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class LocalDirAllocator {
    private static Map<String, AllocatorPerContext> contexts = new TreeMap<String, AllocatorPerContext>();
    private String contextCfgItemName;
    public static final int SIZE_UNKNOWN = -1;
    private final DiskValidator diskValidator;

    public LocalDirAllocator(String contextCfgItemName) {
        this.contextCfgItemName = contextCfgItemName;
        try {
            this.diskValidator = DiskValidatorFactory.getInstance("basic");
        }
        catch (DiskChecker.DiskErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public LocalDirAllocator(String contextCfgItemName, DiskValidator diskValidator) {
        this.contextCfgItemName = contextCfgItemName;
        this.diskValidator = diskValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocatorPerContext obtainContext(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            AllocatorPerContext l = contexts.get(contextCfgItemName);
            if (l == null) {
                l = new AllocatorPerContext(contextCfgItemName, this.diskValidator);
                contexts.put(contextCfgItemName, l);
            }
            return l;
        }
    }

    public Path getLocalPathForWrite(String pathStr, Configuration conf) throws IOException {
        return this.getLocalPathForWrite(pathStr, -1L, conf);
    }

    public Path getLocalPathForWrite(String pathStr, long size, Configuration conf) throws IOException {
        return this.getLocalPathForWrite(pathStr, size, conf, true);
    }

    public Path getLocalPathForWrite(String pathStr, long size, Configuration conf, boolean checkWrite) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathForWrite(pathStr, size, conf, checkWrite);
    }

    public Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathToRead(pathStr, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Path> getAllLocalPathsToRead(String pathStr, Configuration conf) throws IOException {
        AllocatorPerContext context;
        LocalDirAllocator localDirAllocator = this;
        synchronized (localDirAllocator) {
            context = this.obtainContext(this.contextCfgItemName);
        }
        return context.getAllLocalPathsToRead(pathStr, conf);
    }

    public File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.createTmpFileForWrite(pathStr, size, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContextValid(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            return contexts.containsKey(contextCfgItemName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @InterfaceAudience.LimitedPrivate(value={"MapReduce"})
    public static void removeContext(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            contexts.remove(contextCfgItemName);
        }
    }

    public boolean ifExists(String pathStr, Configuration conf) {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.ifExists(pathStr, conf);
    }

    int getCurrentDirectoryIndex() {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getCurrentDirectoryIndex();
    }

    private static class AllocatorPerContext {
        private static final Logger LOG = LoggerFactory.getLogger(AllocatorPerContext.class);
        private Random dirIndexRandomizer = new Random();
        private String contextCfgItemName;
        private AtomicReference<Context> currentContext;
        private final DiskValidator diskValidator;

        public AllocatorPerContext(String contextCfgItemName, DiskValidator diskValidator) {
            this.contextCfgItemName = contextCfgItemName;
            this.currentContext = new AtomicReference<Context>(new Context());
            this.diskValidator = diskValidator;
        }

        private Context confChanged(Configuration conf) throws IOException {
            Context ctx = this.currentContext.get();
            String newLocalDirs = conf.get(this.contextCfgItemName);
            if (null == newLocalDirs) {
                throw new IOException(this.contextCfgItemName + " not configured");
            }
            if (!newLocalDirs.equals(ctx.savedLocalDirs)) {
                ctx = new Context();
                String[] dirStrings = StringUtils.getTrimmedStrings(newLocalDirs);
                ctx.localFS = FileSystem.getLocal(conf);
                int numDirs = dirStrings.length;
                ArrayList<Path> dirs = new ArrayList<Path>(numDirs);
                ArrayList<DF> dfList = new ArrayList<DF>(numDirs);
                for (int i = 0; i < numDirs; ++i) {
                    try {
                        Path tmpDir = new Path(dirStrings[i]);
                        if (ctx.localFS.mkdirs(tmpDir) || ctx.localFS.exists(tmpDir)) {
                            try {
                                File tmpFile = tmpDir.isAbsolute() ? new File(ctx.localFS.makeQualified(tmpDir).toUri()) : new File(dirStrings[i]);
                                this.diskValidator.checkStatus(tmpFile);
                                dirs.add(new Path(tmpFile.getPath()));
                                dfList.add(new DF(tmpFile, 30000L));
                            }
                            catch (DiskChecker.DiskErrorException de) {
                                LOG.warn(dirStrings[i] + " is not writable\n", de);
                            }
                            continue;
                        }
                        LOG.warn("Failed to create " + dirStrings[i]);
                        continue;
                    }
                    catch (IOException ie) {
                        LOG.warn("Failed to create " + dirStrings[i] + ": " + ie.getMessage() + "\n", ie);
                    }
                }
                Context.access$302(ctx, dirs.toArray(new Path[dirs.size()]));
                Context.access$402(ctx, dfList.toArray(new DF[dirs.size()]));
                ctx.savedLocalDirs = newLocalDirs;
                if (dirs.size() > 0) {
                    ctx.dirNumLastAccessed.set(this.dirIndexRandomizer.nextInt(dirs.size()));
                }
                this.currentContext.set(ctx);
            }
            return ctx;
        }

        private Path createPath(Path dir, String path, boolean checkWrite) throws IOException {
            Path file = new Path(dir, path);
            if (checkWrite) {
                try {
                    this.diskValidator.checkStatus(new File(file.getParent().toUri().getPath()));
                    return file;
                }
                catch (DiskChecker.DiskErrorException d) {
                    LOG.warn("Disk Error Exception: ", d);
                    return null;
                }
            }
            return file;
        }

        int getCurrentDirectoryIndex() {
            return this.currentContext.get().dirNumLastAccessed.get();
        }

        public Path getLocalPathForWrite(String pathStr, long size, Configuration conf, boolean checkWrite) throws IOException {
            Context ctx = this.confChanged(conf);
            int numDirs = ctx.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            Path returnPath = null;
            if (size == -1L) {
                long[] availableOnDisk = new long[ctx.dirDF.length];
                long totalAvailable = 0L;
                for (int i = 0; i < ctx.dirDF.length; ++i) {
                    availableOnDisk[i] = ctx.dirDF[i].getAvailable();
                    totalAvailable += availableOnDisk[i];
                }
                if (totalAvailable == 0L) {
                    throw new DiskChecker.DiskErrorException("No space available in any of the local directories.");
                }
                Random r = new Random();
                while (numDirsSearched < numDirs && returnPath == null) {
                    long randomPosition = (r.nextLong() >>> 1) % totalAvailable;
                    int dir = 0;
                    while (randomPosition > availableOnDisk[dir]) {
                        randomPosition -= availableOnDisk[dir];
                        ++dir;
                    }
                    ctx.dirNumLastAccessed.set(dir);
                    returnPath = this.createPath(ctx.localDirs[dir], pathStr, checkWrite);
                    if (returnPath != null) continue;
                    totalAvailable -= availableOnDisk[dir];
                    availableOnDisk[dir] = 0L;
                    ++numDirsSearched;
                }
            } else {
                int randomInc = 1;
                if (numDirs > 2) {
                    randomInc += this.dirIndexRandomizer.nextInt(numDirs - 1);
                }
                int dirNum = ctx.getAndIncrDirNumLastAccessed(randomInc);
                while (numDirsSearched < numDirs) {
                    long capacity = ctx.dirDF[dirNum].getAvailable();
                    if (capacity > size && (returnPath = this.createPath(ctx.localDirs[dirNum], pathStr, checkWrite)) != null) {
                        ctx.getAndIncrDirNumLastAccessed(numDirsSearched);
                        break;
                    }
                    ++dirNum;
                    dirNum %= numDirs;
                    ++numDirsSearched;
                }
            }
            if (returnPath != null) {
                return returnPath;
            }
            throw new DiskChecker.DiskErrorException("Could not find any valid local directory for " + pathStr);
        }

        public File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
            Path path = this.getLocalPathForWrite(pathStr, size, conf, true);
            File dir = new File(path.getParent().toUri().getPath());
            String prefix = path.getName();
            File result = File.createTempFile(prefix, null, dir);
            result.deleteOnExit();
            return result;
        }

        public Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
            Context ctx = this.confChanged(conf);
            int numDirs = ctx.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            while (numDirsSearched < numDirs) {
                Path file = new Path(ctx.localDirs[numDirsSearched], pathStr);
                if (ctx.localFS.exists(file)) {
                    return file;
                }
                ++numDirsSearched;
            }
            throw new DiskChecker.DiskErrorException("Could not find " + pathStr + " in any of the configured local directories");
        }

        Iterable<Path> getAllLocalPathsToRead(String pathStr, Configuration conf) throws IOException {
            Context ctx = this.confChanged(conf);
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            return new PathIterator(ctx.localFS, pathStr, ctx.localDirs);
        }

        public boolean ifExists(String pathStr, Configuration conf) {
            Context ctx = this.currentContext.get();
            try {
                int numDirs = ctx.localDirs.length;
                int numDirsSearched = 0;
                if (pathStr.startsWith("/")) {
                    pathStr = pathStr.substring(1);
                }
                while (numDirsSearched < numDirs) {
                    Path file = new Path(ctx.localDirs[numDirsSearched], pathStr);
                    if (ctx.localFS.exists(file)) {
                        return true;
                    }
                    ++numDirsSearched;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private static class PathIterator
        implements Iterator<Path>,
        Iterable<Path> {
            private final FileSystem fs;
            private final String pathStr;
            private int i = 0;
            private final Path[] rootDirs;
            private Path next = null;

            private PathIterator(FileSystem fs, String pathStr, Path[] rootDirs) throws IOException {
                this.fs = fs;
                this.pathStr = pathStr;
                this.rootDirs = rootDirs;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            private void advance() throws IOException {
                while (this.i < this.rootDirs.length) {
                    this.next = new Path(this.rootDirs[this.i++], this.pathStr);
                    if (!this.fs.exists(this.next)) continue;
                    return;
                }
                this.next = null;
            }

            @Override
            public Path next() {
                Path result = this.next;
                try {
                    this.advance();
                }
                catch (IOException ie) {
                    throw new RuntimeException("Can't check existence of " + this.next, ie);
                }
                if (result == null) {
                    throw new NoSuchElementException();
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only iterator");
            }

            @Override
            public Iterator<Path> iterator() {
                return this;
            }
        }

        private static class Context {
            private AtomicInteger dirNumLastAccessed = new AtomicInteger(0);
            private FileSystem localFS;
            private DF[] dirDF;
            private Path[] localDirs;
            private String savedLocalDirs;

            private Context() {
            }

            public int getAndIncrDirNumLastAccessed() {
                return this.getAndIncrDirNumLastAccessed(1);
            }

            public int getAndIncrDirNumLastAccessed(int delta) {
                int newval;
                int oldval;
                if (this.localDirs.length < 2 || delta == 0) {
                    return this.dirNumLastAccessed.get();
                }
                while (!this.dirNumLastAccessed.compareAndSet(oldval = this.dirNumLastAccessed.get(), newval = (oldval + delta) % this.localDirs.length)) {
                }
                return oldval;
            }

            static /* synthetic */ Path[] access$302(Context x0, Path[] x1) {
                x0.localDirs = x1;
                return x1;
            }

            static /* synthetic */ DF[] access$402(Context x0, DF[] x1) {
                x0.dirDF = x1;
                return x1;
            }
        }
    }
}

