/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.concurrent.HadoopScheduledThreadPoolExecutor;
import org.apache.hadoop.util.concurrent.HadoopThreadPoolExecutor;
import org.slf4j.Logger;

public final class HadoopExecutors {
    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new HadoopThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new HadoopThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new HadoopThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new HadoopScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new HadoopScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public static void shutdown(ExecutorService executorService, Logger logger, long timeout, TimeUnit unit) {
        if (executorService == null) {
            return;
        }
        try {
            executorService.shutdown();
            logger.debug("Gracefully shutting down executor service. Waiting max {} {}", (Object)timeout, (Object)unit);
            if (!executorService.awaitTermination(timeout, unit)) {
                logger.debug("Executor service has not shutdown yet. Forcing. Will wait up to an additional {} {} for shutdown", (Object)timeout, (Object)unit);
                executorService.shutdownNow();
            }
            if (executorService.awaitTermination(timeout, unit)) {
                logger.debug("Succesfully shutdown executor service");
            } else {
                logger.error("Unable to shutdown executor service after timeout {} {}", (Object)(2L * timeout), (Object)unit);
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while attempting to shutdown", e);
            executorService.shutdownNow();
        }
        catch (Exception e) {
            logger.warn("Exception closing executor service {}", (Object)e.getMessage());
            logger.debug("Exception closing executor service", e);
            throw e;
        }
    }

    private HadoopExecutors() {
    }
}

