/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JMethod;

public class Java2OMBuilder
implements Java2WSDLConstants {
    private TypeTable typeTable = null;
    private static int prefixCount = 1;
    private static final String NAMESPACE_PREFIX = "ns";
    private JMethod[] method;
    private Collection schemaCollection;
    private String serviceName;
    private String targetNamespace;
    private String targetNamespacePrefix;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private String style;
    private String use;
    private String locationURL;

    public Java2OMBuilder(JMethod[] method, Collection schemaCollection, TypeTable typeTab, String serviceName, String targetNamespace, String targetNamespacePrefix, String style, String use, String locationURL) {
        this.method = method;
        this.schemaCollection = schemaCollection;
        this.typeTable = typeTab;
        this.style = style == null ? "document" : style;
        this.use = use == null ? "literal" : use;
        this.locationURL = locationURL == null ? "http://localhost:8080/axis2/services/" : locationURL;
        this.serviceName = serviceName;
        this.targetNamespace = targetNamespace != null && targetNamespace.trim().length() != 0 ? targetNamespace : "http://ws.apache.org/axis2";
        this.targetNamespacePrefix = targetNamespacePrefix != null && targetNamespacePrefix.trim().length() != 0 ? targetNamespacePrefix : "axis2";
    }

    public OMElement generateOM() throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        ele.addAttribute("targetNamespace", this.targetNamespace, null);
        this.generateNamespaces(ele);
        this.generateTypes(fac, ele);
        this.generateMessages(fac, ele);
        this.generatePortType(fac, ele);
        this.generateBinding(fac, ele);
        this.generateService(fac, ele);
        return ele;
    }

    private void generateNamespaces(OMElement definitions) {
        this.soap = definitions.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.tns = definitions.declareNamespace(this.targetNamespace, this.targetNamespacePrefix);
        this.soap12 = definitions.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        definitions.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        definitions.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        definitions.declareNamespace(this.getSchemaTargetNamespace(), this.getSchemaTargetNamespacePrefix());
    }

    private void generateTypes(OMFactory fac, OMElement defintions) throws Exception {
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        Iterator iterator = this.schemaCollection.iterator();
        while (iterator.hasNext()) {
            StringWriter writer = new StringWriter();
            XmlSchema xmlSchema = (XmlSchema)iterator.next();
            xmlSchema.write((Writer)writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(schemaString.getBytes()));
            StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
            wsdlTypes.addChild((OMNode)staxOMBuilder.getDocumentElement());
        }
        defintions.addChild((OMNode)wsdlTypes);
    }

    private void generateMessages(OMFactory fac, OMElement definitions) {
        String namespaceURI;
        Hashtable<String, String> namespaceMap = new Hashtable<String, String>();
        for (int i = 0; i < this.method.length; ++i) {
            String namespacePrefix;
            JMethod jmethod = this.method[i];
            if (!jmethod.isPublic()) continue;
            OMElement requestMessge = fac.createOMElement("message", this.wsdl);
            requestMessge.addAttribute("name", jmethod.getSimpleName() + "Message", null);
            definitions.addChild((OMNode)requestMessge);
            QName messagePartType = this.typeTable.getComplexSchemaType(jmethod.getSimpleName());
            if (messagePartType != null) {
                namespaceURI = messagePartType.getNamespaceURI();
                namespacePrefix = messagePartType.getPrefix();
                if (namespacePrefix == null && (namespacePrefix = (String)namespaceMap.get(namespaceURI)) == null) {
                    namespacePrefix = this.generatePrefix();
                    namespaceMap.put(namespaceURI, namespacePrefix);
                }
                OMElement requestPart = fac.createOMElement("part", this.wsdl);
                requestMessge.addChild((OMNode)requestPart);
                requestPart.addAttribute("name", "part1", null);
                requestPart.addAttribute("element", namespacePrefix + ":" + jmethod.getSimpleName(), null);
            }
            if ((messagePartType = this.typeTable.getComplexSchemaType(jmethod.getSimpleName() + "Response")) != null) {
                namespaceURI = messagePartType.getNamespaceURI();
                namespacePrefix = messagePartType.getPrefix();
                if (namespacePrefix == null && (namespacePrefix = (String)namespaceMap.get(namespaceURI)) == null) {
                    namespacePrefix = this.generatePrefix();
                    namespaceMap.put(namespaceURI, namespacePrefix);
                }
                OMElement responseMessge = fac.createOMElement("message", this.wsdl);
                responseMessge.addAttribute("name", jmethod.getSimpleName() + "ResponseMessage", null);
                definitions.addChild((OMNode)responseMessge);
                OMElement responsePart = fac.createOMElement("part", this.wsdl);
                responseMessge.addChild((OMNode)responsePart);
                responsePart.addAttribute("name", "part1", null);
                responsePart.addAttribute("element", namespacePrefix + ":" + jmethod.getSimpleName() + "Response", null);
            }
            if (jmethod.getExceptionTypes().length <= 0) continue;
            JClass[] extypes = jmethod.getExceptionTypes();
            for (int j = 0; j < extypes.length; ++j) {
                JClass extype = extypes[j];
                String exname = extype.getSimpleName();
                String q_exname = extype.getQualifiedName();
                messagePartType = this.typeTable.getComplexSchemaType(q_exname);
                if (messagePartType == null) continue;
                namespaceURI = messagePartType.getNamespaceURI();
                namespacePrefix = messagePartType.getPrefix();
                if (namespacePrefix == null && (namespacePrefix = (String)namespaceMap.get(namespaceURI)) == null) {
                    namespacePrefix = this.generatePrefix();
                    namespaceMap.put(namespaceURI, namespacePrefix);
                }
                OMElement responseMessge = fac.createOMElement("message", this.wsdl);
                responseMessge.addAttribute("name", exname, null);
                definitions.addChild((OMNode)responseMessge);
                OMElement responsePart = fac.createOMElement("part", this.wsdl);
                responseMessge.addChild((OMNode)responsePart);
                responsePart.addAttribute("name", "part1", null);
                responsePart.addAttribute("element", namespacePrefix + ":" + exname, null);
            }
        }
        Enumeration enumeration = namespaceMap.keys();
        while (enumeration.hasMoreElements()) {
            namespaceURI = (String)enumeration.nextElement();
            definitions.declareNamespace(namespaceURI, (String)namespaceMap.get(namespaceURI));
        }
    }

    private void generatePortType(OMFactory fac, OMElement defintions) {
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        defintions.addChild((OMNode)portType);
        portType.addAttribute("name", this.serviceName + "PortType", null);
        for (int i = 0; i < this.method.length; ++i) {
            JMethod jmethod = this.method[i];
            if (!jmethod.isPublic()) continue;
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            portType.addChild((OMNode)operation);
            operation.addAttribute("name", jmethod.getSimpleName(), null);
            OMElement message = fac.createOMElement("input", this.wsdl);
            OMNamespace namespace = message.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
            message.addAttribute("Action", "urn:" + jmethod.getSimpleName(), namespace);
            message.addAttribute("message", this.tns.getPrefix() + ":" + jmethod.getSimpleName() + "Message", null);
            operation.addChild((OMNode)message);
            if (!jmethod.getReturnType().isVoidType()) {
                message = fac.createOMElement("output", this.wsdl);
                message.addAttribute("message", this.tns.getPrefix() + ":" + jmethod.getSimpleName() + "ResponseMessage", null);
                namespace = message.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
                message.addAttribute("Action", "urn:" + jmethod.getSimpleName(), namespace);
                operation.addChild((OMNode)message);
            }
            if (jmethod.getExceptionTypes().length <= 0) continue;
            JClass[] extypes = jmethod.getExceptionTypes();
            for (int j = 0; j < extypes.length; ++j) {
                JClass extype = extypes[j];
                String exname = extype.getSimpleName();
                message = fac.createOMElement("fault", this.wsdl);
                message.addAttribute("message", this.tns.getPrefix() + ":" + exname, null);
                message.addAttribute("name", exname, null);
                operation.addChild((OMNode)message);
            }
        }
    }

    public void generateService(OMFactory fac, OMElement defintions) {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild((OMNode)service);
        service.addAttribute("name", this.serviceName, null);
        OMElement port = fac.createOMElement("port", this.wsdl);
        service.addChild((OMNode)port);
        port.addAttribute("name", this.serviceName + "SOAP11port", null);
        port.addAttribute("binding", this.tns.getPrefix() + ":" + this.serviceName + "SOAP11Binding", null);
        this.addExtensionElement(fac, port, this.soap, "address", "location", this.locationURL + this.serviceName);
        port = fac.createOMElement("port", this.wsdl);
        service.addChild((OMNode)port);
        port.addAttribute("name", this.serviceName + "SOAP12port", null);
        port.addAttribute("binding", this.tns.getPrefix() + ":" + this.serviceName + "SOAP12Binding", null);
        this.addExtensionElement(fac, port, this.soap12, "address", "location", this.locationURL + this.serviceName);
    }

    private void generateBinding(OMFactory fac, OMElement defintions) {
        this.generateSoap11Binding(fac, defintions);
        this.generateSoap12Binding(fac, defintions);
    }

    private void generateSoap11Binding(OMFactory fac, OMElement defintions) {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.serviceName + "SOAP11Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        this.addExtensionElement(fac, binding, this.soap, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style);
        for (int i = 0; i < this.method.length; ++i) {
            JMethod jmethod = this.method[i];
            if (!jmethod.isPublic()) continue;
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            this.addExtensionElement(fac, operation, this.soap, "operation", "soapAction", "urn:" + jmethod.getSimpleName(), "style", this.style);
            operation.addAttribute("name", jmethod.getSimpleName(), null);
            OMElement input = fac.createOMElement("input", this.wsdl);
            this.addExtensionElement(fac, input, this.soap, "body", "use", this.use);
            operation.addChild((OMNode)input);
            if (!jmethod.getReturnType().isVoidType()) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElement(fac, output, this.soap, "body", "use", this.use);
                operation.addChild((OMNode)output);
            }
            if (jmethod.getExceptionTypes().length <= 0) continue;
            JClass[] extypes = jmethod.getExceptionTypes();
            for (int j = 0; j < extypes.length; ++j) {
                JClass extype = extypes[j];
                String exname = extype.getSimpleName();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                fault.addAttribute("name", exname, null);
                this.addExtensionElement(fac, fault, this.soap, "body", "use", this.use);
                operation.addChild((OMNode)fault);
            }
        }
    }

    private void generateSoap12Binding(OMFactory fac, OMElement defintions) {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.serviceName + "SOAP12Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        this.addExtensionElement(fac, binding, this.soap12, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style);
        for (int i = 0; i < this.method.length; ++i) {
            JMethod jmethod = this.method[i];
            if (!jmethod.isPublic()) continue;
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            operation.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
            this.addExtensionElement(fac, operation, this.soap12, "operation", "soapAction", "urn:" + jmethod.getSimpleName(), "style", this.style);
            operation.addAttribute("name", jmethod.getSimpleName(), null);
            OMElement input = fac.createOMElement("input", this.wsdl);
            this.addExtensionElement(fac, input, this.soap12, "body", "use", this.use);
            operation.addChild((OMNode)input);
            if (!jmethod.getReturnType().isVoidType()) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElement(fac, output, this.soap12, "body", "use", this.use);
                operation.addChild((OMNode)output);
            }
            if (jmethod.getExceptionTypes().length <= 0) continue;
            JClass[] extypes = jmethod.getExceptionTypes();
            for (int j = 0; j < extypes.length; ++j) {
                JClass extype = extypes[j];
                String exname = extype.getSimpleName();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                fault.addAttribute("name", exname, null);
                this.addExtensionElement(fac, fault, this.soap12, "body", "use", this.use);
                operation.addChild((OMNode)fault);
            }
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, OMNamespace namespace, String name, String att1Name, String att1Value, String att2Name, String att2Value) {
        OMElement soapbinding = fac.createOMElement(name, namespace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        soapbinding.addAttribute(att2Name, att2Value, null);
    }

    private void addExtensionElement(OMFactory fac, OMElement element, OMNamespace namespace, String name, String att1Name, String att1Value, String att2Name, String att2Value, String att3Name, String att3Value) {
        OMElement soapbinding = fac.createOMElement(name, namespace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        soapbinding.addAttribute(att2Name, att2Value, null);
        soapbinding.addAttribute(att3Name, att3Value, null);
    }

    private void addExtensionElement(OMFactory fac, OMElement element, OMNamespace namespace, String name, String att1Name, String att1Value) {
        OMElement soapbinding = fac.createOMElement(name, namespace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
    }

    private String generatePrefix() {
        return NAMESPACE_PREFIX + prefixCount++;
    }

    public String getSchemaTargetNamespace() {
        return this.schemaTargetNamespace;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    public String getSchemaTargetNamespacePrefix() {
        return this.schemaTargetNamespacePrefix;
    }

    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }
}

