/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeTable {
    private HashMap simpleTypetoxsd = new HashMap();
    private HashMap complexTypeMap = new HashMap();
    private static final Log log = LogFactory.getLog((Class)TypeTable.class);
    private static final QName ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xs");

    public TypeTable() {
        this.populateSimpleTypes();
    }

    private void populateSimpleTypes() {
        this.simpleTypetoxsd.put("int", new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        this.simpleTypetoxsd.put("java.lang.String", new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        this.simpleTypetoxsd.put("boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        this.simpleTypetoxsd.put("float", new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        this.simpleTypetoxsd.put("double", new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        this.simpleTypetoxsd.put("short", new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        this.simpleTypetoxsd.put("long", new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        this.simpleTypetoxsd.put("byte", new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        this.simpleTypetoxsd.put("char", ANY_TYPE);
        this.simpleTypetoxsd.put("java.lang.Integer", new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        this.simpleTypetoxsd.put("java.lang.Double", new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        this.simpleTypetoxsd.put("java.lang.Float", new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        this.simpleTypetoxsd.put("java.lang.Long", new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        this.simpleTypetoxsd.put("java.lang.Character", ANY_TYPE);
        this.simpleTypetoxsd.put("java.lang.Boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        this.simpleTypetoxsd.put("java.lang.Byte", new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        this.simpleTypetoxsd.put("java.lang.Short", new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        this.simpleTypetoxsd.put("java.util.Date", new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xs"));
        this.simpleTypetoxsd.put("java.util.Calendar", new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xs"));
        this.simpleTypetoxsd.put("java.math.BigDecimal", new QName("http://www.w3.org/2001/XMLSchema", "decimal", "xs"));
        this.simpleTypetoxsd.put("java.math.BigInteger", new QName("http://www.w3.org/2001/XMLSchema", "integer", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.Day", new QName("http://www.w3.org/2001/XMLSchema", "gDay", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.Duration", new QName("http://www.w3.org/2001/XMLSchema", "duration", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.Month", new QName("http://www.w3.org/2001/XMLSchema", "gMonth", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.MonthDay", new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.Time", new QName("http://www.w3.org/2001/XMLSchema", "time", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.Year", new QName("http://www.w3.org/2001/XMLSchema", "gYear", "xs"));
        this.simpleTypetoxsd.put("org.apache.axis2.databinding.types.YearMonth", new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth", "xs"));
        this.simpleTypetoxsd.put("java.lang.Object", ANY_TYPE);
        this.simpleTypetoxsd.put(OMElement.class.getName(), ANY_TYPE);
        this.simpleTypetoxsd.put(ArrayList.class.getName(), ANY_TYPE);
        this.simpleTypetoxsd.put(Vector.class.getName(), ANY_TYPE);
        this.simpleTypetoxsd.put(List.class.getName(), ANY_TYPE);
        this.simpleTypetoxsd.put(HashMap.class.getName(), ANY_TYPE);
        this.simpleTypetoxsd.put(Hashtable.class.getName(), ANY_TYPE);
        this.simpleTypetoxsd.put("base64Binary", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary", "xs"));
    }

    public QName getSimpleSchemaTypeName(String typeName) {
        QName qName = (QName)this.simpleTypetoxsd.get(typeName);
        if (qName == null && (typeName.startsWith("java.lang") || typeName.startsWith("javax."))) {
            return ANY_TYPE;
        }
        return qName;
    }

    public boolean isSimpleType(String typeName) {
        Iterator keys = this.simpleTypetoxsd.keySet().iterator();
        while (keys.hasNext()) {
            String s = (String)keys.next();
            if (!s.equals(typeName)) continue;
            return true;
        }
        return typeName.startsWith("java.lang") || typeName.startsWith("javax.");
    }

    public Map getComplexSchemaMap() {
        return this.complexTypeMap;
    }

    public void addComplexSchema(String name, QName schemaType) {
        this.complexTypeMap.put(name, schemaType);
    }

    public QName getComplexSchemaType(String name) {
        return (QName)this.complexTypeMap.get(name);
    }

    public QName getQNamefortheType(String typeName) {
        QName type = this.getSimpleSchemaTypeName(typeName);
        if (type == null) {
            type = this.getComplexSchemaType(typeName);
        }
        return type;
    }
}

