/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package javax.xml.soap;

/**
 * A <code>SOAPBodyElement</code> object represents the contents in a <code>SOAPBody</code> object.
 * The <code>SOAPFault</code> interface is a <code>SOAPBodyElement</code> object that has been
 * defined.
 * <p/>
 * A new <code>SOAPBodyElement</code> object can be created and added to a <code>SOAPBody</code>
 * object with the <code>SOAPBody</code> method <code>addBodyElement</code>. In the following line
 * of code, <code>sb</code> is a <code>SOAPBody</code> object, and <code>myName</code> is a
 * <code>Name</code> object. <PRE> SOAPBodyElement sbe = sb.addBodyElement(myName); </PRE>
 */
public interface SOAPBodyElement extends SOAPElement {
}
