/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.pubsub;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.pubsub.PubsubScopes;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.spark.streaming.pubsub.ServiceAccountCredentials$;
import org.apache.spark.streaming.pubsub.SparkGCPCredentials;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!B\u0001\u0003\u0005\na!!G*feZL7-Z!dG>,h\u000e^\"sK\u0012,g\u000e^5bYNT!a\u0001\u0003\u0002\rA,(m];c\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0003\u0001\u001bM9\"\u0004\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011AA\u0005\u0003-\t\u00111c\u00159be.<5\tU\"sK\u0012,g\u000e^5bYN\u0004\"A\u0004\r\n\u0005ey!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001dmI!\u0001H\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002\u0001\nAB[:p]\u001aKG.\u001a)bi\"\u001c\u0001!F\u0001\"!\rq!\u0005J\u0005\u0003G=\u0011aa\u00149uS>t\u0007CA\u0013)\u001d\tqa%\u0003\u0002(\u001f\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9s\u0002\u0003\u0005-\u0001\tE\t\u0015!\u0003\"\u00035Q7o\u001c8GS2,\u0007+\u0019;iA!Aa\u0006\u0001BK\u0002\u0013\u0005\u0001%A\u0006qcI2\u0015\u000e\\3QCRD\u0007\u0002\u0003\u0019\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\u0019A\f$GR5mKB\u000bG\u000f\u001b\u0011\t\u0011I\u0002!Q3A\u0005\u0002\u0001\nA\"Z7bS2\f5mY8v]RD\u0001\u0002\u000e\u0001\u0003\u0012\u0003\u0006I!I\u0001\u000eK6\f\u0017\u000e\\!dG>,h\u000e\u001e\u0011\t\u000bY\u0002A\u0011A\u001c\u0002\rqJg.\u001b;?)\u0011A\u0014HO\u001e\u0011\u0005Q\u0001\u0001b\u0002\u00106!\u0003\u0005\r!\t\u0005\b]U\u0002\n\u00111\u0001\"\u0011\u001d\u0011T\u0007%AA\u0002\u0005Bq!\u0010\u0001C\u0002\u0013%a(A\u0005gS2,')\u001f;fgV\tq\bE\u0002\u000f\u0001\nK!!Q\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00059\u0019\u0015B\u0001#\u0010\u0005\u0011\u0011\u0015\u0010^3\t\r\u0019\u0003\u0001\u0015!\u0003@\u0003)1\u0017\u000e\\3CsR,7\u000f\t\u0005\u0006\u0011\u0002!\t%S\u0001\taJ|g/\u001b3feV\t!\n\u0005\u0002L16\tAJ\u0003\u0002N\u001d\u00061q.Y;uQJR!a\u0014)\u0002\t\u0005,H\u000f\u001b\u0006\u0003#J\u000baa\u00197jK:$(BA*U\u0003\r\t\u0007/\u001b\u0006\u0003+Z\u000baaZ8pO2,'\"A,\u0002\u0007\r|W.\u0003\u0002Z\u0019\nQ1I]3eK:$\u0018.\u00197\t\u000bm\u0003A\u0011\u0002 \u0002\u001b\u001d,GOR5mK\n+hMZ3s\u0011\u001di\u0006!!A\u0005\u0002y\u000bAaY8qsR!\u0001h\u00181b\u0011\u001dqB\f%AA\u0002\u0005BqA\f/\u0011\u0002\u0003\u0007\u0011\u0005C\u000439B\u0005\t\u0019A\u0011\t\u000f\r\u0004\u0011\u0013!C\u0001I\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A3+\u0005\u000527&A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017!C;oG\",7m[3e\u0015\taw\"\u0001\u0006b]:|G/\u0019;j_:L!A\\5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004q\u0001E\u0005I\u0011\u00013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!9!\u000fAI\u0001\n\u0003!\u0017AD2paf$C-\u001a4bk2$He\r\u0005\bi\u0002\t\t\u0011\"\u0011v\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\ta\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!A.\u00198h\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!!\u000b=\t\u000fy\u0004\u0011\u0011!C\u0001\u007f\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0001\t\u0004\u001d\u0005\r\u0011bAA\u0003\u001f\t\u0019\u0011J\u001c;\t\u0013\u0005%\u0001!!A\u0005\u0002\u0005-\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002\u000f\u0003\u001fI1!!\u0005\u0010\u0005\r\te.\u001f\u0005\u000b\u0003+\t9!!AA\u0002\u0005\u0005\u0011a\u0001=%c!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00131D\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0004\t\u0007\u0003?\t)#!\u0004\u000e\u0005\u0005\u0005\"bAA\u0012\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011QF\u0001\tG\u0006tW)];bYR!\u0011qFA\u001b!\rq\u0011\u0011G\u0005\u0004\u0003gy!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003+\tI#!AA\u0002\u00055\u0001\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0001\u0011%\ty\u0004AA\u0001\n\u0003\n\t%\u0001\u0005u_N#(/\u001b8h)\u00051\b\"CA#\u0001\u0005\u0005I\u0011IA$\u0003\u0019)\u0017/^1mgR!\u0011qFA%\u0011)\t)\"a\u0011\u0002\u0002\u0003\u0007\u0011QB\u0004\u000b\u0003\u001b\u0012\u0011\u0011!E\u0001\u0005\u0005=\u0013!G*feZL7-Z!dG>,h\u000e^\"sK\u0012,g\u000e^5bYN\u00042\u0001FA)\r%\t!!!A\t\u0002\t\t\u0019fE\u0003\u0002R\u0005U#\u0004\u0005\u0005\u0002X\u0005u\u0013%I\u00119\u001b\t\tIFC\u0002\u0002\\=\tqA];oi&lW-\u0003\u0003\u0002`\u0005e#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9a'!\u0015\u0005\u0002\u0005\rDCAA(\u0011)\ty$!\u0015\u0002\u0002\u0013\u0015\u0013\u0011\t\u0005\u000b\u0003S\n\t&!A\u0005\u0002\u0006-\u0014!B1qa2LHc\u0002\u001d\u0002n\u0005=\u0014\u0011\u000f\u0005\t=\u0005\u001d\u0004\u0013!a\u0001C!Aa&a\u001a\u0011\u0002\u0003\u0007\u0011\u0005\u0003\u00053\u0003O\u0002\n\u00111\u0001\"\u0011)\t)(!\u0015\u0002\u0002\u0013\u0005\u0015qO\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI(!!\u0011\t9\u0011\u00131\u0010\t\u0007\u001d\u0005u\u0014%I\u0011\n\u0007\u0005}tB\u0001\u0004UkBdWm\r\u0005\n\u0003\u0007\u000b\u0019(!AA\u0002a\n1\u0001\u001f\u00131\u0011%\t9)!\u0015\u0012\u0002\u0013\u0005A-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0005\n\u0003\u0017\u000b\t&%A\u0005\u0002\u0011\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004\"CAH\u0003#\n\n\u0011\"\u0001e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u00111SA)#\u0003%\t\u0001Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%c!I\u0011qSA)#\u0003%\t\u0001Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111TA)#\u0003%\t\u0001Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011qTA)\u0003\u0003%I!!)\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003G\u00032a^AS\u0013\r\t9\u000b\u001f\u0002\u0007\u001f\nTWm\u0019;")
public final class ServiceAccountCredentials
implements SparkGCPCredentials,
Product {
    private final Option<String> jsonFilePath;
    private final Option<String> p12FilePath;
    private final Option<String> emailAccount;
    private final byte[] fileBytes;

    public static Option<String> apply$default$3() {
        return ServiceAccountCredentials$.MODULE$.apply$default$3();
    }

    public static Option<String> apply$default$2() {
        return ServiceAccountCredentials$.MODULE$.apply$default$2();
    }

    public static Option<String> apply$default$1() {
        return ServiceAccountCredentials$.MODULE$.apply$default$1();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ServiceAccountCredentials$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return ServiceAccountCredentials$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<String> $lessinit$greater$default$1() {
        return ServiceAccountCredentials$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple3<Option<String>, Option<String>, Option<String>>> unapply(ServiceAccountCredentials serviceAccountCredentials) {
        return ServiceAccountCredentials$.MODULE$.unapply(serviceAccountCredentials);
    }

    public static ServiceAccountCredentials apply(Option<String> option, Option<String> option2, Option<String> option3) {
        return ServiceAccountCredentials$.MODULE$.apply(option, option2, option3);
    }

    public static Function1<Tuple3<Option<String>, Option<String>, Option<String>>, ServiceAccountCredentials> tupled() {
        return ServiceAccountCredentials$.MODULE$.tupled();
    }

    public static Function1<Option<String>, Function1<Option<String>, Function1<Option<String>, ServiceAccountCredentials>>> curried() {
        return ServiceAccountCredentials$.MODULE$.curried();
    }

    public Option<String> jsonFilePath() {
        return this.jsonFilePath;
    }

    public Option<String> p12FilePath() {
        return this.p12FilePath;
    }

    public Option<String> emailAccount() {
        return this.emailAccount;
    }

    private byte[] fileBytes() {
        return this.fileBytes;
    }

    @Override
    public Credential provider() {
        Credential credential;
        JacksonFactory jsonFactory = new JacksonFactory();
        ArrayList scopes = new ArrayList(PubsubScopes.all());
        HttpTransport transport = HttpTransportFactory.createHttpTransport((HttpTransportFactory.HttpTransportType)HttpTransportFactory.HttpTransportType.JAVA_NET, null);
        if (this.jsonFilePath().isEmpty()) {
            if (this.p12FilePath().isEmpty() || this.emailAccount().isEmpty()) {
                credential = new CredentialFactory().getCredentialFromMetadataServiceAccount();
            } else {
                File tempFile = File.createTempFile((String)this.emailAccount().get(), ".p12");
                tempFile.deleteOnExit();
                FileOutputStream p12Out = new FileOutputStream(tempFile);
                p12Out.write(this.fileBytes(), 0, this.fileBytes().length);
                p12Out.close();
                credential = new CredentialFactory.GoogleCredentialWithRetry(new GoogleCredential.Builder().setTransport(transport).setJsonFactory((JsonFactory)jsonFactory).setServiceAccountId((String)this.emailAccount().get()).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(tempFile).setRequestInitializer((HttpRequestInitializer)new CredentialFactory.CredentialHttpRetryInitializer()));
            }
        } else {
            ByteArrayInputStream stream = new ByteArrayInputStream(this.fileBytes());
            credential = CredentialFactory.GoogleCredentialWithRetry.fromGoogleCredential((GoogleCredential)GoogleCredential.fromStream((InputStream)stream, (HttpTransport)transport, (JsonFactory)jsonFactory).createScoped(scopes));
        }
        return credential;
    }

    private byte[] getFileBuffer() {
        Option filePath;
        block4: {
            byte[] byArray;
            block3: {
                block2: {
                    filePath = this.jsonFilePath().orElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ServiceAccountCredentials $outer;

                        public final Option<String> apply() {
                            return this.$outer.p12FilePath();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (!filePath.isEmpty()) break block2;
                    byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
                    break block3;
                }
                if (!Files.exists(Paths.get((String)filePath.get(), new String[0]), new LinkOption[0])) break block4;
                byArray = Files.readAllBytes(Paths.get((String)filePath.get(), new String[0]));
            }
            return byArray;
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The key file path(", ") doesn't exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath.get()})));
    }

    public ServiceAccountCredentials copy(Option<String> jsonFilePath, Option<String> p12FilePath, Option<String> emailAccount) {
        return new ServiceAccountCredentials(jsonFilePath, p12FilePath, emailAccount);
    }

    public Option<String> copy$default$1() {
        return this.jsonFilePath();
    }

    public Option<String> copy$default$2() {
        return this.p12FilePath();
    }

    public Option<String> copy$default$3() {
        return this.emailAccount();
    }

    public String productPrefix() {
        return "ServiceAccountCredentials";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                option = this.emailAccount();
                break;
            }
            case 1: {
                option = this.p12FilePath();
                break;
            }
            case 0: {
                option = this.jsonFilePath();
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServiceAccountCredentials;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ServiceAccountCredentials)) return false;
        boolean bl = true;
        if (!bl) return false;
        ServiceAccountCredentials serviceAccountCredentials = (ServiceAccountCredentials)x$1;
        Option<String> option = this.jsonFilePath();
        Option<String> option2 = serviceAccountCredentials.jsonFilePath();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.p12FilePath();
        Option<String> option4 = serviceAccountCredentials.p12FilePath();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.emailAccount();
        Option<String> option6 = serviceAccountCredentials.emailAccount();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public ServiceAccountCredentials(Option<String> jsonFilePath, Option<String> p12FilePath, Option<String> emailAccount) {
        this.jsonFilePath = jsonFilePath;
        this.p12FilePath = p12FilePath;
        this.emailAccount = emailAccount;
        Product.class.$init$((Product)this);
        this.fileBytes = this.getFileBuffer();
    }
}

