/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.services.thread;

import java.util.Properties;
import javax.batch.runtime.context.StepContext;
import javax.transaction.UserTransaction;
import org.apache.batchee.container.util.ExceptionUtil;
import org.apache.batchee.spi.TransactionManagementService;
import org.apache.batchee.spi.TransactionManagerAdapter;
import org.apache.batchee.tools.services.thread.ThreadExecutorEjb;

public class UserTransactionTransactionService
implements TransactionManagementService {
    public void init(Properties batchConfig) {
    }

    public TransactionManagerAdapter getTransactionManager(StepContext stepContext) {
        UserTransaction ut = ThreadExecutorEjb.getUserTransaction();
        return new UserTransactionTxAdapter(ut);
    }

    private static class UserTransactionTxAdapter
    implements TransactionManagerAdapter {
        private final UserTransaction ut;

        private UserTransactionTxAdapter(UserTransaction ut) {
            this.ut = ut;
        }

        public void begin() {
            try {
                this.ut.begin();
            }
            catch (Exception e) {
                ExceptionUtil.throwAsRuntimeException((Throwable)e);
            }
        }

        public void commit() {
            try {
                this.ut.commit();
            }
            catch (Exception e) {
                ExceptionUtil.throwAsRuntimeException((Throwable)e);
            }
        }

        public int getStatus() {
            try {
                return this.ut.getStatus();
            }
            catch (Exception e) {
                throw ExceptionUtil.throwAsRuntimeException((Throwable)e);
            }
        }

        public void rollback() {
            try {
                this.ut.rollback();
            }
            catch (Exception e) {
                ExceptionUtil.throwAsRuntimeException((Throwable)e);
            }
        }

        public void setRollbackOnly() {
            try {
                this.ut.setRollbackOnly();
            }
            catch (Exception e) {
                ExceptionUtil.throwAsRuntimeException((Throwable)e);
            }
        }

        public void setTransactionTimeout(int timeout) {
            try {
                this.ut.setTransactionTimeout(timeout);
            }
            catch (Exception e) {
                ExceptionUtil.throwAsRuntimeException((Throwable)e);
            }
        }
    }
}

