/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1.io.grpc.inprocess;

import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.vendor.grpc.v1.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1.io.grpc.Internal;
import org.apache.beam.vendor.grpc.v1.io.grpc.inprocess.InProcessSocketAddress;
import org.apache.beam.vendor.grpc.v1.io.grpc.inprocess.InProcessTransport;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.AbstractManagedChannelImplBuilder;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.ClientTransportFactory;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.ConnectionClientTransport;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.GrpcUtil;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.ProxyParameters;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.SharedResourceHolder;
import org.apache.beam.vendor.guava.v20.com.google.common.base.Preconditions;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;
    private ScheduledExecutorService scheduledExecutorService;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    public static InProcessChannelBuilder forTarget(String target) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    public static InProcessChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    private InProcessChannelBuilder(String name) {
        super(new InProcessSocketAddress(name), "localhost");
        this.name = Preconditions.checkNotNull(name, "name");
        this.setStatsRecordStartedRpcs(false);
        this.setStatsRecordFinishedRpcs(false);
    }

    @Override
    public final InProcessChannelBuilder maxInboundMessageSize(int max) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max);
    }

    @Override
    public InProcessChannelBuilder useTransportSecurity() {
        return this;
    }

    @Override
    @Deprecated
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    public InProcessChannelBuilder usePlaintext() {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveWithoutCalls(boolean enable) {
        return this;
    }

    public InProcessChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService");
        return this;
    }

    @Override
    @Internal
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name, this.scheduledExecutorService);
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final String name;
        private final ScheduledExecutorService timerService;
        private final boolean useSharedTimer;
        private boolean closed;

        private InProcessClientTransportFactory(String name, @Nullable ScheduledExecutorService scheduledExecutorService) {
            this.name = name;
            this.useSharedTimer = scheduledExecutorService == null;
            this.timerService = this.useSharedTimer ? SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE) : scheduledExecutorService;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, String authority, String userAgent, ProxyParameters proxy) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(this.name, authority, userAgent);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timerService;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.useSharedTimer) {
                SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timerService);
            }
        }
    }
}

