/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.FnService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Server;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;

public class GrpcFnServer<ServiceT extends FnService>
implements AutoCloseable {
    private final Server server;
    private final ServiceT service;
    private final Endpoints.ApiServiceDescriptor apiServiceDescriptor;

    public static <ServiceT extends FnService> GrpcFnServer<ServiceT> allocatePortAndCreateFor(ServiceT service, ServerFactory factory) throws IOException {
        Endpoints.ApiServiceDescriptor.Builder apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder();
        Server server = factory.allocateAddressAndCreate((List<BindableService>)ImmutableList.of(service), apiServiceDescriptor);
        return new GrpcFnServer<ServiceT>(server, service, apiServiceDescriptor.build());
    }

    public static <ServiceT extends FnService> GrpcFnServer<ServiceT> create(ServiceT service, Endpoints.ApiServiceDescriptor endpoint, ServerFactory factory) throws IOException {
        return new GrpcFnServer<ServiceT>(factory.create((List<BindableService>)ImmutableList.of(service), endpoint), service, endpoint);
    }

    @Deprecated
    public static <ServiceT extends FnService> GrpcFnServer<ServiceT> create(ServiceT service, Endpoints.ApiServiceDescriptor endpoint) {
        return new GrpcFnServer(null, service, endpoint){

            @Override
            public void close() throws Exception {
            }
        };
    }

    private GrpcFnServer(Server server, ServiceT service, Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
        this.server = server;
        this.service = service;
        this.apiServiceDescriptor = apiServiceDescriptor;
    }

    public Endpoints.ApiServiceDescriptor getApiServiceDescriptor() {
        return this.apiServiceDescriptor;
    }

    public ServiceT getService() {
        return this.service;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public void close() throws Exception {
        try {
            this.server.shutdown();
            this.service.close();
            this.server.awaitTermination(60L, TimeUnit.SECONDS);
        }
        finally {
            this.server.shutdownNow();
            this.server.awaitTermination();
        }
    }

    /* synthetic */ GrpcFnServer(Server x0, FnService x1, Endpoints.ApiServiceDescriptor x2, 1 x3) {
        this(x0, x1, x2);
    }
}

