/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.beam.vendor.grpc.v1p13p1.io.netty.channel.unix.DomainSocketAddress;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.net.HostAndPort;

public class SocketAddressFactory {
    private static final String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";

    public static SocketAddress createFrom(String value) {
        if (value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            String filePath = value.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
            File file = new File(filePath);
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("File path must be absolute: " + filePath);
            }
            try {
                if (file.createNewFile()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new DomainSocketAddress(file);
        }
        HostAndPort hostAndPort = HostAndPort.fromString((String)value);
        Preconditions.checkArgument((boolean)hostAndPort.hasPort(), (String)"Address must be a unix:// path or be in the form host:port. Got: %s", (Object)value);
        return new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort());
    }
}

