/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.repackaged.beam_runners_direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.ImmutableListBundleFactory;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.joda.time.Instant;

class CloningBundleFactory
implements BundleFactory {
    private static final CloningBundleFactory INSTANCE = new CloningBundleFactory();
    private final ImmutableListBundleFactory underlying = ImmutableListBundleFactory.create();

    public static CloningBundleFactory create() {
        return INSTANCE;
    }

    private CloningBundleFactory() {
    }

    @Override
    public <T> UncommittedBundle<T> createRootBundle() {
        return this.underlying.createRootBundle();
    }

    @Override
    public <T> UncommittedBundle<T> createBundle(PCollection<T> output) {
        return new CloningBundle(this.underlying.createBundle(output));
    }

    @Override
    public <K, T> UncommittedBundle<T> createKeyedBundle(StructuralKey<K> key, PCollection<T> output) {
        return new CloningBundle(this.underlying.createKeyedBundle(key, output));
    }

    private static class CloningBundle<T>
    implements UncommittedBundle<T> {
        private final UncommittedBundle<T> underlying;
        private final Coder<T> coder;

        private CloningBundle(UncommittedBundle<T> underlying) {
            this.underlying = underlying;
            this.coder = underlying.getPCollection().getCoder();
        }

        @Override
        public PCollection<T> getPCollection() {
            return this.underlying.getPCollection();
        }

        @Override
        public UncommittedBundle<T> add(WindowedValue<T> element) {
            try {
                WindowedValue clone = element.withValue(CoderUtils.clone(this.coder, (Object)element.getValue()));
                this.underlying.add(clone);
            }
            catch (CoderException e) {
                throw UserCodeException.wrap((Throwable)e);
            }
            return this;
        }

        @Override
        public CommittedBundle<T> commit(Instant synchronizedProcessingTime) {
            return this.underlying.commit(synchronizedProcessingTime);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Data", (Object)this.underlying.toString()).add("Coder", (Object)this.coder.toString()).toString();
        }
    }
}

