/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import java.util.function.Consumer;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.FnDataReceiver;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.UncommittedBundle;
import org.apache.beam.sdk.util.WindowedValue;

class BundleFactoryOutputReceiverFactory
implements OutputReceiverFactory {
    private final BundleFactory bundleFactory;
    private final RunnerApi.Components components;
    private final Consumer<UncommittedBundle<?>> bundleConsumer;

    private BundleFactoryOutputReceiverFactory(BundleFactory bundleFactory, RunnerApi.Components components, Consumer<UncommittedBundle<?>> bundleConsumer) {
        this.bundleFactory = bundleFactory;
        this.components = components;
        this.bundleConsumer = bundleConsumer;
    }

    public static OutputReceiverFactory create(BundleFactory bundleFactory, RunnerApi.Components components, Consumer<UncommittedBundle<?>> resultBuilder) {
        return new BundleFactoryOutputReceiverFactory(bundleFactory, components, resultBuilder);
    }

    @Override
    public <OutputT> FnDataReceiver<OutputT> create(String pCollectionId) {
        PipelineNode.PCollectionNode pcollection = PipelineNode.pCollection(pCollectionId, this.components.getPcollectionsOrThrow(pCollectionId));
        return this.create(pcollection);
    }

    private <ElemT, OutputT> FnDataReceiver<OutputT> create(PipelineNode.PCollectionNode pcollection) {
        UncommittedBundle bundle = this.bundleFactory.createBundle(pcollection);
        this.bundleConsumer.accept(bundle);
        return input -> bundle.add((WindowedValue)input);
    }
}

