/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import com.google.auto.value.AutoValue;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.portable.AutoValue_ImmutableListBundleFactory_CommittedImmutableListBundle;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.UncommittedBundle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class ImmutableListBundleFactory
implements BundleFactory {
    private static final ImmutableListBundleFactory FACTORY = new ImmutableListBundleFactory();

    public static ImmutableListBundleFactory create() {
        return FACTORY;
    }

    private ImmutableListBundleFactory() {
    }

    @Override
    public <T> UncommittedBundle<T> createRootBundle() {
        return UncommittedImmutableListBundle.create(null, StructuralKey.empty());
    }

    @Override
    public <T> UncommittedBundle<T> createBundle(PipelineNode.PCollectionNode output) {
        return UncommittedImmutableListBundle.create(output, StructuralKey.empty());
    }

    @Override
    public <K, T> UncommittedBundle<T> createKeyedBundle(StructuralKey<K> key, PipelineNode.PCollectionNode output) {
        return UncommittedImmutableListBundle.create(output, key);
    }

    private static Instant minTimestamp(Iterable<? extends WindowedValue<?>> elements) {
        Instant minTs = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (WindowedValue<?> element : elements) {
            if (!element.getTimestamp().isBefore((ReadableInstant)minTs)) continue;
            minTs = element.getTimestamp();
        }
        return minTs;
    }

    @AutoValue
    static abstract class CommittedImmutableListBundle<T>
    implements CommittedBundle<T> {
        CommittedImmutableListBundle() {
        }

        public static <T> CommittedImmutableListBundle<T> create(@Nullable PipelineNode.PCollectionNode pcollection, StructuralKey<?> key, Iterable<WindowedValue<T>> committedElements, Instant minElementTimestamp, Instant synchronizedCompletionTime) {
            return new AutoValue_ImmutableListBundleFactory_CommittedImmutableListBundle<T>(pcollection, key, committedElements, minElementTimestamp, synchronizedCompletionTime);
        }

        @Override
        @Nonnull
        public Iterator<WindowedValue<T>> iterator() {
            return this.getElements().iterator();
        }

        @Override
        public CommittedBundle<T> withElements(Iterable<WindowedValue<T>> elements) {
            return CommittedImmutableListBundle.create(this.getPCollection(), this.getKey(), ImmutableList.copyOf(elements), ImmutableListBundleFactory.minTimestamp(elements), this.getSynchronizedProcessingOutputWatermark());
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    private static final class UncommittedImmutableListBundle<T>
    implements UncommittedBundle<T> {
        private final PipelineNode.PCollectionNode pcollection;
        private final StructuralKey<?> key;
        private boolean committed = false;
        private ImmutableList.Builder<WindowedValue<T>> elements;
        private Instant minSoFar = BoundedWindow.TIMESTAMP_MAX_VALUE;

        public static <T> UncommittedImmutableListBundle<T> create(PipelineNode.PCollectionNode pcollection, StructuralKey<?> key) {
            return new UncommittedImmutableListBundle<T>(pcollection, key);
        }

        private UncommittedImmutableListBundle(PipelineNode.PCollectionNode pcollection, StructuralKey<?> key) {
            this.pcollection = pcollection;
            this.key = key;
            this.elements = ImmutableList.builder();
        }

        @Override
        public PipelineNode.PCollectionNode getPCollection() {
            return this.pcollection;
        }

        @Override
        public UncommittedImmutableListBundle<T> add(WindowedValue<T> element) {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (String)"Can't add element %s to committed bundle in PCollection %s", element, (Object)this.pcollection);
            Preconditions.checkArgument((boolean)element.getTimestamp().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), (String)"Can't add an element past the end of time (%s), got timestamp %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)element.getTimestamp());
            this.elements.add(element);
            if (element.getTimestamp().isBefore((ReadableInstant)this.minSoFar)) {
                this.minSoFar = element.getTimestamp();
            }
            return this;
        }

        @Override
        public CommittedBundle<T> commit(Instant synchronizedCompletionTime) {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (String)"Can't commit already committed bundle %s", (Object)this);
            this.committed = true;
            ImmutableList committedElements = this.elements.build();
            return CommittedImmutableListBundle.create(this.pcollection, this.key, committedElements, this.minSoFar, synchronizedCompletionTime);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("elements", (Object)this.elements.build()).toString();
        }
    }
}

