/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable.artifact;

import java.io.File;
import java.io.IOException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

class LocalArtifactStagingLocation {
    private final File rootDirectory;
    private final File artifactsDirectory;

    public static LocalArtifactStagingLocation createAt(File rootDirectory) {
        return new LocalArtifactStagingLocation(rootDirectory).createDirectories();
    }

    public static LocalArtifactStagingLocation forExistingDirectory(File rootDirectory) {
        return new LocalArtifactStagingLocation(rootDirectory).verifyExistence();
    }

    private LocalArtifactStagingLocation(File base) {
        this.rootDirectory = base;
        this.artifactsDirectory = new File(base, "artifacts");
    }

    private LocalArtifactStagingLocation createDirectories() {
        if (!((this.rootDirectory.exists() && this.rootDirectory.isDirectory() || this.rootDirectory.mkdirs()) && this.rootDirectory.canWrite())) {
            throw new IllegalStateException(String.format("Could not create staging directory structure at root %s", this.rootDirectory));
        }
        Preconditions.checkState(((this.artifactsDirectory.exists() && this.artifactsDirectory.isDirectory() || this.artifactsDirectory.mkdir()) && this.artifactsDirectory.canWrite() ? 1 : 0) != 0, (String)"Could not create artifact staging directory at %s", (Object)this.artifactsDirectory);
        return this;
    }

    private LocalArtifactStagingLocation verifyExistence() {
        Preconditions.checkArgument((boolean)this.rootDirectory.exists(), (String)"Nonexistent staging location root %s", (Object)this.rootDirectory);
        Preconditions.checkArgument((boolean)this.rootDirectory.isDirectory(), (String)"Staging location %s is not a directory", (Object)this.rootDirectory);
        Preconditions.checkArgument((boolean)this.artifactsDirectory.exists(), (String)"Nonexistent artifact directory %s", (Object)this.artifactsDirectory);
        Preconditions.checkArgument((boolean)this.artifactsDirectory.isDirectory(), (String)"Artifact location %s is not a directory", (Object)this.artifactsDirectory);
        Preconditions.checkArgument((boolean)this.getManifestFile().exists(), (String)"No Manifest in existing location %s", (Object)this.rootDirectory);
        return this;
    }

    public File getArtifactFile(String artifactName) {
        return new File(this.artifactsDirectory, artifactName);
    }

    public File getManifestFile() {
        return new File(this.rootDirectory, "MANIFEST");
    }

    public String getRootPath() {
        try {
            return this.rootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

