/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable.job;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.runners.direct.portable.job.ReferenceRunnerJobService;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceRunnerJobServer {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceRunnerJobServer.class);
    private final ServerConfiguration configuration;
    private GrpcFnServer<ReferenceRunnerJobService> server;

    private ReferenceRunnerJobServer(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public static void main(String[] args) throws Exception {
        try {
            ReferenceRunnerJobServer.runServer(ReferenceRunnerJobServer.parseConfiguration(args));
        }
        catch (CmdLineException cmdLineException) {
            // empty catch block
        }
    }

    private static ServerConfiguration parseConfiguration(String[] args) throws CmdLineException {
        ServerConfiguration configuration = new ServerConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            e.printStackTrace(System.err);
            ReferenceRunnerJobServer.printUsage(parser);
            throw e;
        }
        return configuration;
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println(String.format("Usage: java %s arguments...", ReferenceRunnerJobService.class.getSimpleName()));
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    private static void runServer(ServerConfiguration configuration) throws Exception {
        ServerFactory serverFactory = ServerFactory.createDefault();
        ReferenceRunnerJobService.Configuration jobServiceConfig = ReferenceRunnerJobServer.createJobServiceConfig(configuration);
        ReferenceRunnerJobService service = ReferenceRunnerJobService.create(serverFactory, jobServiceConfig);
        try (GrpcFnServer<ReferenceRunnerJobService> server = ReferenceRunnerJobServer.createServer(configuration, serverFactory, service);){
            System.out.println(String.format("Started %s at %s", ReferenceRunnerJobService.class.getSimpleName(), server.getApiServiceDescriptor().getUrl()));
            server.getServer().awaitTermination();
        }
        System.out.println("Server shut down, exiting");
    }

    public static ReferenceRunnerJobServer fromParams(String[] args) {
        try {
            return new ReferenceRunnerJobServer(ReferenceRunnerJobServer.parseConfiguration(args));
        }
        catch (CmdLineException e) {
            throw new IllegalArgumentException("Unable to parse command line arguments " + Arrays.asList(args), e);
        }
    }

    public String start() throws Exception {
        ServerFactory serverFactory = ServerFactory.createDefault();
        ReferenceRunnerJobService.Configuration jobServiceConfig = ReferenceRunnerJobServer.createJobServiceConfig(this.configuration);
        this.server = ReferenceRunnerJobServer.createServer(this.configuration, serverFactory, ReferenceRunnerJobService.create(serverFactory, jobServiceConfig));
        return this.server.getApiServiceDescriptor().getUrl();
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception e) {
                LOG.error("Unable to stop job server.", (Throwable)e);
            }
        }
    }

    private static GrpcFnServer<ReferenceRunnerJobService> createServer(ServerConfiguration configuration, ServerFactory serverFactory, ReferenceRunnerJobService service) throws IOException {
        if (configuration.port <= 0) {
            return GrpcFnServer.allocatePortAndCreateFor(service, serverFactory);
        }
        return GrpcFnServer.create(service, Endpoints.ApiServiceDescriptor.newBuilder().setUrl("localhost:" + configuration.port).build(), serverFactory);
    }

    private static ReferenceRunnerJobService.Configuration createJobServiceConfig(ServerConfiguration configuration) {
        ReferenceRunnerJobService.Configuration jobServiceConfig = new ReferenceRunnerJobService.Configuration();
        jobServiceConfig.artifactStagingPath = configuration.artifactStagingPath;
        jobServiceConfig.keepArtifacts = configuration.keepArtifacts;
        return jobServiceConfig;
    }

    public static class ServerConfiguration {
        @Option(name="-p", aliases={"--port"}, usage="The local port to expose the server on. 0 to use a dynamic port. (Default: 8099)")
        private int port = 8099;
        @Option(name="--artifacts-dir", usage="The location to store staged artifact files")
        String artifactStagingPath = Paths.get(System.getProperty("java.io.tmpdir"), "beam-artifact-staging").toString();
        @Option(name="--keep-artifacts", usage="When enabled, do not delete staged artifacts when a job completes")
        boolean keepArtifacts;
    }
}

