/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable.job;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.FnService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.artifact.BeamFileSystemArtifactStagingService;
import org.apache.beam.runners.direct.portable.ReferenceRunner;
import org.apache.beam.runners.direct.portable.job.PreparingJob;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceRunnerJobService
extends JobServiceGrpc.JobServiceImplBase
implements FnService {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceRunnerJobService.class);
    private static final int WAIT_MS = 1000;
    private final ServerFactory serverFactory;
    private final Configuration configuration;
    private final ConcurrentMap<String, PreparingJob> unpreparedJobs;
    private final ConcurrentMap<String, ReferenceRunner> runningJobs;
    private final ConcurrentMap<String, JobApi.JobState.Enum> jobStates;
    private final ExecutorService executor;
    private final ConcurrentLinkedQueue<GrpcFnServer<BeamFileSystemArtifactStagingService>> artifactStagingServices;

    public static ReferenceRunnerJobService create(ServerFactory serverFactory, Configuration configuration) {
        LOG.info("Starting {}", ReferenceRunnerJobService.class);
        return new ReferenceRunnerJobService(serverFactory, configuration);
    }

    private ReferenceRunnerJobService(ServerFactory serverFactory, Configuration configuration) {
        this.serverFactory = serverFactory;
        this.configuration = configuration;
        this.unpreparedJobs = new ConcurrentHashMap<String, PreparingJob>();
        this.runningJobs = new ConcurrentHashMap<String, ReferenceRunner>();
        this.jobStates = new ConcurrentHashMap<String, JobApi.JobState.Enum>();
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("reference-runner-pipeline-%s").build());
        this.artifactStagingServices = new ConcurrentLinkedQueue();
    }

    public void prepare(JobApi.PrepareJobRequest request, StreamObserver<JobApi.PrepareJobResponse> responseObserver) {
        try {
            LOG.trace("{} {}", (Object)JobApi.PrepareJobResponse.class.getSimpleName(), (Object)request);
            String preparationId = request.getJobName() + ThreadLocalRandom.current().nextInt();
            GrpcFnServer<BeamFileSystemArtifactStagingService> artifactStagingService = this.createArtifactStagingService();
            this.artifactStagingServices.add(artifactStagingService);
            String stagingSessionToken = BeamFileSystemArtifactStagingService.generateStagingSessionToken(preparationId, this.configuration.artifactStagingPath);
            PreparingJob existingJob = this.unpreparedJobs.putIfAbsent(preparationId, PreparingJob.builder().setArtifactStagingServer(artifactStagingService).setPipeline(request.getPipeline()).setOptions(request.getPipelineOptions()).setStagingSessionToken(stagingSessionToken).build());
            Preconditions.checkArgument((existingJob == null ? 1 : 0) != 0, (String)"Unexpected existing job with preparation ID %s", (Object)preparationId);
            responseObserver.onNext((Object)JobApi.PrepareJobResponse.newBuilder().setPreparationId(preparationId).setArtifactStagingEndpoint(artifactStagingService.getApiServiceDescriptor()).setStagingSessionToken(stagingSessionToken).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Could not prepare job with name {}", (Object)request.getJobName(), (Object)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    private GrpcFnServer<BeamFileSystemArtifactStagingService> createArtifactStagingService() throws Exception {
        BeamFileSystemArtifactStagingService service = new BeamFileSystemArtifactStagingService();
        return GrpcFnServer.allocatePortAndCreateFor(service, this.serverFactory);
    }

    public void run(JobApi.RunJobRequest request, StreamObserver<JobApi.RunJobResponse> responseObserver) {
        try {
            LOG.trace("{} {}", (Object)JobApi.RunJobRequest.class.getSimpleName(), (Object)request);
            String preparationId = request.getPreparationId();
            PreparingJob preparingJob = (PreparingJob)this.unpreparedJobs.get(preparationId);
            if (preparingJob == null) {
                responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(String.format("Unknown Preparation Id %s", preparationId)).asException());
                return;
            }
            try {
                preparingJob.close();
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)e);
            }
            ReferenceRunner runner = ReferenceRunner.forPipeline(preparingJob.getPipeline(), preparingJob.getOptions(), request.getRetrievalToken());
            String jobId = "job-" + Integer.toString(ThreadLocalRandom.current().nextInt());
            responseObserver.onNext((Object)JobApi.RunJobResponse.newBuilder().setJobId(jobId).build());
            responseObserver.onCompleted();
            this.runningJobs.put(jobId, runner);
            this.jobStates.putIfAbsent(jobId, JobApi.JobState.Enum.RUNNING);
            this.executor.submit(() -> {
                try {
                    this.jobStates.computeIfPresent(jobId, (id, status) -> JobApi.JobState.Enum.RUNNING);
                    runner.execute();
                    this.jobStates.computeIfPresent(jobId, (id, status) -> JobApi.JobState.Enum.DONE);
                }
                catch (Exception e) {
                    this.jobStates.computeIfPresent(jobId, (id, status) -> JobApi.JobState.Enum.FAILED);
                    throw e;
                }
                if (!this.configuration.keepArtifacts) {
                    String stagingSessionToken = preparingJob.getStagingSessionToken();
                    try {
                        preparingJob.getArtifactStagingServer().getService().removeArtifacts(stagingSessionToken);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to remove job staging directory for token {}: {}", (Object)stagingSessionToken, (Object)e);
                    }
                }
                return null;
            });
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getState(JobApi.GetJobStateRequest request, StreamObserver<JobApi.GetJobStateResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobStateRequest.class.getSimpleName(), (Object)request);
        try {
            responseObserver.onNext((Object)JobApi.GetJobStateResponse.newBuilder().setState(this.jobStates.getOrDefault(request.getJobId(), JobApi.JobState.Enum.UNRECOGNIZED)).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", request.getJobId());
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getStateStream(JobApi.GetJobStateRequest request, StreamObserver<JobApi.GetJobStateResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobStateRequest.class.getSimpleName(), (Object)request);
        String invocationId = request.getJobId();
        try {
            Thread.sleep(1000L);
            JobApi.JobState.Enum state = this.jobStates.getOrDefault(request.getJobId(), JobApi.JobState.Enum.UNRECOGNIZED);
            responseObserver.onNext((Object)JobApi.GetJobStateResponse.newBuilder().setState(state).build());
            while (JobApi.JobState.Enum.RUNNING.equals((Object)state)) {
                Thread.sleep(1000L);
                state = this.jobStates.getOrDefault(request.getJobId(), JobApi.JobState.Enum.UNRECOGNIZED);
            }
            responseObserver.onNext((Object)JobApi.GetJobStateResponse.newBuilder().setState(state).build());
        }
        catch (Exception e) {
            String errMessage = String.format("Encountered Unexpected Exception for Invocation %s", invocationId);
            LOG.error(errMessage, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
        responseObserver.onCompleted();
    }

    public void describePipelineOptions(JobApi.DescribePipelineOptionsRequest request, StreamObserver<JobApi.DescribePipelineOptionsResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.DescribePipelineOptionsRequest.class.getSimpleName(), (Object)request);
        try {
            JobApi.DescribePipelineOptionsResponse response = JobApi.DescribePipelineOptionsResponse.newBuilder().addAllOptions((Iterable)PipelineOptionsFactory.describe((Set)PipelineOptionsFactory.getRegisteredOptions())).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Error describing pipeline options", (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    public void getMessageStream(JobApi.JobMessagesRequest request, StreamObserver<JobApi.JobMessagesResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.JobMessagesRequest.class.getSimpleName(), (Object)request);
    }

    public void cancel(JobApi.CancelJobRequest request, StreamObserver<JobApi.CancelJobResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.CancelJobRequest.class.getSimpleName(), (Object)request);
        responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(String.format("Unknown Job ID %s", request.getJobId())).asException());
    }

    @Override
    public void close() throws Exception {
        for (PreparingJob preparingJob : ImmutableList.copyOf(this.unpreparedJobs.values())) {
            try {
                preparingJob.close();
            }
            catch (Exception e) {
                LOG.warn("Exception while closing preparing job {}", (Object)preparingJob);
            }
        }
        while (!this.artifactStagingServices.isEmpty()) {
            GrpcFnServer artifactStagingService = (GrpcFnServer)this.artifactStagingServices.remove();
            try {
                artifactStagingService.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close staging sevice started on %s", (Object)artifactStagingService.getApiServiceDescriptor().getUrl(), (Object)e);
            }
        }
    }

    public static class Configuration {
        public String artifactStagingPath;
        public boolean keepArtifacts;
    }
}

