/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.Collection;
import java.util.Collections;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Instant;

public class ProcessFnRunner<InputT, OutputT, RestrictionT>
implements PushbackSideInputDoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> {
    private final DoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> underlying;
    private final Collection<PCollectionView<?>> views;
    private final ReadyCheckingSideInputReader sideInputReader;

    public ProcessFnRunner(DoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> underlying, Collection<PCollectionView<?>> views, ReadyCheckingSideInputReader sideInputReader) {
        this.underlying = underlying;
        this.views = views;
        this.sideInputReader = sideInputReader;
    }

    @Override
    public DoFn<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> getFn() {
        return this.underlying.getFn();
    }

    @Override
    public void startBundle() {
        this.underlying.startBundle();
    }

    @Override
    public Iterable<WindowedValue<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>>> processElementInReadyWindows(WindowedValue<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>> windowedKWI) {
        ProcessFnRunner.checkTrivialOuterWindows(windowedKWI);
        BoundedWindow window = ProcessFnRunner.getUnderlyingWindow((KeyedWorkItem)windowedKWI.getValue());
        if (!this.isReady(window)) {
            return Collections.singletonList(windowedKWI);
        }
        this.underlying.processElement(windowedKWI);
        return Collections.emptyList();
    }

    @Override
    public void finishBundle() {
        this.underlying.finishBundle();
    }

    @Override
    public void onTimer(String timerId, BoundedWindow window, Instant timestamp, TimeDomain timeDomain) {
        throw new UnsupportedOperationException("User timers unsupported in ProcessFn");
    }

    private static <T> void checkTrivialOuterWindows(WindowedValue<KeyedWorkItem<byte[], T>> windowedKWI) {
        Collection outerWindows = windowedKWI.getWindows();
        if (!outerWindows.isEmpty()) {
            Preconditions.checkArgument((outerWindows.size() == 1 ? 1 : 0) != 0, (String)"The KeyedWorkItem itself must not be in multiple windows, but was in: %s", (Object)outerWindows);
            BoundedWindow onlyWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)outerWindows);
            Preconditions.checkArgument((boolean)(onlyWindow instanceof GlobalWindow), (String)"KeyedWorkItem must be in the Global window, but was in: %s", (Object)onlyWindow);
        }
    }

    private static <T> BoundedWindow getUnderlyingWindow(KeyedWorkItem<byte[], T> kwi) {
        if (Iterables.isEmpty(kwi.elementsIterable())) {
            TimerInternals.TimerData timer = (TimerInternals.TimerData)Iterables.getOnlyElement(kwi.timersIterable());
            return ((StateNamespaces.WindowNamespace)timer.getNamespace()).getWindow();
        }
        WindowedValue value = (WindowedValue)Iterables.getOnlyElement(kwi.elementsIterable());
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)value.getWindows());
    }

    private boolean isReady(BoundedWindow mainInputWindow) {
        for (PCollectionView<?> view : this.views) {
            BoundedWindow sideInputWindow;
            if (this.sideInputReader.isReady(view, sideInputWindow = view.getWindowMappingFn().getSideInputWindow(mainInputWindow))) continue;
            return false;
        }
        return true;
    }
}

