/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslator;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslatorRegistrar;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class CoderTranslation {
    public static final String JAVA_SERIALIZED_CODER_URN = "beam:coders:javasdk:0.1";
    @VisibleForTesting
    static final BiMap<Class<? extends Coder>, String> KNOWN_CODER_URNS = CoderTranslation.loadCoderURNs();
    @VisibleForTesting
    static final Map<Class<? extends Coder>, CoderTranslator<? extends Coder>> KNOWN_TRANSLATORS = CoderTranslation.loadTranslators();

    private static BiMap<Class<? extends Coder>, String> loadCoderURNs() {
        ImmutableBiMap.Builder coderUrns = ImmutableBiMap.builder();
        for (CoderTranslatorRegistrar registrar : ServiceLoader.load(CoderTranslatorRegistrar.class)) {
            coderUrns.putAll(registrar.getCoderURNs());
        }
        return coderUrns.build();
    }

    private static Map<Class<? extends Coder>, CoderTranslator<? extends Coder>> loadTranslators() {
        ImmutableMap.Builder translators = ImmutableMap.builder();
        for (CoderTranslatorRegistrar coderTranslatorRegistrar : ServiceLoader.load(CoderTranslatorRegistrar.class)) {
            translators.putAll(coderTranslatorRegistrar.getCoderTranslators());
        }
        return translators.build();
    }

    public static RunnerApi.MessageWithComponents toProto(Coder<?> coder) throws IOException {
        SdkComponents components = SdkComponents.create();
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, components);
        return RunnerApi.MessageWithComponents.newBuilder().setCoder(coderProto).setComponents(components.toComponents()).build();
    }

    public static RunnerApi.Coder toProto(Coder<?> coder, SdkComponents components) throws IOException {
        if (KNOWN_CODER_URNS.containsKey(coder.getClass())) {
            return CoderTranslation.toKnownCoder(coder, components);
        }
        return CoderTranslation.toCustomCoder(coder);
    }

    private static RunnerApi.Coder toKnownCoder(Coder<?> coder, SdkComponents components) throws IOException {
        CoderTranslator<? extends Coder> translator = KNOWN_TRANSLATORS.get(coder.getClass());
        List<String> componentIds = CoderTranslation.registerComponents(coder, translator, components);
        return RunnerApi.Coder.newBuilder().addAllComponentCoderIds(componentIds).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn((String)KNOWN_CODER_URNS.get(coder.getClass())).setPayload(ByteString.copyFrom((byte[])translator.getPayload(coder)))).build();
    }

    private static <T extends Coder<?>> List<String> registerComponents(T coder, CoderTranslator<T> translator, SdkComponents components) throws IOException {
        ArrayList<String> componentIds = new ArrayList<String>();
        for (Coder<?> component : translator.getComponents(coder)) {
            componentIds.add(components.registerCoder(component));
        }
        return componentIds;
    }

    private static RunnerApi.Coder toCustomCoder(Coder<?> coder) throws IOException {
        RunnerApi.Coder.Builder coderBuilder = RunnerApi.Coder.newBuilder();
        return coderBuilder.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_CODER_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(coder))).build()).build();
    }

    public static Coder<?> fromProto(RunnerApi.Coder protoCoder, RehydratedComponents components) throws IOException {
        String coderSpecUrn = protoCoder.getSpec().getUrn();
        if (coderSpecUrn.equals(JAVA_SERIALIZED_CODER_URN)) {
            return CoderTranslation.fromCustomCoder(protoCoder);
        }
        return CoderTranslation.fromKnownCoder(protoCoder, components);
    }

    private static Coder<?> fromKnownCoder(RunnerApi.Coder coder, RehydratedComponents components) throws IOException {
        String coderUrn = coder.getSpec().getUrn();
        ArrayList coderComponents = new ArrayList();
        for (String componentId : coder.getComponentCoderIdsList()) {
            Coder<?> innerCoder = components.getCoder(componentId);
            coderComponents.add(innerCoder);
        }
        Class coderType = (Class)KNOWN_CODER_URNS.inverse().get((Object)coderUrn);
        CoderTranslator<? extends Coder> translator = KNOWN_TRANSLATORS.get(coderType);
        Preconditions.checkArgument((translator != null ? 1 : 0) != 0, (String)"Unknown Coder URN %s. Known URNs: %s", (Object)coderUrn, (Object)KNOWN_CODER_URNS.values());
        return translator.fromComponents(coderComponents, coder.getSpec().getPayload().toByteArray());
    }

    private static Coder<?> fromCustomCoder(RunnerApi.Coder protoCoder) throws IOException {
        return (Coder)SerializableUtils.deserializeFromByteArray((byte[])protoCoder.getSpec().getPayload().toByteArray(), (String)"Custom Coder Bytes");
    }
}

