/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class SchemaTranslation {
    private static final BiMap<Schema.TypeName, RunnerApi.Schema.TypeName> TYPE_NAME_MAPPING = ImmutableBiMap.builder().put((Object)Schema.TypeName.BYTE, (Object)RunnerApi.Schema.TypeName.BYTE).put((Object)Schema.TypeName.INT16, (Object)RunnerApi.Schema.TypeName.INT16).put((Object)Schema.TypeName.INT32, (Object)RunnerApi.Schema.TypeName.INT32).put((Object)Schema.TypeName.INT64, (Object)RunnerApi.Schema.TypeName.INT64).put((Object)Schema.TypeName.DECIMAL, (Object)RunnerApi.Schema.TypeName.DECIMAL).put((Object)Schema.TypeName.FLOAT, (Object)RunnerApi.Schema.TypeName.FLOAT).put((Object)Schema.TypeName.DOUBLE, (Object)RunnerApi.Schema.TypeName.DOUBLE).put((Object)Schema.TypeName.STRING, (Object)RunnerApi.Schema.TypeName.STRING).put((Object)Schema.TypeName.DATETIME, (Object)RunnerApi.Schema.TypeName.DATETIME).put((Object)Schema.TypeName.BOOLEAN, (Object)RunnerApi.Schema.TypeName.BOOLEAN).put((Object)Schema.TypeName.BYTES, (Object)RunnerApi.Schema.TypeName.BYTES).put((Object)Schema.TypeName.ARRAY, (Object)RunnerApi.Schema.TypeName.ARRAY).put((Object)Schema.TypeName.MAP, (Object)RunnerApi.Schema.TypeName.MAP).put((Object)Schema.TypeName.ROW, (Object)RunnerApi.Schema.TypeName.ROW).put((Object)Schema.TypeName.LOGICAL_TYPE, (Object)RunnerApi.Schema.TypeName.LOGICAL_TYPE).build();

    public static RunnerApi.Schema toProto(Schema schema) {
        String uuid = schema.getUUID() != null ? schema.getUUID().toString() : "";
        RunnerApi.Schema.Builder builder = RunnerApi.Schema.newBuilder().setId(uuid);
        for (Schema.Field field : schema.getFields()) {
            RunnerApi.Schema.Field protoField = SchemaTranslation.toProto(field, schema.indexOf(field.getName()), (Integer)schema.getEncodingPositions().get(field.getName()));
            builder.addFields(protoField);
        }
        return builder.build();
    }

    private static RunnerApi.Schema.Field toProto(Schema.Field field, int fieldId, int position) {
        return RunnerApi.Schema.Field.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setType(SchemaTranslation.toProto(field.getType())).setId(fieldId).setEncodingPosition(position).build();
    }

    private static RunnerApi.Schema.FieldType toProto(Schema.FieldType fieldType) {
        RunnerApi.Schema.FieldType.Builder builder = RunnerApi.Schema.FieldType.newBuilder().setTypeName((RunnerApi.Schema.TypeName)TYPE_NAME_MAPPING.get((Object)fieldType.getTypeName()));
        switch (fieldType.getTypeName()) {
            case ROW: {
                builder.setRowSchema(SchemaTranslation.toProto(fieldType.getRowSchema()));
                break;
            }
            case ARRAY: {
                builder.setCollectionElementType(SchemaTranslation.toProto(fieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                builder.setMapType(RunnerApi.Schema.MapType.newBuilder().setKeyType(SchemaTranslation.toProto(fieldType.getMapKeyType())).setValueType(SchemaTranslation.toProto(fieldType.getMapValueType())).build());
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                builder.setLogicalType(RunnerApi.Schema.LogicalType.newBuilder().setId(logicalType.getIdentifier()).setArgs(logicalType.getArgument()).setBaseType(SchemaTranslation.toProto(logicalType.getBaseType())).setSerializedClass(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)logicalType))).build());
                break;
            }
        }
        builder.setNullable(fieldType.getNullable().booleanValue());
        return builder.build();
    }

    public static Schema fromProto(RunnerApi.Schema protoSchema) {
        Schema.Builder builder = Schema.builder();
        HashMap encodingLocationMap = Maps.newHashMap();
        for (RunnerApi.Schema.Field protoField : protoSchema.getFieldsList()) {
            Schema.Field field = SchemaTranslation.fieldFromProto(protoField);
            builder.addField(field);
            encodingLocationMap.put(protoField.getName(), protoField.getEncodingPosition());
        }
        Schema schema = builder.build();
        schema.setEncodingPositions((Map)encodingLocationMap);
        if (!protoSchema.getId().isEmpty()) {
            schema.setUUID(UUID.fromString(protoSchema.getId()));
        }
        return schema;
    }

    private static Schema.Field fieldFromProto(RunnerApi.Schema.Field protoField) {
        return Schema.Field.of((String)protoField.getName(), (Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoField.getType())).withDescription(protoField.getDescription());
    }

    private static Schema.FieldType fieldTypeFromProto(RunnerApi.Schema.FieldType protoFieldType) {
        Schema.FieldType fieldType;
        Schema.TypeName typeName = (Schema.TypeName)TYPE_NAME_MAPPING.inverse().get((Object)protoFieldType.getTypeName());
        switch (typeName) {
            case ROW: {
                fieldType = Schema.FieldType.row((Schema)SchemaTranslation.fromProto(protoFieldType.getRowSchema()));
                break;
            }
            case ARRAY: {
                fieldType = Schema.FieldType.array((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getCollectionElementType()));
                break;
            }
            case MAP: {
                fieldType = Schema.FieldType.map((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getKeyType()), (Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getValueType()));
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = (Schema.LogicalType)SerializableUtils.deserializeFromByteArray((byte[])protoFieldType.getLogicalType().getSerializedClass().toByteArray(), (String)"logicalType");
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)logicalType);
                break;
            }
            default: {
                fieldType = Schema.FieldType.of((Schema.TypeName)typeName);
            }
        }
        if (protoFieldType.getNullable()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }
}

