/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExecutionState
extends ExecutionStateTracker.ExecutionState {
    private long totalMillis = 0L;
    private HashMap<String, String> labelsMetadata;
    private String urn;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleExecutionState.class);
    private static final PeriodFormatter DURATION_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").minimumPrintedDigits(2).appendHours().appendSuffix("h").printZeroAlways().appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();

    public SimpleExecutionState(String stateName, String urn, HashMap<String, String> labelsMetadata) {
        super(stateName);
        this.urn = urn;
        this.labelsMetadata = labelsMetadata;
        if (this.labelsMetadata == null) {
            this.labelsMetadata = new HashMap();
        }
    }

    public String getUrn() {
        return this.urn;
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.labelsMetadata);
    }

    @Override
    public void takeSample(long millisSinceLastSample) {
        this.totalMillis += millisSinceLastSample;
    }

    public long getTotalMillis() {
        return this.totalMillis;
    }

    @VisibleForTesting
    public String getLullMessage(Thread trackedThread, Duration millis) {
        StackTraceElement[] fullTrace;
        String userStepName = this.labelsMetadata.getOrDefault(MonitoringInfoConstants.Labels.PTRANSFORM, null);
        StringBuilder message = new StringBuilder();
        message.append("Processing stuck");
        if (userStepName != null) {
            message.append(" in step ").append(userStepName);
        }
        message.append(" for at least ").append(SimpleExecutionState.formatDuration(millis)).append(" without outputting or completing in state ").append(this.getStateName());
        message.append("\n");
        for (StackTraceElement e : fullTrace = trackedThread.getStackTrace()) {
            message.append("  at ").append(e).append("\n");
        }
        return message.toString();
    }

    @Override
    public void reportLull(Thread trackedThread, long millis) {
        LOG.warn(this.getLullMessage(trackedThread, Duration.millis((long)millis)));
    }

    @VisibleForTesting
    static String formatDuration(Duration duration) {
        return DURATION_FORMATTER.print((ReadablePeriod)duration.toPeriod());
    }
}

