/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.DefaultJobBundleFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.ReferenceCountingExecutableStageContextFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class DefaultExecutableStageContext
implements ExecutableStageContext,
AutoCloseable {
    private final JobBundleFactory jobBundleFactory;

    private static DefaultExecutableStageContext create(JobInfo jobInfo) {
        DefaultJobBundleFactory jobBundleFactory = DefaultJobBundleFactory.create(jobInfo);
        return new DefaultExecutableStageContext(jobBundleFactory);
    }

    private DefaultExecutableStageContext(JobBundleFactory jobBundleFactory) {
        this.jobBundleFactory = jobBundleFactory;
    }

    @Override
    public StageBundleFactory getStageBundleFactory(ExecutableStage executableStage) {
        return this.jobBundleFactory.forStage(executableStage);
    }

    @Override
    public void close() throws Exception {
        this.jobBundleFactory.close();
    }

    public static class MultiInstanceFactory
    implements ExecutableStageContext.Factory {
        private int index = 0;
        private final List<ReferenceCountingExecutableStageContextFactory> factories = new ArrayList<ReferenceCountingExecutableStageContextFactory>();
        private final int maxFactories;
        private final SerializableFunction<Object, Boolean> isReleaseSynchronous;

        public MultiInstanceFactory(int maxFactories, SerializableFunction<Object, Boolean> isReleaseSynchronous) {
            this.isReleaseSynchronous = isReleaseSynchronous;
            Preconditions.checkArgument((maxFactories >= 0 ? 1 : 0) != 0, (Object)"sdk_worker_parallelism must be >= 0");
            this.maxFactories = maxFactories == 0 ? Math.max(Runtime.getRuntime().availableProcessors() - 1, 1) : maxFactories;
        }

        private synchronized ExecutableStageContext.Factory getFactory() {
            ReferenceCountingExecutableStageContextFactory factory;
            if (this.factories.size() < this.maxFactories) {
                factory = ReferenceCountingExecutableStageContextFactory.create(x$0 -> DefaultExecutableStageContext.create(x$0), this.isReleaseSynchronous);
                this.factories.add(factory);
            } else {
                factory = this.factories.get(this.index);
            }
            this.index = (this.index + 1) % this.maxFactories;
            return factory;
        }

        @Override
        public ExecutableStageContext get(JobInfo jobInfo) {
            return this.getFactory().get(jobInfo);
        }
    }
}

