/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SyntheticComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.SideInputReference;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.TimerReference;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.UserStateReference;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_BagUserStateSpec;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_ExecutableProcessBundleDescriptor;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_OutputEncoding;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_SideInputSpec;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_TimerSpec;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.data.RemoteInputDestination;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.WireCoders;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.RemoteGrpcPortRead;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.RemoteGrpcPortWrite;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.sdk.v2.sdk.extensions.protobuf.ByteStringCoder;

public class ProcessBundleDescriptors {
    public static ExecutableProcessBundleDescriptor fromExecutableStage(String id, ExecutableStage stage, Endpoints.ApiServiceDescriptor dataEndpoint, Endpoints.ApiServiceDescriptor stateEndpoint) throws IOException {
        Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"id must be specified.");
        Preconditions.checkState((stage != null ? 1 : 0) != 0, (Object)"stage must be specified.");
        Preconditions.checkState((dataEndpoint != null ? 1 : 0) != 0, (Object)"dataEndpoint must be specified.");
        Preconditions.checkState((stateEndpoint != null ? 1 : 0) != 0, (Object)"stateEndpoint must be specified.");
        return ProcessBundleDescriptors.fromExecutableStageInternal(id, stage, dataEndpoint, stateEndpoint);
    }

    public static ExecutableProcessBundleDescriptor fromExecutableStage(String id, ExecutableStage stage, Endpoints.ApiServiceDescriptor dataEndpoint) throws IOException {
        Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"id must be specified.");
        Preconditions.checkState((stage != null ? 1 : 0) != 0, (Object)"stage must be specified.");
        Preconditions.checkState((dataEndpoint != null ? 1 : 0) != 0, (Object)"dateEndpoint must be specified.");
        return ProcessBundleDescriptors.fromExecutableStageInternal(id, stage, dataEndpoint, null);
    }

    private static ExecutableProcessBundleDescriptor fromExecutableStageInternal(String id, ExecutableStage stage, Endpoints.ApiServiceDescriptor dataEndpoint, @Nullable Endpoints.ApiServiceDescriptor stateEndpoint) throws IOException {
        Map<String, RunnerApi.PTransform> stageTransforms = stage.getTransforms().stream().collect(Collectors.toMap(PipelineNode.PTransformNode::getId, PipelineNode.PTransformNode::getTransform));
        RunnerApi.Components.Builder components = stage.getComponents().toBuilder().clearTransforms().putAllTransforms(stageTransforms);
        ImmutableMap.Builder inputDestinationsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder remoteOutputCodersBuilder = ImmutableMap.builder();
        inputDestinationsBuilder.put((Object)stage.getInputPCollection().getId(), ProcessBundleDescriptors.addStageInput(dataEndpoint, stage.getInputPCollection(), components));
        remoteOutputCodersBuilder.putAll(ProcessBundleDescriptors.addStageOutputs(dataEndpoint, stage.getOutputPCollections(), components));
        Map<String, Map<String, SideInputSpec>> sideInputSpecs = ProcessBundleDescriptors.addSideInputs(stage, components);
        Map<String, Map<String, BagUserStateSpec>> bagUserStateSpecs = ProcessBundleDescriptors.forBagUserStates(stage, components.build());
        Map<String, Map<String, TimerSpec>> timerSpecs = ProcessBundleDescriptors.forTimerSpecs(dataEndpoint, stage, components, (ImmutableMap.Builder<String, RemoteInputDestination>)inputDestinationsBuilder, (ImmutableMap.Builder<String, Coder>)remoteOutputCodersBuilder);
        BeamFnApi.ProcessBundleDescriptor.Builder bundleDescriptorBuilder = BeamFnApi.ProcessBundleDescriptor.newBuilder().setId(id);
        if (stateEndpoint != null) {
            bundleDescriptorBuilder.setStateApiServiceDescriptor(stateEndpoint);
        }
        bundleDescriptorBuilder.putAllCoders(components.getCodersMap()).putAllEnvironments(components.getEnvironmentsMap()).putAllPcollections(components.getPcollectionsMap()).putAllWindowingStrategies(components.getWindowingStrategiesMap()).putAllTransforms(components.getTransformsMap());
        return ExecutableProcessBundleDescriptor.of(bundleDescriptorBuilder.build(), (Map<String, RemoteInputDestination>)inputDestinationsBuilder.build(), (Map<String, Coder>)remoteOutputCodersBuilder.build(), sideInputSpecs, bagUserStateSpecs, timerSpecs);
    }

    private static Map<String, Coder<WindowedValue<?>>> addStageOutputs(Endpoints.ApiServiceDescriptor dataEndpoint, Collection<PipelineNode.PCollectionNode> outputPCollections, RunnerApi.Components.Builder components) throws IOException {
        LinkedHashMap remoteOutputCoders = new LinkedHashMap();
        for (PipelineNode.PCollectionNode outputPCollection : outputPCollections) {
            OutputEncoding outputEncoding = ProcessBundleDescriptors.addStageOutput(dataEndpoint, components, outputPCollection);
            remoteOutputCoders.put(outputEncoding.getPTransformId(), outputEncoding.getCoder());
        }
        return remoteOutputCoders;
    }

    private static RemoteInputDestination<WindowedValue<?>> addStageInput(Endpoints.ApiServiceDescriptor dataEndpoint, PipelineNode.PCollectionNode inputPCollection, RunnerApi.Components.Builder components) throws IOException {
        String inputWireCoderId = WireCoders.addSdkWireCoder(inputPCollection, components);
        Coder wireCoder = WireCoders.instantiateRunnerWireCoder(inputPCollection, components.build());
        BeamFnApi.RemoteGrpcPort inputPort = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(dataEndpoint).setCoderId(inputWireCoderId).build();
        String inputId = SyntheticComponents.uniqueId(String.format("fn/read/%s", inputPCollection.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsTransforms(arg_0));
        RunnerApi.PTransform inputTransform = RemoteGrpcPortRead.readFromPort(inputPort, inputPCollection.getId()).toPTransform();
        components.putTransforms(inputId, inputTransform);
        return RemoteInputDestination.of(wireCoder, inputId);
    }

    private static OutputEncoding addStageOutput(Endpoints.ApiServiceDescriptor dataEndpoint, RunnerApi.Components.Builder components, PipelineNode.PCollectionNode outputPCollection) throws IOException {
        String outputWireCoderId = WireCoders.addSdkWireCoder(outputPCollection, components);
        Coder wireCoder = WireCoders.instantiateRunnerWireCoder(outputPCollection, components.build());
        BeamFnApi.RemoteGrpcPort outputPort = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(dataEndpoint).setCoderId(outputWireCoderId).build();
        RemoteGrpcPortWrite outputWrite = RemoteGrpcPortWrite.writeToPort(outputPCollection.getId(), outputPort);
        String outputId = SyntheticComponents.uniqueId(String.format("fn/write/%s", outputPCollection.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsTransforms(arg_0));
        RunnerApi.PTransform outputTransform = outputWrite.toPTransform();
        components.putTransforms(outputId, outputTransform);
        return new AutoValue_ProcessBundleDescriptors_OutputEncoding(outputId, wireCoder);
    }

    public static Map<String, Map<String, SideInputSpec>> getSideInputs(ExecutableStage stage) throws IOException {
        return ProcessBundleDescriptors.addSideInputs(stage, stage.getComponents().toBuilder());
    }

    private static Map<String, Map<String, SideInputSpec>> addSideInputs(ExecutableStage stage, RunnerApi.Components.Builder components) throws IOException {
        ImmutableTable.Builder idsToSpec = ImmutableTable.builder();
        for (SideInputReference sideInputReference : stage.getSideInputs()) {
            PipelineNode.PCollectionNode pcNode = sideInputReference.collection();
            RunnerApi.PCollection pc = pcNode.getPCollection();
            String lengthPrefixedCoderId = LengthPrefixUnknownCoders.addLengthPrefixedCoder(pc.getCoderId(), components, false);
            components.putPcollections(pcNode.getId(), pc.toBuilder().setCoderId(lengthPrefixedCoderId).build());
            WindowedValue.FullWindowedValueCoder coder = (WindowedValue.FullWindowedValueCoder)WireCoders.instantiateRunnerWireCoder(pcNode, components.build());
            idsToSpec.put((Object)sideInputReference.transform().getId(), (Object)sideInputReference.localName(), (Object)SideInputSpec.of(sideInputReference.transform().getId(), sideInputReference.localName(), ProcessBundleDescriptors.getAccessPattern(sideInputReference), coder.getValueCoder(), coder.getWindowCoder()));
        }
        return idsToSpec.build().rowMap();
    }

    private static RunnerApi.FunctionSpec getAccessPattern(SideInputReference sideInputReference) {
        try {
            return ((RunnerApi.SideInput)RunnerApi.ParDoPayload.parseFrom((ByteString)sideInputReference.transform().getTransform().getSpec().getPayload()).getSideInputsMap().get(sideInputReference.localName())).getAccessPattern();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Map<String, BagUserStateSpec>> forBagUserStates(ExecutableStage stage, RunnerApi.Components components) throws IOException {
        ImmutableTable.Builder idsToSpec = ImmutableTable.builder();
        for (UserStateReference userStateReference : stage.getUserStates()) {
            WindowedValue.FullWindowedValueCoder coder = (WindowedValue.FullWindowedValueCoder)WireCoders.instantiateRunnerWireCoder(userStateReference.collection(), components);
            idsToSpec.put((Object)userStateReference.transform().getId(), (Object)userStateReference.localName(), BagUserStateSpec.of(userStateReference.transform().getId(), userStateReference.localName(), ByteStringCoder.of(), ByteStringCoder.of(), coder.getWindowCoder()));
        }
        return idsToSpec.build().rowMap();
    }

    private static Map<String, Map<String, TimerSpec>> forTimerSpecs(Endpoints.ApiServiceDescriptor dataEndpoint, ExecutableStage stage, RunnerApi.Components.Builder components, ImmutableMap.Builder<String, RemoteInputDestination> remoteInputsBuilder, ImmutableMap.Builder<String, Coder> outputTransformCodersBuilder) throws IOException {
        ImmutableTable.Builder idsToSpec = ImmutableTable.builder();
        for (TimerReference timerReference : stage.getTimers()) {
            org.apache.beam.sdk.state.TimerSpec spec;
            RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)timerReference.transform().getTransform().getSpec().getPayload());
            RunnerApi.TimeDomain.Enum timeDomain = payload.getTimerSpecsOrThrow(timerReference.localName()).getTimeDomain();
            switch (timeDomain) {
                case EVENT_TIME: {
                    spec = TimerSpecs.timer((TimeDomain)TimeDomain.EVENT_TIME);
                    break;
                }
                case PROCESSING_TIME: {
                    spec = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);
                    break;
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    spec = TimerSpecs.timer((TimeDomain)TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown time domain %s", timeDomain));
                }
            }
            String mainInputName = timerReference.transform().getTransform().getInputsOrThrow((String)Iterables.getOnlyElement((Iterable)Sets.difference(timerReference.transform().getTransform().getInputsMap().keySet(), (Set)Sets.union(payload.getSideInputsMap().keySet(), payload.getTimerSpecsMap().keySet()))));
            String timerCoderId = ProcessBundleDescriptors.keyValueCoderId(components.getCodersOrThrow(components.getPcollectionsOrThrow(mainInputName).getCoderId()).getComponentCoderIds(0), payload.getTimerSpecsOrThrow(timerReference.localName()).getTimerCoderId(), components);
            RunnerApi.PCollection timerCollectionSpec = components.getPcollectionsOrThrow(mainInputName).toBuilder().setCoderId(timerCoderId).build();
            String inputTimerPCollectionId = SyntheticComponents.uniqueId(String.format("%s.timer.%s.in", timerReference.transform().getId(), timerReference.localName()), components.getPcollectionsMap()::containsKey);
            components.putPcollections(inputTimerPCollectionId, timerCollectionSpec);
            remoteInputsBuilder.put((Object)inputTimerPCollectionId, ProcessBundleDescriptors.addStageInput(dataEndpoint, PipelineNode.pCollection(inputTimerPCollectionId, timerCollectionSpec), components));
            String outputTimerPCollectionId = SyntheticComponents.uniqueId(String.format("%s.timer.%s.out", timerReference.transform().getId(), timerReference.localName()), components.getPcollectionsMap()::containsKey);
            components.putPcollections(outputTimerPCollectionId, timerCollectionSpec);
            OutputEncoding outputEncoding = ProcessBundleDescriptors.addStageOutput(dataEndpoint, components, PipelineNode.pCollection(outputTimerPCollectionId, timerCollectionSpec));
            outputTransformCodersBuilder.put((Object)outputEncoding.getPTransformId(), outputEncoding.getCoder());
            components.putTransforms(timerReference.transform().getId(), components.getTransformsOrThrow(timerReference.transform().getId()).toBuilder().putInputs(timerReference.localName(), inputTimerPCollectionId).putOutputs(timerReference.localName(), outputTimerPCollectionId).build());
            idsToSpec.put((Object)timerReference.transform().getId(), (Object)timerReference.localName(), TimerSpec.of(timerReference.transform().getId(), timerReference.localName(), inputTimerPCollectionId, outputTimerPCollectionId, outputEncoding.getPTransformId(), spec));
        }
        return idsToSpec.build().rowMap();
    }

    private static String keyValueCoderId(String keyCoderId, String valueCoderId, RunnerApi.Components.Builder components) {
        String id = SyntheticComponents.uniqueId(String.format("kv-%s-%s", keyCoderId, valueCoderId), components.getCodersMap()::containsKey);
        components.putCoders(id, RunnerApi.Coder.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(ModelCoders.KV_CODER_URN)).addComponentCoderIds(keyCoderId).addComponentCoderIds(valueCoderId).build());
        return id;
    }

    @AutoValue
    public static abstract class ExecutableProcessBundleDescriptor {
        public static ExecutableProcessBundleDescriptor of(BeamFnApi.ProcessBundleDescriptor descriptor, Map<String, RemoteInputDestination> inputDestinations, Map<String, Coder> outputTransformCoders, Map<String, Map<String, SideInputSpec>> sideInputSpecs, Map<String, Map<String, BagUserStateSpec>> bagUserStateSpecs, Map<String, Map<String, TimerSpec>> timerSpecs) {
            ImmutableTable.Builder copyOfSideInputSpecs = ImmutableTable.builder();
            for (Map.Entry<String, Map<String, SideInputSpec>> entry : sideInputSpecs.entrySet()) {
                for (Map.Entry<String, SideInputSpec> entry2 : entry.getValue().entrySet()) {
                    copyOfSideInputSpecs.put((Object)entry.getKey(), (Object)entry2.getKey(), (Object)entry2.getValue());
                }
            }
            ImmutableTable.Builder copyOfBagUserStateSpecs = ImmutableTable.builder();
            for (Map.Entry<String, Map<String, BagUserStateSpec>> entry : bagUserStateSpecs.entrySet()) {
                for (Map.Entry<String, BagUserStateSpec> entry3 : entry.getValue().entrySet()) {
                    copyOfBagUserStateSpecs.put((Object)entry.getKey(), (Object)entry3.getKey(), (Object)entry3.getValue());
                }
            }
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (Map.Entry<String, Map<String, TimerSpec>> entry : timerSpecs.entrySet()) {
                for (Map.Entry<String, TimerSpec> inner : entry.getValue().entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)inner.getKey(), (Object)inner.getValue());
                }
            }
            return new AutoValue_ProcessBundleDescriptors_ExecutableProcessBundleDescriptor(descriptor, inputDestinations, Collections.unmodifiableMap(outputTransformCoders), (Map<String, Map<String, SideInputSpec>>)copyOfSideInputSpecs.build().rowMap(), (Map<String, Map<String, BagUserStateSpec>>)copyOfBagUserStateSpecs.build().rowMap(), (Map<String, Map<String, TimerSpec>>)builder.build().rowMap());
        }

        public abstract BeamFnApi.ProcessBundleDescriptor getProcessBundleDescriptor();

        public abstract Map<String, RemoteInputDestination> getRemoteInputDestinations();

        public abstract Map<String, Coder> getRemoteOutputCoders();

        public abstract Map<String, Map<String, SideInputSpec>> getSideInputSpecs();

        public abstract Map<String, Map<String, BagUserStateSpec>> getBagUserStateSpecs();

        public abstract Map<String, Map<String, TimerSpec>> getTimerSpecs();
    }

    @AutoValue
    public static abstract class TimerSpec<K, V, W extends BoundedWindow> {
        static <K, V, W extends BoundedWindow> TimerSpec<K, V, W> of(String transformId, String timerId, String inputCollectionId, String outputCollectionId, String outputTransformId, org.apache.beam.sdk.state.TimerSpec timerSpec) {
            return new AutoValue_ProcessBundleDescriptors_TimerSpec(transformId, timerId, inputCollectionId, outputCollectionId, outputTransformId, timerSpec);
        }

        public abstract String transformId();

        public abstract String timerId();

        public abstract String inputCollectionId();

        public abstract String outputCollectionId();

        public abstract String outputTransformId();

        public abstract org.apache.beam.sdk.state.TimerSpec getTimerSpec();
    }

    @AutoValue
    public static abstract class BagUserStateSpec<K, V, W extends BoundedWindow> {
        static <K, V, W extends BoundedWindow> BagUserStateSpec<K, V, W> of(String transformId, String userStateId, Coder<K> keyCoder, Coder<V> valueCoder, Coder<W> windowCoder) {
            return new AutoValue_ProcessBundleDescriptors_BagUserStateSpec<K, V, W>(transformId, userStateId, keyCoder, valueCoder, windowCoder);
        }

        public abstract String transformId();

        public abstract String userStateId();

        public abstract Coder<K> keyCoder();

        public abstract Coder<V> valueCoder();

        public abstract Coder<W> windowCoder();
    }

    @AutoValue
    public static abstract class SideInputSpec<K, T, W extends BoundedWindow> {
        public static <T, W extends BoundedWindow> SideInputSpec of(String transformId, String sideInputId, RunnerApi.FunctionSpec accessPattern, Coder<T> elementCoder, Coder<W> windowCoder) {
            return new AutoValue_ProcessBundleDescriptors_SideInputSpec(transformId, sideInputId, accessPattern, elementCoder, windowCoder);
        }

        public abstract String transformId();

        public abstract String sideInputId();

        public abstract RunnerApi.FunctionSpec accessPattern();

        public abstract Coder<T> elementCoder();

        public abstract Coder<W> windowCoder();
    }

    @AutoValue
    static abstract class OutputEncoding {
        OutputEncoding() {
        }

        abstract String getPTransformId();

        abstract Coder<WindowedValue<?>> getCoder();
    }
}

