/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.jobsubmission;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ArtifactServiceStager;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.InProcessServerFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.BeamFileSystemArtifactStagingService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.jobsubmission.PortablePipelineJarCreator;
import org.apache.beam.repackaged.direct_java.sdk.fn.test.InProcessManagedChannelFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortablePipelineJarUtils {
    private static final String ARTIFACT_STAGING_FOLDER_PATH = "BEAM-ARTIFACT-STAGING";
    static final String ARTIFACT_FOLDER_PATH = "BEAM-ARTIFACT-STAGING/artifacts";
    private static final String PIPELINE_FOLDER_PATH = "BEAM-PIPELINE";
    static final String ARTIFACT_MANIFEST_PATH = "BEAM-ARTIFACT-STAGING/artifact-manifest.json";
    static final String PIPELINE_PATH = "BEAM-PIPELINE/pipeline.json";
    static final String PIPELINE_OPTIONS_PATH = "BEAM-PIPELINE/pipeline-options.json";
    private static final Logger LOG = LoggerFactory.getLogger(PortablePipelineJarCreator.class);

    private static InputStream getResourceFromClassPath(String resourcePath) throws IOException {
        InputStream inputStream = PortablePipelineJarUtils.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("Resource %s not found on classpath.", resourcePath));
        }
        return inputStream;
    }

    private static void parseJsonResource(String resourcePath, Message.Builder builder) throws IOException {
        try (InputStream inputStream = PortablePipelineJarUtils.getResourceFromClassPath(resourcePath);){
            String contents = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
            JsonFormat.parser().merge(contents, builder);
        }
    }

    public static RunnerApi.Pipeline getPipelineFromClasspath() throws IOException {
        RunnerApi.Pipeline.Builder builder = RunnerApi.Pipeline.newBuilder();
        PortablePipelineJarUtils.parseJsonResource("/BEAM-PIPELINE/pipeline.json", (Message.Builder)builder);
        return builder.build();
    }

    public static Struct getPipelineOptionsFromClasspath() throws IOException {
        Struct.Builder builder = Struct.newBuilder();
        PortablePipelineJarUtils.parseJsonResource("/BEAM-PIPELINE/pipeline-options.json", (Message.Builder)builder);
        return builder.build();
    }

    public static ArtifactApi.ProxyManifest getArtifactManifestFromClassPath() throws IOException {
        ArtifactApi.ProxyManifest.Builder builder = ArtifactApi.ProxyManifest.newBuilder();
        PortablePipelineJarUtils.parseJsonResource("/BEAM-ARTIFACT-STAGING/artifact-manifest.json", (Message.Builder)builder);
        return builder.build();
    }

    public static String stageArtifacts(ArtifactApi.ProxyManifest proxyManifest, PipelineOptions options, String invocationId, String artifactStagingPath) throws Exception {
        Collection<ArtifactServiceStager.StagedFile> filesToStage = PortablePipelineJarUtils.prepareArtifactsForStaging(proxyManifest, options, invocationId);
        try (GrpcFnServer<BeamFileSystemArtifactStagingService> artifactServer = GrpcFnServer.allocatePortAndCreateFor(new BeamFileSystemArtifactStagingService(), InProcessServerFactory.create());){
            ManagedChannel grpcChannel = InProcessManagedChannelFactory.create().forDescriptor(artifactServer.getApiServiceDescriptor());
            ArtifactServiceStager stager = ArtifactServiceStager.overChannel((Channel)grpcChannel);
            String stagingSessionToken = BeamFileSystemArtifactStagingService.generateStagingSessionToken(invocationId, artifactStagingPath);
            String retrievalToken = stager.stage(stagingSessionToken, filesToStage);
            for (ArtifactServiceStager.StagedFile file : filesToStage) {
                if (file.getFile().delete()) continue;
                LOG.warn("Failed to delete file {}", (Object)file.getFile());
            }
            grpcChannel.shutdown();
            String string = retrievalToken;
            return string;
        }
    }

    private static Collection<ArtifactServiceStager.StagedFile> prepareArtifactsForStaging(ArtifactApi.ProxyManifest proxyManifest, PipelineOptions options, String invocationId) throws IOException {
        ArrayList<ArtifactServiceStager.StagedFile> filesToStage = new ArrayList<ArtifactServiceStager.StagedFile>();
        Path outputFolderPath = Paths.get((String)MoreObjects.firstNonNull((Object)options.getTempLocation(), (Object)System.getProperty("java.io.tmpdir")), invocationId);
        if (!outputFolderPath.toFile().mkdir()) {
            throw new IOException("Failed to create folder " + outputFolderPath);
        }
        for (ArtifactApi.ProxyManifest.Location location : proxyManifest.getLocationList()) {
            InputStream inputStream = PortablePipelineJarUtils.getResourceFromClassPath(location.getUri());
            Throwable throwable = null;
            try {
                Path outputPath = outputFolderPath.resolve(UUID.randomUUID().toString());
                LOG.trace("Writing artifact {} to file {}", (Object)location.getName(), (Object)outputPath);
                File file = outputPath.toFile();
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    filesToStage.add(ArtifactServiceStager.StagedFile.of(file, location.getName()));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                PortablePipelineJarUtils.$closeResource(throwable, inputStream);
            }
        }
        return filesToStage;
    }
}

