/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.InMemoryTimerInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.Timer;
import org.apache.beam.repackaged.direct_java.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.joda.time.Instant;

public final class PipelineTranslatorUtils {
    private PipelineTranslatorUtils() {
    }

    public static BiMap<String, Integer> createOutputMap(Iterable<String> localOutputs) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        int outputIndex = 0;
        for (String tag : Sets.newTreeSet(localOutputs)) {
            builder.put((Object)tag, (Object)outputIndex);
            ++outputIndex;
        }
        return builder.build();
    }

    public static <T> Coder<WindowedValue<T>> instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection(collectionId, components.getPcollectionsOrThrow(collectionId));
        try {
            return WireCoders.instantiateRunnerWireCoder(collectionNode, components);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate Coder", e);
        }
    }

    public static WindowingStrategy getWindowingStrategy(String pCollectionId, RunnerApi.Components components) {
        RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(pCollectionId).getWindowingStrategyId());
        try {
            return WindowingStrategyTranslation.fromProto(windowingStrategyProto, RehydratedComponents.forComponents(components));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate windowing strategy %s for %s.", windowingStrategyProto, pCollectionId), e);
        }
    }

    public static boolean hasUnboundedPCollections(RunnerApi.Pipeline pipeline) {
        Preconditions.checkNotNull((Object)pipeline);
        Collection pCollecctions = pipeline.getComponents().getPcollectionsMap().values();
        return pCollecctions.stream().anyMatch(pc -> pc.getIsBounded() == RunnerApi.IsBounded.Enum.UNBOUNDED);
    }

    public static void fireEligibleTimers(InMemoryTimerInternals timerInternals, BiConsumer<String, WindowedValue> timerConsumer, Object currentTimerKey) {
        boolean hasFired;
        do {
            TimerInternals.TimerData timer;
            hasFired = false;
            while ((timer = timerInternals.removeNextEventTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerConsumer, currentTimerKey);
            }
            while ((timer = timerInternals.removeNextProcessingTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerConsumer, currentTimerKey);
            }
            while ((timer = timerInternals.removeNextSynchronizedProcessingTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerConsumer, currentTimerKey);
            }
        } while (hasFired);
    }

    private static void fireTimer(TimerInternals.TimerData timer, BiConsumer<String, WindowedValue> timerConsumer, Object currentTimerKey) {
        StateNamespace namespace = timer.getNamespace();
        Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
        Object window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        Instant timestamp = timer.getTimestamp();
        WindowedValue timerValue = WindowedValue.of((Object)KV.of((Object)currentTimerKey, Timer.of(timestamp, new byte[0])), (Instant)timestamp, Collections.singleton(window), (PaneInfo)PaneInfo.NO_FIRING);
        timerConsumer.accept(timer.getTimerId(), timerValue);
    }
}

