/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.data;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFnDataBufferingOutboundObserver<T>
implements CloseableFnDataReceiver<T> {
    public static final String BEAM_FN_API_DATA_BUFFER_LIMIT = "beam_fn_api_data_buffer_limit=";
    @VisibleForTesting
    static final int DEFAULT_BUFFER_LIMIT_BYTES = 1000000;
    private static final Logger LOG = LoggerFactory.getLogger(BeamFnDataBufferingOutboundObserver.class);
    private long byteCounter;
    private long counter;
    private boolean closed;
    private final int bufferLimit;
    private final Coder<T> coder;
    private final LogicalEndpoint outputLocation;
    private final StreamObserver<BeamFnApi.Elements> outboundObserver;
    private final ByteString.Output bufferedElements;

    public static <T> BeamFnDataBufferingOutboundObserver<T> forLocation(LogicalEndpoint endpoint, Coder<T> coder, StreamObserver<BeamFnApi.Elements> outboundObserver) {
        return BeamFnDataBufferingOutboundObserver.forLocationWithBufferLimit(1000000, endpoint, coder, outboundObserver);
    }

    public static <T> BeamFnDataBufferingOutboundObserver<T> forLocationWithBufferLimit(int bufferLimit, LogicalEndpoint endpoint, Coder<T> coder, StreamObserver<BeamFnApi.Elements> outboundObserver) {
        return new BeamFnDataBufferingOutboundObserver<T>(bufferLimit, endpoint, coder, outboundObserver);
    }

    private BeamFnDataBufferingOutboundObserver(int bufferLimit, LogicalEndpoint outputLocation, Coder<T> coder, StreamObserver<BeamFnApi.Elements> outboundObserver) {
        this.bufferLimit = bufferLimit;
        this.outputLocation = outputLocation;
        this.coder = coder;
        this.outboundObserver = outboundObserver;
        this.bufferedElements = ByteString.newOutput();
        this.closed = false;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.closed = true;
        BeamFnApi.Elements.Builder elements = this.convertBufferForTransmission();
        elements.addDataBuilder().setInstructionReference(this.outputLocation.getInstructionId()).setPtransformId(this.outputLocation.getPTransformId());
        LOG.debug("Closing stream for instruction {} and transform {} having transmitted {} values {} bytes", new Object[]{this.outputLocation.getInstructionId(), this.outputLocation.getPTransformId(), this.counter, this.byteCounter});
        this.outboundObserver.onNext((Object)elements.build());
    }

    @Override
    public void flush() throws IOException {
        if (this.bufferedElements.size() > 0) {
            this.outboundObserver.onNext((Object)this.convertBufferForTransmission().build());
        }
    }

    @Override
    public void accept(T t) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.coder.encode(t, (OutputStream)this.bufferedElements);
        ++this.counter;
        if (this.bufferedElements.size() >= this.bufferLimit) {
            this.flush();
        }
    }

    private BeamFnApi.Elements.Builder convertBufferForTransmission() {
        BeamFnApi.Elements.Builder elements = BeamFnApi.Elements.newBuilder();
        if (this.bufferedElements.size() == 0) {
            return elements;
        }
        elements.addDataBuilder().setInstructionReference(this.outputLocation.getInstructionId()).setPtransformId(this.outputLocation.getPTransformId()).setData(this.bufferedElements.toByteString());
        this.byteCounter += (long)this.bufferedElements.size();
        this.bufferedElements.reset();
        return elements;
    }
}

