/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.time.Instant;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SpecMonitoringInfoValidator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

public class SimpleMonitoringInfoBuilder {
    private final boolean validateAndDropInvalid;
    private static final HashMap<String, MetricsApi.MonitoringInfoSpec> specs = new HashMap();
    private MetricsApi.MonitoringInfo.Builder builder;
    private SpecMonitoringInfoValidator validator = new SpecMonitoringInfoValidator();

    public SimpleMonitoringInfoBuilder() {
        this(true);
    }

    public SimpleMonitoringInfoBuilder(boolean validateAndDropInvalid) {
        this.builder = MetricsApi.MonitoringInfo.newBuilder();
        this.validateAndDropInvalid = validateAndDropInvalid;
    }

    public SimpleMonitoringInfoBuilder setUrn(String urn) {
        this.builder.setUrn(urn);
        return this;
    }

    public SimpleMonitoringInfoBuilder setTimestampToNow() {
        Instant time = Instant.now();
        this.builder.getTimestampBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano());
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64Value(long value) {
        this.builder.getMetricBuilder().getCounterDataBuilder().setInt64Value(value);
        this.setInt64TypeUrn();
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64DistributionValue(DistributionData data) {
        this.builder.getMetricBuilder().getDistributionDataBuilder().getIntDistributionDataBuilder().setCount(data.count()).setSum(data.sum()).setMin(data.min()).setMax(data.max());
        this.setInt64DistributionTypeUrn();
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64DistributionTypeUrn() {
        this.builder.setType(MonitoringInfoConstants.TypeUrns.DISTRIBUTION_INT64);
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64TypeUrn() {
        this.builder.setType(MonitoringInfoConstants.TypeUrns.SUM_INT64);
        return this;
    }

    public SimpleMonitoringInfoBuilder setLabel(String labelName, String labelValue) {
        this.builder.putLabels(labelName, labelValue);
        return this;
    }

    public void clear() {
        this.builder = MetricsApi.MonitoringInfo.newBuilder();
    }

    public void merge(MetricsApi.MonitoringInfo monitoringInfo) {
        this.builder.mergeFrom(monitoringInfo);
    }

    @VisibleForTesting
    public static MetricsApi.MonitoringInfo copyAndClearTimestamp(MetricsApi.MonitoringInfo input) {
        MetricsApi.MonitoringInfo.Builder builder = MetricsApi.MonitoringInfo.newBuilder();
        builder.mergeFrom(input);
        builder.clearTimestamp();
        return builder.build();
    }

    @Nullable
    public MetricsApi.MonitoringInfo build() {
        MetricsApi.MonitoringInfo result = this.builder.build();
        if (this.validateAndDropInvalid && this.validator.validate(result).isPresent()) {
            return null;
        }
        return result;
    }

    static {
        for (MetricsApi.MonitoringInfoSpecs.Enum val : MetricsApi.MonitoringInfoSpecs.Enum.values()) {
            if (val.name().equals("UNRECOGNIZED")) continue;
            MetricsApi.MonitoringInfoSpec spec = (MetricsApi.MonitoringInfoSpec)val.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec);
            specs.put(spec.getUrn(), spec);
        }
    }
}

