/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.AbstractArtifactRetrievalService;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFileSystemArtifactRetrievalService
extends AbstractArtifactRetrievalService {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFileSystemArtifactRetrievalService.class);
    private static final Cache<String, ArtifactApi.ProxyManifest> MANIFEST_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(100L).build();

    public BeamFileSystemArtifactRetrievalService() {
        super(MANIFEST_CACHE);
    }

    public static BeamFileSystemArtifactRetrievalService create() {
        return new BeamFileSystemArtifactRetrievalService();
    }

    @Override
    public InputStream openUri(String retrievalToken, String uri) throws IOException {
        ResourceId artifactResourceId = FileSystems.matchNewResource((String)uri, (boolean)false);
        return Channels.newInputStream(FileSystems.open((ResourceId)artifactResourceId));
    }

    @Override
    public InputStream openManifest(String retrievalToken) throws IOException {
        ResourceId manifestResourceId = BeamFileSystemArtifactRetrievalService.getManifestLocationFromToken(retrievalToken);
        try {
            return Channels.newInputStream(FileSystems.open((ResourceId)manifestResourceId));
        }
        catch (IOException e) {
            LOG.warn("GetManifest for {} failed. Make sure the artifact staging directory (configurable via --artifacts-dir argument to the job server) is accessible to workers.", (Object)retrievalToken, (Object)e);
            throw e;
        }
    }

    @VisibleForTesting
    static ArtifactApi.ProxyManifest loadManifest(String retrievalToken) throws IOException {
        LOG.info("Loading manifest for retrieval token {}", (Object)retrievalToken);
        ResourceId manifestResourceId = BeamFileSystemArtifactRetrievalService.getManifestLocationFromToken(retrievalToken);
        return BeamFileSystemArtifactRetrievalService.loadManifest(manifestResourceId);
    }

    static ArtifactApi.ProxyManifest loadManifest(ResourceId manifestResourceId) throws IOException {
        return BeamFileSystemArtifactRetrievalService.loadManifest(Channels.newInputStream(FileSystems.open((ResourceId)manifestResourceId)), manifestResourceId.toString());
    }

    private static ResourceId getManifestLocationFromToken(String retrievalToken) {
        return FileSystems.matchNewResource((String)retrievalToken, (boolean)false);
    }
}

