/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.jobsubmission;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.resources.PipelineResources;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.InProcessServerFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.BeamFileSystemArtifactRetrievalService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.jobsubmission.PortablePipelineJarUtils;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.jobsubmission.PortablePipelineResult;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.jobsubmission.PortablePipelineRunner;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.repackaged.direct_java.sdk.fn.test.InProcessManagedChannelFactory;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.commons.compress.utils.IOUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortablePipelineJarCreator
implements PortablePipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(PortablePipelineJarCreator.class);
    private final Class mainClass;
    @VisibleForTesting
    JarOutputStream outputStream;
    @VisibleForTesting
    WritableByteChannel outputChannel;

    public PortablePipelineJarCreator(Class mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public PortablePipelineResult run(RunnerApi.Pipeline pipeline, JobInfo jobInfo) throws Exception {
        PortablePipelineOptions pipelineOptions = (PortablePipelineOptions)PipelineOptionsTranslation.fromProto(jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
        String jobName = jobInfo.jobName();
        File outputFile = new File(pipelineOptions.getOutputExecutablePath());
        LOG.info("Creating jar {} for job {}", (Object)outputFile.getAbsolutePath(), (Object)jobName);
        this.outputStream = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), this.createManifest(this.mainClass, jobName));
        this.outputChannel = Channels.newChannel(this.outputStream);
        PortablePipelineJarUtils.writeDefaultJobName(this.outputStream, jobName);
        this.writeClassPathResources(this.mainClass.getClassLoader(), (PipelineOptions)pipelineOptions);
        this.writeAsJson((MessageOrBuilder)pipeline, PortablePipelineJarUtils.getPipelineUri(jobName));
        this.writeAsJson((MessageOrBuilder)PipelineOptionsTranslation.toProto((PipelineOptions)pipelineOptions), PortablePipelineJarUtils.getPipelineOptionsUri(jobName));
        this.writeArtifacts(jobInfo.retrievalToken(), jobName);
        this.outputChannel.close();
        LOG.info("Jar {} created successfully.", (Object)outputFile.getAbsolutePath());
        return new JarCreatorPipelineResult();
    }

    @VisibleForTesting
    Manifest createManifest(Class mainClass, String defaultJobName) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        boolean classHasMainMethod = false;
        try {
            Class<?> returnType = mainClass.getMethod("main", String[].class).getReturnType();
            if (returnType == Void.TYPE) {
                classHasMainMethod = true;
            } else {
                LOG.warn("No Main-Class will be set in jar because main method in {} returns {}, expected void", (Object)mainClass, returnType);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("No Main-Class will be set in jar because {} lacks a main method.", (Object)mainClass);
        }
        if (classHasMainMethod) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass.getName());
        }
        return manifest;
    }

    private void writeClassPathResources(ClassLoader classLoader, PipelineOptions options) throws IOException {
        List<String> classPathResources = PipelineResources.detectClassPathResourcesToStage(classLoader, options);
        Preconditions.checkArgument((classPathResources.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly one jar on " + classLoader.toString()));
        this.copyResourcesFromJar(new JarFile(classPathResources.get(0)));
    }

    @VisibleForTesting
    protected void copyResourcesFromJar(JarFile inputJar) throws IOException {
        Enumeration<JarEntry> inputJarEntries = inputJar.entries();
        HashSet<String> previousEntryNames = new HashSet<String>((Collection<String>)ImmutableList.of((Object)"META-INF/MANIFEST.MF"));
        while (inputJarEntries.hasMoreElements()) {
            JarEntry inputJarEntry = inputJarEntries.nextElement();
            InputStream inputStream = inputJar.getInputStream(inputJarEntry);
            String entryName = inputJarEntry.getName();
            if (previousEntryNames.contains(entryName)) {
                LOG.debug("Skipping duplicated file {}", (Object)entryName);
                continue;
            }
            JarEntry outputJarEntry = new JarEntry(inputJarEntry);
            this.outputStream.putNextEntry(outputJarEntry);
            LOG.trace("Copying jar entry {}", (Object)inputJarEntry);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
            previousEntryNames.add(entryName);
        }
    }

    @VisibleForTesting
    ArtifactApi.ProxyManifest copyStagedArtifacts(String retrievalToken, ArtifactRetriever retrievalServiceStub, String jobName) throws IOException {
        ArtifactApi.GetManifestRequest manifestRequest = ArtifactApi.GetManifestRequest.newBuilder().setRetrievalToken(retrievalToken).build();
        ArtifactApi.Manifest manifest = retrievalServiceStub.getManifest(manifestRequest).getManifest();
        ArtifactApi.ProxyManifest.Builder proxyManifestBuilder = ArtifactApi.ProxyManifest.newBuilder().setManifest(manifest);
        for (ArtifactApi.ArtifactMetadata artifact : manifest.getArtifactList()) {
            String outputPath = PortablePipelineJarUtils.getArtifactUri(jobName, UUID.randomUUID().toString());
            LOG.trace("Copying artifact {} to {}", (Object)artifact.getName(), (Object)outputPath);
            proxyManifestBuilder.addLocation(ArtifactApi.ProxyManifest.Location.newBuilder().setName(artifact.getName()).setUri("/" + outputPath).build());
            this.outputStream.putNextEntry(new JarEntry(outputPath));
            ArtifactApi.GetArtifactRequest artifactRequest = ArtifactApi.GetArtifactRequest.newBuilder().setRetrievalToken(retrievalToken).setName(artifact.getName()).build();
            Iterator<ArtifactApi.ArtifactChunk> artifactResponse = retrievalServiceStub.getArtifact(artifactRequest);
            while (artifactResponse.hasNext()) {
                artifactResponse.next().getData().writeTo((OutputStream)this.outputStream);
            }
        }
        return proxyManifestBuilder.build();
    }

    private void writeArtifacts(String retrievalToken, String jobName) throws Exception {
        try (GrpcFnServer<BeamFileSystemArtifactRetrievalService> artifactServer = GrpcFnServer.allocatePortAndCreateFor(BeamFileSystemArtifactRetrievalService.create(), InProcessServerFactory.create());){
            ManagedChannel grpcChannel = InProcessManagedChannelFactory.create().forDescriptor(artifactServer.getApiServiceDescriptor());
            final ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceBlockingStub retrievalServiceStub = ArtifactRetrievalServiceGrpc.newBlockingStub((Channel)grpcChannel);
            ArtifactApi.ProxyManifest proxyManifest = this.copyStagedArtifacts(retrievalToken, new ArtifactRetriever(){

                @Override
                public ArtifactApi.GetManifestResponse getManifest(ArtifactApi.GetManifestRequest request) {
                    return retrievalServiceStub.getManifest(request);
                }

                @Override
                public Iterator<ArtifactApi.ArtifactChunk> getArtifact(ArtifactApi.GetArtifactRequest request) {
                    return retrievalServiceStub.getArtifact(request);
                }
            }, jobName);
            this.writeAsJson((MessageOrBuilder)proxyManifest, PortablePipelineJarUtils.getArtifactManifestUri(jobName));
            grpcChannel.shutdown();
        }
    }

    private void writeAsJson(MessageOrBuilder message, String outputPath) throws IOException {
        this.outputStream.putNextEntry(new JarEntry(outputPath));
        this.outputChannel.write(StandardCharsets.UTF_8.encode(JsonFormat.printer().print(message)));
    }

    private static class JarCreatorPipelineResult
    implements PortablePipelineResult {
        private JarCreatorPipelineResult() {
        }

        public PipelineResult.State getState() {
            return PipelineResult.State.DONE;
        }

        public PipelineResult.State cancel() {
            return PipelineResult.State.DONE;
        }

        public PipelineResult.State waitUntilFinish(Duration duration) {
            return PipelineResult.State.DONE;
        }

        public PipelineResult.State waitUntilFinish() {
            return PipelineResult.State.DONE;
        }

        public MetricResults metrics() {
            throw new UnsupportedOperationException("Jar creation does not yield metrics.");
        }

        @Override
        public JobApi.MetricResults portableMetrics() throws UnsupportedOperationException {
            return JobApi.MetricResults.getDefaultInstance();
        }
    }

    @VisibleForTesting
    static interface ArtifactRetriever {
        public ArtifactApi.GetManifestResponse getManifest(ArtifactApi.GetManifestRequest var1);

        public Iterator<ArtifactApi.ArtifactChunk> getArtifact(ArtifactApi.GetArtifactRequest var1);
    }
}

