/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.sdk.state.TimeDomain;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class DirectTimerInternals
implements TimerInternals {
    private final Clock processingTimeClock;
    private final WatermarkManager.TransformWatermarks watermarks;
    private final WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;

    public static DirectTimerInternals create(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new DirectTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private DirectTimerInternals(Clock clock, WatermarkManager.TransformWatermarks watermarks, WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
    }

    @Override
    public void setTimer(StateNamespace namespace, String timerId, String timerFamilyId, Instant target, Instant outputTimestamp, TimeDomain timeDomain) {
        this.timerUpdateBuilder.setTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, target, outputTimestamp, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.setTimer(timerData);
    }

    @Override
    public void deleteTimer(StateNamespace namespace, String timerId, TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(TimerInternals.TimerData timerKey) {
        this.timerUpdateBuilder.deletedTimer(timerKey);
    }

    public WatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    public boolean containsUpdateForTimeBefore(Instant time) {
        WatermarkManager.TimerUpdate update = this.timerUpdateBuilder.build();
        return this.hasTimeBefore(update.getSetTimers(), time) || this.hasTimeBefore(update.getDeletedTimers(), time);
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Override
    @Nullable
    public Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    @Override
    public Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Override
    @Nullable
    public Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }

    private boolean hasTimeBefore(Iterable<? extends TimerInternals.TimerData> timers, Instant time) {
        return StreamSupport.stream(timers.spliterator(), false).anyMatch(td -> td.getTimestamp().isBefore((ReadableInstant)time));
    }
}

