/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateMerging;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.transforms.Sum;

public class AfterPaneStateMachine
extends TriggerStateMachine {
    private static final StateTag<CombiningState<Long, long[], Long>> ELEMENTS_IN_PANE_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), Sum.ofLongs()));
    private final int countElems;

    private AfterPaneStateMachine(int countElems) {
        super(null);
        this.countElems = countElems;
    }

    public int getElementCount() {
        return this.countElems;
    }

    public static AfterPaneStateMachine elementCountAtLeast(int countElems) {
        return new AfterPaneStateMachine(countElems);
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).add((Object)1L);
    }

    @Override
    public void prefetchOnMerge(MergingStateAccessor<?, ?> state) {
        super.prefetchOnMerge(state);
        StateMerging.prefetchCombiningValues(state, ELEMENTS_IN_PANE_TAG);
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext context) throws Exception {
        if (context.trigger().finishedInAnyMergingWindow()) {
            context.trigger().setFinished(true);
            StateMerging.clear(context.state(), ELEMENTS_IN_PANE_TAG);
            return;
        }
        StateMerging.mergeCombiningValues(context.state(), ELEMENTS_IN_PANE_TAG);
    }

    @Override
    public void prefetchShouldFire(StateAccessor<?> state) {
        state.access(ELEMENTS_IN_PANE_TAG).readLater();
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        long count = (Long)context.state().access(ELEMENTS_IN_PANE_TAG).read();
        return count >= (long)this.countElems;
    }

    @Override
    public void clear(TriggerStateMachine.TriggerContext c) throws Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).clear();
    }

    @Override
    public boolean isCompatible(TriggerStateMachine other) {
        return this.equals(other);
    }

    @Override
    public String toString() {
        return "AfterPane.elementCountAtLeast(" + this.countElems + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterPaneStateMachine)) {
            return false;
        }
        AfterPaneStateMachine that = (AfterPaneStateMachine)obj;
        return this.countElems == that.countElems;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.countElems);
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        this.clear(context);
        context.trigger().setFinished(true);
    }
}

