/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.ActiveWindowSet;
import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.FinishedTriggers;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Instant;

public class TriggerStateMachineContextFactory<W extends BoundedWindow> {
    private final WindowFn<?, W> windowFn;
    private StateInternals stateInternals;
    private final Coder<W> windowCoder;

    public TriggerStateMachineContextFactory(WindowFn<?, W> windowFn, StateInternals stateInternals, ActiveWindowSet<W> activeWindows) {
        this.windowFn = windowFn;
        this.stateInternals = stateInternals;
        this.windowCoder = windowFn.windowCoder();
    }

    public TriggerStateMachine.TriggerContext base(W window, Timers timers, ExecutableTriggerStateMachine rootTrigger, FinishedTriggers finishedSet) {
        return new TriggerContextImpl(this, (BoundedWindow)window, timers, rootTrigger, finishedSet);
    }

    public TriggerStateMachine.OnElementContext createOnElementContext(W window, Timers timers, Instant elementTimestamp, ExecutableTriggerStateMachine rootTrigger, FinishedTriggers finishedSet) {
        return new OnElementContextImpl(this, (BoundedWindow)window, timers, rootTrigger, finishedSet, elementTimestamp);
    }

    public TriggerStateMachine.OnMergeContext createOnMergeContext(W window, Timers timers, ExecutableTriggerStateMachine rootTrigger, FinishedTriggers finishedSet, Map<W, FinishedTriggers> finishedSets) {
        return new OnMergeContextImpl(this, (BoundedWindow)window, timers, rootTrigger, finishedSet, finishedSets);
    }

    public StateAccessor<?> createStateAccessor(W window, ExecutableTriggerStateMachine trigger) {
        return new StateAccessorImpl(this, window, trigger);
    }

    public MergingStateAccessor<?, W> createMergingStateAccessor(W mergeResult, Collection<W> mergingWindows, ExecutableTriggerStateMachine trigger) {
        return new MergingStateAccessorImpl(this, trigger, mergingWindows, mergeResult);
    }

    private static class OnMergeContextImpl
    extends TriggerStateMachine.OnMergeContext {
        private final MergingStateAccessor<?, W> state;
        private final W window;
        private final Collection<W> mergingWindows;
        private final Timers timers;
        private final MergingTriggerInfoImpl triggerInfo;
        final /* synthetic */ TriggerStateMachineContextFactory this$0;

        private OnMergeContextImpl(W window, Timers timers, ExecutableTriggerStateMachine trigger, FinishedTriggers finishedSet, Map<W, FinishedTriggers> finishedSets) {
            this.this$0 = var1_1;
            this.mergingWindows = finishedSets.keySet();
            this.window = window;
            this.state = new MergingStateAccessorImpl((TriggerStateMachineContextFactory)var1_1, trigger, this.mergingWindows, window);
            this.timers = new TriggerTimers((TriggerStateMachineContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new MergingTriggerInfoImpl(trigger, finishedSet, this, finishedSets);
        }

        @Override
        public TriggerStateMachine.OnMergeContext forTrigger(ExecutableTriggerStateMachine trigger) {
            return new OnMergeContextImpl(this.this$0, this.window, this.timers, trigger, this.triggerInfo.finishedSet, this.triggerInfo.finishedSets);
        }

        @Override
        public MergingStateAccessor<?, W> state() {
            return this.state;
        }

        @Override
        public TriggerStateMachine.MergingTriggerInfo trigger() {
            return this.triggerInfo;
        }

        public W window() {
            return this.window;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain domain) {
            this.timers.setTimer(timestamp, domain);
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain domain) {
            this.timers.setTimer(timestamp, domain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private static class OnElementContextImpl
    extends TriggerStateMachine.OnElementContext {
        private final W window;
        private final StateAccessorImpl state;
        private final Timers timers;
        private final TriggerInfoImpl triggerInfo;
        private final Instant eventTimestamp;
        final /* synthetic */ TriggerStateMachineContextFactory this$0;

        private OnElementContextImpl(W window, Timers timers, ExecutableTriggerStateMachine trigger, FinishedTriggers finishedSet, Instant eventTimestamp) {
            this.this$0 = var1_1;
            this.window = window;
            this.state = new StateAccessorImpl((TriggerStateMachineContextFactory)var1_1, window, trigger);
            this.timers = new TriggerTimers((TriggerStateMachineContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public Instant eventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        public TriggerStateMachine.OnElementContext forTrigger(ExecutableTriggerStateMachine trigger) {
            return new OnElementContextImpl(this.this$0, this.window, this.timers, trigger, this.triggerInfo.finishedSet, this.eventTimestamp);
        }

        @Override
        public TriggerStateMachine.TriggerInfo trigger() {
            return this.triggerInfo;
        }

        @Override
        public StateAccessor<?> state() {
            return this.state;
        }

        public W window() {
            return this.window;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain domain) {
            this.timers.setTimer(timestamp, domain);
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain domain) {
            this.timers.deleteTimer(timestamp, domain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private static class TriggerContextImpl
    extends TriggerStateMachine.TriggerContext {
        private final W window;
        private final StateAccessorImpl state;
        private final Timers timers;
        private final TriggerInfoImpl triggerInfo;
        final /* synthetic */ TriggerStateMachineContextFactory this$0;

        private TriggerContextImpl(W window, Timers timers, ExecutableTriggerStateMachine trigger, FinishedTriggers finishedSet) {
            this.this$0 = var1_1;
            this.window = window;
            this.state = new StateAccessorImpl((TriggerStateMachineContextFactory)var1_1, window, trigger);
            this.timers = new TriggerTimers((TriggerStateMachineContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
        }

        @Override
        public TriggerStateMachine.TriggerContext forTrigger(ExecutableTriggerStateMachine trigger) {
            return new TriggerContextImpl(this.this$0, this.window, this.timers, trigger, this.triggerInfo.finishedSet);
        }

        @Override
        public TriggerStateMachine.TriggerInfo trigger() {
            return this.triggerInfo;
        }

        @Override
        public StateAccessor<?> state() {
            return this.state;
        }

        public W window() {
            return this.window;
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain domain) {
            this.timers.deleteTimer(timestamp, domain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private static class MergingStateAccessorImpl
    extends StateAccessorImpl
    implements MergingStateAccessor<Object, W> {
        private final Collection<W> activeToBeMerged;
        final /* synthetic */ TriggerStateMachineContextFactory this$0;

        public MergingStateAccessorImpl(ExecutableTriggerStateMachine trigger, Collection<W> activeToBeMerged, W mergeResult) {
            this.this$0 = var1_1;
            super((TriggerStateMachineContextFactory)var1_1, mergeResult, trigger);
            this.activeToBeMerged = activeToBeMerged;
        }

        @Override
        public <StateT extends State> StateT access(StateTag<StateT> address) {
            return this.this$0.stateInternals.state(this.windowNamespace, address);
        }

        @Override
        public <StateT extends State> Map<W, StateT> accessInEachMergingWindow(StateTag<StateT> address) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BoundedWindow mergingWindow : this.activeToBeMerged) {
                StateT stateForWindow = this.this$0.stateInternals.state(this.namespaceFor(mergingWindow), address);
                builder.put((Object)mergingWindow, stateForWindow);
            }
            return builder.build();
        }
    }

    private static class StateAccessorImpl
    implements StateAccessor<Object> {
        protected final int triggerIndex;
        protected final StateNamespace windowNamespace;
        final /* synthetic */ TriggerStateMachineContextFactory this$0;

        public StateAccessorImpl(W window, ExecutableTriggerStateMachine trigger) {
            this.this$0 = var1_1;
            this.triggerIndex = trigger.getTriggerIndex();
            this.windowNamespace = this.namespaceFor(window);
        }

        protected StateNamespace namespaceFor(W window) {
            return StateNamespaces.windowAndTrigger(this.this$0.windowCoder, window, this.triggerIndex);
        }

        @Override
        public <StateT extends State> StateT access(StateTag<StateT> address) {
            return this.this$0.stateInternals.state(this.windowNamespace, address);
        }
    }

    private class MergingTriggerInfoImpl
    extends TriggerInfoImpl
    implements TriggerStateMachine.MergingTriggerInfo {
        private final Map<W, FinishedTriggers> finishedSets;

        public MergingTriggerInfoImpl(ExecutableTriggerStateMachine trigger, FinishedTriggers finishedSet, TriggerStateMachine.TriggerContext context, Map<W, FinishedTriggers> finishedSets) {
            super(trigger, finishedSet, context);
            this.finishedSets = finishedSets;
        }

        @Override
        public boolean finishedInAnyMergingWindow() {
            for (FinishedTriggers finishedSet : this.finishedSets.values()) {
                if (!finishedSet.isFinished(this.trigger)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean finishedInAllMergingWindows() {
            for (FinishedTriggers finishedSet : this.finishedSets.values()) {
                if (finishedSet.isFinished(this.trigger)) continue;
                return false;
            }
            return true;
        }
    }

    private static class TriggerTimers
    implements Timers {
        private final Timers timers;
        private final W window;
        final /* synthetic */ TriggerStateMachineContextFactory this$0;

        public TriggerTimers(W window, Timers timers) {
            this.this$0 = var1_1;
            this.timers = timers;
            this.window = window;
        }

        public void setTimer(Instant timestamp, TimeDomain timeDomain) {
            this.timers.setTimer(timestamp, timeDomain);
        }

        public void setTimer(Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
            this.timers.setTimer(timestamp, outputTimestamp, timeDomain);
        }

        public void deleteTimer(Instant timestamp, TimeDomain timeDomain) {
            if (timeDomain == TimeDomain.EVENT_TIME && timestamp.equals((Object)this.window.maxTimestamp())) {
                return;
            }
            this.timers.deleteTimer(timestamp, timeDomain);
        }

        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private class TriggerInfoImpl
    implements TriggerStateMachine.TriggerInfo {
        protected final ExecutableTriggerStateMachine trigger;
        protected final FinishedTriggers finishedSet;
        private final TriggerStateMachine.TriggerContext context;

        public TriggerInfoImpl(ExecutableTriggerStateMachine trigger, FinishedTriggers finishedSet, TriggerStateMachine.TriggerContext context) {
            this.trigger = trigger;
            this.finishedSet = finishedSet;
            this.context = context;
        }

        @Override
        public boolean isMerging() {
            return !TriggerStateMachineContextFactory.this.windowFn.isNonMerging();
        }

        @Override
        public Iterable<ExecutableTriggerStateMachine> subTriggers() {
            return this.trigger.subTriggers();
        }

        @Override
        public ExecutableTriggerStateMachine subTrigger(int subtriggerIndex) {
            return this.trigger.subTriggers().get(subtriggerIndex);
        }

        @Override
        public boolean isFinished() {
            return this.finishedSet.isFinished(this.trigger);
        }

        @Override
        public boolean isFinished(int subtriggerIndex) {
            return this.finishedSet.isFinished(this.subTrigger(subtriggerIndex));
        }

        @Override
        public boolean areAllSubtriggersFinished() {
            return Iterables.isEmpty(this.unfinishedSubTriggers());
        }

        @Override
        public Iterable<ExecutableTriggerStateMachine> unfinishedSubTriggers() {
            return FluentIterable.from(this.trigger.subTriggers()).filter(trigger -> !this.finishedSet.isFinished((ExecutableTriggerStateMachine)trigger));
        }

        @Override
        @Nullable
        public ExecutableTriggerStateMachine firstUnfinishedSubTrigger() {
            for (ExecutableTriggerStateMachine subTrigger : this.trigger.subTriggers()) {
                if (this.finishedSet.isFinished(subTrigger)) continue;
                return subTrigger;
            }
            return null;
        }

        @Override
        public void resetTree() throws Exception {
            this.finishedSet.clearRecursively(this.trigger);
            this.trigger.invokeClear(this.context);
        }

        @Override
        public void setFinished(boolean finished) {
            this.finishedSet.setFinished(this.trigger, finished);
        }

        @Override
        public void setFinished(boolean finished, int subTriggerIndex) {
            this.finishedSet.setFinished(this.subTrigger(subTriggerIndex), finished);
        }
    }
}

