/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.local;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;

public abstract class StructuralKey<K> {
    private StructuralKey() {
    }

    public abstract K getKey();

    public static StructuralKey<?> empty() {
        return new StructuralKey<Object>(){

            @Override
            public Object getKey() {
                return this;
            }
        };
    }

    public static <K> StructuralKey<K> of(K key, Coder<K> coder) {
        try {
            return new CoderStructuralKey(coder, key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not encode a key with its provided coder " + coder.getClass().getSimpleName(), e);
        }
    }

    private static class CoderStructuralKey<K>
    extends StructuralKey<K> {
        private final Coder<K> coder;
        private final Object structuralValue;
        private final byte[] encoded;

        private CoderStructuralKey(Coder<K> coder, K key) throws Exception {
            this.coder = coder;
            this.structuralValue = coder.structuralValue(key);
            this.encoded = CoderUtils.encodeToByteArray(coder, key);
        }

        @Override
        public K getKey() {
            try {
                return (K)CoderUtils.decodeFromByteArray(this.coder, (byte[])this.encoded);
            }
            catch (CoderException e) {
                throw new IllegalArgumentException("Could not decode Key with coder of type " + this.coder.getClass().getSimpleName(), e);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CoderStructuralKey) {
                CoderStructuralKey that = (CoderStructuralKey)other;
                return this.structuralValue.equals(that.structuralValue);
            }
            return false;
        }

        public int hashCode() {
            return this.structuralValue.hashCode();
        }
    }
}

