/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jobsubmission;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortablePipelineJarUtils {
    private static final String ARTIFACT_FOLDER = "artifacts";
    private static final String PIPELINE_FOLDER = "BEAM-PIPELINE";
    private static final String ARTIFACT_MANIFEST = "artifact-manifest.json";
    private static final String PIPELINE = "pipeline.json";
    private static final String PIPELINE_OPTIONS = "pipeline-options.json";
    private static final String PIPELINE_MANIFEST = "BEAM-PIPELINE/pipeline-manifest.json";
    private static final Logger LOG = LoggerFactory.getLogger(PortablePipelineJarUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(new JsonFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false));

    private static InputStream getResourceFromClassPath(String resourcePath) throws IOException {
        InputStream inputStream = PortablePipelineJarUtils.class.getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("Resource %s not found on classpath.", resourcePath));
        }
        return inputStream;
    }

    private static void parseJsonResource(String resourcePath, Message.Builder builder) throws IOException {
        try (InputStream inputStream = PortablePipelineJarUtils.getResourceFromClassPath(resourcePath);){
            String contents = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
            JsonFormat.parser().merge(contents, builder);
        }
    }

    public static RunnerApi.Pipeline getPipelineFromClasspath(String jobName) throws IOException {
        RunnerApi.Pipeline.Builder builder = RunnerApi.Pipeline.newBuilder();
        PortablePipelineJarUtils.parseJsonResource(PortablePipelineJarUtils.getPipelineUri(jobName), (Message.Builder)builder);
        return builder.build();
    }

    public static Struct getPipelineOptionsFromClasspath(String jobName) throws IOException {
        Struct.Builder builder = Struct.newBuilder();
        PortablePipelineJarUtils.parseJsonResource(PortablePipelineJarUtils.getPipelineOptionsUri(jobName), (Message.Builder)builder);
        return builder.build();
    }

    public static String getArtifactManifestUri(String jobName) {
        return "BEAM-PIPELINE/" + jobName + "/" + ARTIFACT_MANIFEST;
    }

    static String getPipelineUri(String jobName) {
        return "BEAM-PIPELINE/" + jobName + "/" + PIPELINE;
    }

    static String getPipelineOptionsUri(String jobName) {
        return "BEAM-PIPELINE/" + jobName + "/" + PIPELINE_OPTIONS;
    }

    static String getArtifactUri(String jobName, String artifactId) {
        return "BEAM-PIPELINE/" + jobName + "/" + ARTIFACT_FOLDER + "/" + artifactId;
    }

    public static String getDefaultJobName() throws IOException {
        try (InputStream inputStream = PortablePipelineJarUtils.getResourceFromClassPath(PIPELINE_MANIFEST);){
            PipelineManifest pipelineManifest = (PipelineManifest)OBJECT_MAPPER.readValue(inputStream, PipelineManifest.class);
            String string = pipelineManifest.defaultJobName;
            return string;
        }
    }

    public static void writeDefaultJobName(JarOutputStream outputStream, String jobName) throws IOException {
        outputStream.putNextEntry(new JarEntry(PIPELINE_MANIFEST));
        PipelineManifest pipelineManifest = new PipelineManifest();
        pipelineManifest.defaultJobName = jobName;
        OBJECT_MAPPER.writeValue((OutputStream)outputStream, (Object)pipelineManifest);
    }

    private static class PipelineManifest {
        public String defaultJobName;

        private PipelineManifest() {
        }
    }
}

