/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SimplePushbackSideInputDoFnRunner<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements PushbackSideInputDoFnRunner<InputT, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> underlying;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views;
    private final @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader sideInputReader;
    private @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> notReadyWindows;

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized SimplePushbackSideInputDoFnRunner<InputT, OutputT> create(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> underlying, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader sideInputReader) {
        return new SimplePushbackSideInputDoFnRunner<InputT, OutputT>(underlying, views, sideInputReader);
    }

    private SimplePushbackSideInputDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> underlying, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader sideInputReader) {
        this.underlying = underlying;
        this.views = views;
        this.sideInputReader = sideInputReader;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
        return this.underlying.getFn();
    }

    @Override
    public void startBundle() {
        this.notReadyWindows = new HashSet<BoundedWindow>();
        this.underlying.startBundle();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> processElementInReadyWindows(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        if (this.views.isEmpty()) {
            this.underlying.processElement(elem);
            return Collections.emptyList();
        }
        ImmutableList.Builder pushedBack = ImmutableList.builder();
        for (WindowedValue windowElem : elem.explodeWindows()) {
            BoundedWindow mainInputWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)windowElem.getWindows());
            if (this.isReady(mainInputWindow)) {
                this.underlying.processElement(windowElem);
                continue;
            }
            this.notReadyWindows.add(mainInputWindow);
            pushedBack.add((Object)windowElem);
        }
        return pushedBack.build();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isReady(@UnknownKeyFor @NonNull @Initialized BoundedWindow mainInputWindow) {
        if (this.notReadyWindows.contains(mainInputWindow)) {
            return false;
        }
        for (PCollectionView<?> view : this.views) {
            BoundedWindow sideInputWindow;
            if (this.sideInputReader.isReady(view, sideInputWindow = view.getWindowMappingFn().getSideInputWindow(mainInputWindow))) continue;
            return false;
        }
        return true;
    }

    @Override
    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.underlying.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain);
    }

    @Override
    public void finishBundle() {
        this.notReadyWindows = null;
        this.underlying.finishBundle();
    }
}

