/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.DefaultArtifactResolver;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environments {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Environments.class);
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_DOCKER = "DOCKER";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_PROCESS = "PROCESS";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_EXTERNAL = "EXTERNAL";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_EMBEDDED = "EMBEDDED";
    public static final @UnknownKeyFor @NonNull @Initialized String ENVIRONMENT_LOOPBACK = "LOOPBACK";
    private static final @UnknownKeyFor @NonNull @Initialized String JAVA_SDK_HARNESS_CONTAINER_URL = Environments.getDefaultJavaSdkHarnessContainerUrl();
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = Environments.createDockerEnvironment(JAVA_SDK_HARNESS_CONTAINER_URL);

    private Environments() {
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createOrGetDefaultEnvironment(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options) {
        RunnerApi.Environment defaultEnvironment;
        String type = options.getDefaultEnvironmentType();
        String config = options.getDefaultEnvironmentConfig();
        if (Strings.isNullOrEmpty((String)type)) {
            defaultEnvironment = JAVA_SDK_HARNESS_ENVIRONMENT;
        } else {
            switch (type) {
                case "EMBEDDED": {
                    defaultEnvironment = Environments.createEmbeddedEnvironment(config);
                    break;
                }
                case "EXTERNAL": 
                case "LOOPBACK": {
                    defaultEnvironment = Environments.createExternalEnvironment(config);
                    break;
                }
                case "PROCESS": {
                    defaultEnvironment = Environments.createProcessEnvironment(config);
                    break;
                }
                default: {
                    defaultEnvironment = Environments.createDockerEnvironment(config);
                }
            }
        }
        return defaultEnvironment.toBuilder().addAllDependencies(Environments.getDeferredArtifacts((PipelineOptions)options)).addAllCapabilities(Environments.getJavaCapabilities()).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createDockerEnvironment(@UnknownKeyFor @NonNull @Initialized String dockerImageUrl) {
        if (Strings.isNullOrEmpty((String)dockerImageUrl)) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerImageUrl).build().toByteString()).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createExternalEnvironment(@UnknownKeyFor @NonNull @Initialized String config) {
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL)).setPayload(RunnerApi.ExternalPayload.newBuilder().setEndpoint(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(config).build()).build().toByteString()).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createProcessEnvironment(@UnknownKeyFor @NonNull @Initialized String config) {
        try {
            ProcessPayloadReferenceJSON payloadReferenceJSON = (ProcessPayloadReferenceJSON)MAPPER.readValue(config, ProcessPayloadReferenceJSON.class);
            return Environments.createProcessEnvironment(payloadReferenceJSON.getOs(), payloadReferenceJSON.getArch(), payloadReferenceJSON.getCommand(), payloadReferenceJSON.getEnv());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to parse process environment config: %s", config), e);
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createEmbeddedEnvironment(@UnknownKeyFor @NonNull @Initialized String config) {
        return RunnerApi.Environment.newBuilder().setUrn(ENVIRONMENT_EMBEDDED).setPayload(ByteString.copyFromUtf8((String)((String)MoreObjects.firstNonNull((Object)config, (Object)"")))).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment createProcessEnvironment(@UnknownKeyFor @NonNull @Initialized String os, @UnknownKeyFor @NonNull @Initialized String arch, @UnknownKeyFor @NonNull @Initialized String command, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> env) {
        RunnerApi.ProcessPayload.Builder builder = RunnerApi.ProcessPayload.newBuilder();
        if (!Strings.isNullOrEmpty((String)os)) {
            builder.setOs(os);
        }
        if (!Strings.isNullOrEmpty((String)arch)) {
            builder.setArch(arch);
        }
        if (!Strings.isNullOrEmpty((String)command)) {
            builder.setCommand(command);
        }
        if (env != null) {
            builder.putAllEnv(env);
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.PROCESS)).setPayload(builder.build().toByteString()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> getEnvironment(@UnknownKeyFor @NonNull @Initialized String ptransformId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        RunnerApi.PTransform ptransform = components.getTransformsOrThrow(ptransformId);
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironmentsOrThrow(envId));
    }

    public static @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> getEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform ptransform, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components) {
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironment(envId));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> getArtifacts(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> stagingFiles) {
        ImmutableList.Builder artifactsBuilder = ImmutableList.builder();
        LinkedHashSet<String> deduplicatedStagingFiles = new LinkedHashSet<String>(stagingFiles);
        for (String path : deduplicatedStagingFiles) {
            HashCode hashCode;
            File file;
            String stagedName = null;
            if (path.contains("=")) {
                String[] components = path.split("=", 2);
                file = new File(components[1]);
                stagedName = components[0];
            } else {
                file = new File(path);
            }
            if (!file.exists()) continue;
            RunnerApi.ArtifactInformation.Builder artifactBuilder = RunnerApi.ArtifactInformation.newBuilder();
            artifactBuilder.setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE));
            artifactBuilder.setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO));
            if (file.isDirectory()) {
                File zippedFile;
                try {
                    zippedFile = Environments.zipDirectory(file);
                    hashCode = Files.asByteSource((File)zippedFile).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(zippedFile.getPath()).setSha256(hashCode.toString()).build().toByteString());
            } else {
                try {
                    hashCode = Files.asByteSource((File)file).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(file.getPath()).setSha256(hashCode.toString()).build().toByteString());
            }
            if (stagedName == null) {
                stagedName = Environments.createStagingFileName(file, hashCode);
            }
            artifactBuilder.setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName(stagedName).build().toByteString());
            artifactsBuilder.add((Object)artifactBuilder.build());
        }
        return artifactsBuilder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ArtifactInformation> getDeferredArtifacts(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        List stagingFiles = ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).getFilesToStage();
        if (stagingFiles == null || stagingFiles.isEmpty()) {
            return ImmutableList.of();
        }
        String key = UUID.randomUUID().toString();
        DefaultArtifactResolver.INSTANCE.register(info -> {
            if (BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.DEFERRED).equals(info.getTypeUrn())) {
                RunnerApi.DeferredArtifactPayload deferredArtifactPayload;
                try {
                    deferredArtifactPayload = RunnerApi.DeferredArtifactPayload.parseFrom((ByteString)info.getTypePayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing deferred artifact payload.", e);
                }
                if (key.equals(deferredArtifactPayload.getKey())) {
                    return Optional.of(Environments.getArtifacts(stagingFiles));
                }
                return Optional.empty();
            }
            return Optional.empty();
        });
        return ImmutableList.of((Object)RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.DEFERRED)).setTypePayload(RunnerApi.DeferredArtifactPayload.newBuilder().setKey(key).build().toByteString()).build());
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getJavaCapabilities() {
        ImmutableSet.Builder capabilities = ImmutableSet.builder();
        capabilities.addAll(ModelCoders.urns());
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.MULTI_CORE_BUNDLE_PROCESSING));
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.PROGRESS_REPORTING));
        capabilities.add((Object)("beam:version:sdk_base:" + JAVA_SDK_HARNESS_CONTAINER_URL));
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.TRUNCATE_SIZED_RESTRICTION));
        return capabilities.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized JavaVersion getJavaVersion() {
        return JavaVersion.forSpecification(System.getProperty("java.specification.version"));
    }

    public static @UnknownKeyFor @NonNull @Initialized String createStagingFileName(@UnknownKeyFor @NonNull @Initialized File path, @UnknownKeyFor @NonNull @Initialized HashCode hash) {
        String encodedHash = Base64Variants.MODIFIED_FOR_URL.encode(hash.asBytes());
        String fileName = Files.getNameWithoutExtension((String)path.getAbsolutePath());
        String ext = path.isDirectory() ? "jar" : Files.getFileExtension((String)path.getAbsolutePath());
        String suffix = Strings.isNullOrEmpty((String)ext) ? "" : "." + ext;
        return String.format("%s-%s%s", fileName, encodedHash, suffix);
    }

    private static @UnknownKeyFor @NonNull @Initialized File zipDirectory(@UnknownKeyFor @NonNull @Initialized File directory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        File zipFile = File.createTempFile(directory.getName(), ".zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            ZipFiles.zipDirectory((File)directory, (OutputStream)fos);
        }
        return zipFile;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getDefaultJavaSdkHarnessContainerUrl() {
        return String.format("%s/%s%s_sdk:%s", ReleaseInfo.getReleaseInfo().getDefaultDockerRepoRoot(), ReleaseInfo.getReleaseInfo().getDefaultDockerRepoPrefix(), Environments.getJavaVersion().toString(), ReleaseInfo.getReleaseInfo().getSdkVersion());
    }

    private static class ProcessPayloadReferenceJSON {
        private @Nullable @UnknownKeyFor @Initialized String os;
        private @Nullable @UnknownKeyFor @Initialized String arch;
        private @Nullable @UnknownKeyFor @Initialized String command;
        private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> env;

        private ProcessPayloadReferenceJSON() {
        }

        public @Nullable @UnknownKeyFor @Initialized String getOs() {
            return this.os;
        }

        public @Nullable @UnknownKeyFor @Initialized String getArch() {
            return this.arch;
        }

        public @Nullable @UnknownKeyFor @Initialized String getCommand() {
            return this.command;
        }

        public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getEnv() {
            return this.env;
        }
    }

    public static enum JavaVersion {
        v8("java8", "1.8"),
        v11("java11", "11");

        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized String specification;

        private JavaVersion(String name, String specification) {
            this.name = name;
            this.specification = specification;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name;
        }

        public @UnknownKeyFor @NonNull @Initialized String specification() {
            return this.specification;
        }

        public static @UnknownKeyFor @NonNull @Initialized JavaVersion forSpecification(@UnknownKeyFor @NonNull @Initialized String specification) {
            for (JavaVersion ver : JavaVersion.values()) {
                if (!ver.specification.equals(specification)) continue;
                return ver;
            }
            throw new UnsupportedOperationException(String.format("unsupported Java version: %s", specification));
        }
    }
}

