/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.Collection;
import java.util.List;
import org.apache.beam.runners.direct.repackaged.runners.core.DoFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.KeyedWorkItem;
import org.apache.beam.runners.direct.repackaged.runners.core.LateDataDroppingDoFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.ProcessFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.direct.repackaged.runners.core.SideInputReader;
import org.apache.beam.runners.direct.repackaged.runners.core.SimpleDoFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.direct.repackaged.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.StepContext;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

public class DoFnRunners {
    public static <InputT, OutputT> DoFnRunner<InputT, OutputT> simpleRunner(PipelineOptions options, DoFn<InputT, OutputT> fn, SideInputReader sideInputReader, OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, StepContext stepContext, WindowingStrategy<?, ?> windowingStrategy) {
        return new SimpleDoFnRunner<InputT, OutputT>(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, windowingStrategy);
    }

    public static <K, InputT, OutputT, W extends BoundedWindow> DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> lateDataDroppingRunner(DoFnRunner<KeyedWorkItem<K, InputT>, KV<K, OutputT>> wrappedRunner, StepContext stepContext, WindowingStrategy<?, W> windowingStrategy) {
        return new LateDataDroppingDoFnRunner(wrappedRunner, windowingStrategy, stepContext.timerInternals());
    }

    public static <InputT, OutputT, W extends BoundedWindow> DoFnRunner<InputT, OutputT> defaultStatefulDoFnRunner(DoFn<InputT, OutputT> fn, DoFnRunner<InputT, OutputT> doFnRunner, WindowingStrategy<?, ?> windowingStrategy, StatefulDoFnRunner.CleanupTimer cleanupTimer, StatefulDoFnRunner.StateCleaner<W> stateCleaner) {
        return new StatefulDoFnRunner<InputT, OutputT, W>(doFnRunner, windowingStrategy, cleanupTimer, stateCleaner);
    }

    public static <InputT, OutputT, RestrictionT> ProcessFnRunner<InputT, OutputT, RestrictionT> newProcessFnRunner(SplittableParDoViaKeyedWorkItems.ProcessFn<InputT, OutputT, RestrictionT, ?> fn, PipelineOptions options, Collection<PCollectionView<?>> views, ReadyCheckingSideInputReader sideInputReader, OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, StepContext stepContext, WindowingStrategy<?, ?> windowingStrategy) {
        return new ProcessFnRunner(DoFnRunners.simpleRunner(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, windowingStrategy), views, sideInputReader);
    }

    public static interface OutputManager {
        public <T> void output(TupleTag<T> var1, WindowedValue<T> var2);
    }
}

