/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.ByteString;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nonnull;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Environments;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformInputs;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

public class CombineTranslation {
    public static final String JAVA_SERIALIZED_COMBINE_FN_URN = "urn:beam:combinefn:javasdk:v1";

    static RunnerApi.CombinePayload payloadForCombineLike(CombineLike combine, SdkComponents components) throws IOException {
        return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(components.registerCoder(combine.getAccumulatorCoder())).putAllSideInputs(combine.getSideInputs()).setCombineFn(combine.getCombineFn()).build();
    }

    static <K, InputT, OutputT> RunnerApi.CombinePayload payloadForCombine(final AppliedPTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>, Combine.PerKey<K, InputT, OutputT>> combine, final SdkComponents components) throws IOException {
        return CombineTranslation.payloadForCombineLike(new CombineLike(){

            @Override
            public RunnerApi.SdkFunctionSpec getCombineFn() {
                return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CombineTranslation.JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray((Serializable)((Combine.PerKey)combine.getTransform()).getFn()))).build()).build();
            }

            @Override
            public Coder<?> getAccumulatorCoder() {
                CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
                try {
                    return CombineTranslation.extractAccumulatorCoder(combineFn, combine);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public Map<String, RunnerApi.SideInput> getSideInputs() {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView sideInput : ((Combine.PerKey)combine.getTransform()).getSideInputs()) {
                    sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
                }
                return sideInputs;
            }
        }, components);
    }

    public static List<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof Combine.PerKey) {
            return ((Combine.PerKey)transform).getSideInputs();
        }
        SdkComponents sdkComponents = SdkComponents.create();
        RunnerApi.PTransform combineProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.CombinePayload payload = RunnerApi.CombinePayload.parseFrom(combineProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = sideInputEntry.getValue();
            PCollection originalPCollection = Preconditions.checkNotNull((PCollection)application.getInputs().get(new TupleTag(sideInputTag)), "no input with tag %s", (Object)sideInputTag);
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, combineProto, components));
        }
        return views;
    }

    @VisibleForTesting
    static RunnerApi.CombinePayload toProto(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> combine, SdkComponents sdkComponents) throws IOException {
        CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
        try {
            Coder accumulatorCoder = CombineTranslation.extractAccumulatorCoder(combineFn, combine);
            HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
            return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(sdkComponents.registerCoder(accumulatorCoder)).putAllSideInputs(sideInputs).setCombineFn(CombineTranslation.toProto(combineFn, sdkComponents)).build();
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, InputT>>, ?, Combine.PerKey<K, InputT, ?>> transform) throws CannotProvideCoderException {
        PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
        KvCoder inputCoder = (KvCoder)mainInput.getCoder();
        return AppliedCombineFn.withInputCoder(combineFn, (CoderRegistry)transform.getPipeline().getCoderRegistry(), (KvCoder)inputCoder, (Iterable)((Combine.PerKey)transform.getTransform()).getSideInputs(), (WindowingStrategy)((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getWindowingStrategy()).getAccumulatorCoder();
    }

    public static RunnerApi.SdkFunctionSpec toProto(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.registerEnvironment(Environments.JAVA_SDK_HARNESS_ENVIRONMENT)).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(combineFn))).build()).build();
    }

    public static Coder<?> getAccumulatorCoder(RunnerApi.CombinePayload payload, RehydratedComponents components) throws IOException {
        String id = payload.getAccumulatorCoderId();
        return components.getCoder(id);
    }

    public static Coder<?> getAccumulatorCoder(AppliedPTransform<?, ?, ?> transform) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create();
        String id = CombineTranslation.getCombinePayload(transform, sdkComponents).getAccumulatorCoderId();
        RunnerApi.Components components = sdkComponents.toComponents();
        return CoderTranslation.fromProto(components.getCodersOrThrow(id), RehydratedComponents.forComponents(components));
    }

    public static CombineFnBase.GlobalCombineFn<?, ?, ?> getCombineFn(RunnerApi.CombinePayload payload) throws IOException {
        Preconditions.checkArgument(payload.getCombineFn().getSpec().getUrn().equals(JAVA_SERIALIZED_COMBINE_FN_URN));
        return (CombineFnBase.GlobalCombineFn)SerializableUtils.deserializeFromByteArray((byte[])payload.getCombineFn().getSpec().getPayload().toByteArray(), (String)"CombineFn");
    }

    public static CombineFnBase.GlobalCombineFn<?, ?, ?> getCombineFn(AppliedPTransform<?, ?, ?> transform) throws IOException {
        return CombineTranslation.getCombineFn(CombineTranslation.getCombinePayload(transform));
    }

    private static RunnerApi.CombinePayload getCombinePayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        return CombineTranslation.getCombinePayload(transform, SdkComponents.create());
    }

    private static RunnerApi.CombinePayload getCombinePayload(AppliedPTransform<?, ?, ?> transform, SdkComponents components) throws IOException {
        return RunnerApi.CombinePayload.parseFrom(PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    private static class RawCombine<K, InputT, AccumT, OutputT>
    extends PTransformTranslation.RawPTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>>
    implements CombineLike {
        private final RunnerApi.PTransform protoTransform;
        private final transient RehydratedComponents rehydratedComponents;
        private final RunnerApi.FunctionSpec spec;
        private final RunnerApi.CombinePayload payload;
        private final Coder<AccumT> accumulatorCoder;

        private RawCombine(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            this.protoTransform = protoTransform;
            this.rehydratedComponents = rehydratedComponents;
            this.spec = protoTransform.getSpec();
            this.payload = RunnerApi.CombinePayload.parseFrom(this.spec.getPayload());
            try {
                this.accumulatorCoder = rehydratedComponents.getCoder(this.payload.getAccumulatorCoderId());
            }
            catch (IOException exc) {
                throw new IllegalArgumentException(String.format("Failure extracting accumulator coder with id '%s' for %s", this.payload.getAccumulatorCoderId(), Combine.class.getSimpleName()), exc);
            }
        }

        @Override
        public String getUrn() {
            return "urn:beam:transform:combine:v1";
        }

        @Override
        @Nonnull
        public RunnerApi.FunctionSpec getSpec() {
            return this.spec;
        }

        @Override
        public RunnerApi.FunctionSpec migrate(SdkComponents sdkComponents) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:combine:v1").setPayload(CombineTranslation.payloadForCombineLike(this, sdkComponents).toByteString()).build();
        }

        @Override
        public RunnerApi.SdkFunctionSpec getCombineFn() {
            return this.payload.getCombineFn();
        }

        @Override
        public Coder<?> getAccumulatorCoder() {
            return this.accumulatorCoder;
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            HashMap additionalInputs = new HashMap();
            for (Map.Entry<String, RunnerApi.SideInput> sideInputEntry : this.payload.getSideInputsMap().entrySet()) {
                try {
                    additionalInputs.put((TupleTag<?>)new TupleTag(sideInputEntry.getKey()), (PValue)this.rehydratedComponents.getPCollection(this.protoTransform.getInputsOrThrow(sideInputEntry.getKey())));
                }
                catch (IOException exc) {
                    throw new IllegalStateException(String.format("Could not find input with name %s for %s transform", sideInputEntry.getKey(), Combine.class.getSimpleName()));
                }
            }
            return additionalInputs;
        }

        @Override
        public Map<String, RunnerApi.SideInput> getSideInputs() {
            return this.payload.getSideInputsMap();
        }
    }

    static interface CombineLike {
        public RunnerApi.SdkFunctionSpec getCombineFn();

        public Coder<?> getAccumulatorCoder();

        public Map<String, RunnerApi.SideInput> getSideInputs();
    }

    public static class CombinePayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.PerKey<?, ?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new CombinePayloadTranslator();
        }

        private CombinePayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.PerKey<?, ?, ?> transform) {
            return "urn:beam:transform:combine:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> transform, SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:combine:v1").setPayload(CombineTranslation.payloadForCombine(transform, components).toByteString()).build();
        }

        @Override
        public PTransformTranslation.RawPTransform<?, ?> rehydrate(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            Preconditions.checkArgument(protoTransform.getSpec() != null, "%s received transform with null spec", (Object)this.getClass().getSimpleName());
            Preconditions.checkArgument(protoTransform.getSpec().getUrn().equals("urn:beam:transform:combine:v1"));
            return new RawCombine(protoTransform, rehydratedComponents);
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(Combine.PerKey.class, new CombinePayloadTranslator());
            }

            @Override
            public Map<String, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformRehydrators() {
                return Collections.singletonMap("urn:beam:transform:combine:v1", new CombinePayloadTranslator());
            }
        }
    }
}

