/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.util.ReleaseInfo;

public class Environments {
    private static final Map<String, EnvironmentIdExtractor> KNOWN_URN_SPEC_EXTRACTORS = ImmutableMap.builder().put("urn:beam:transform:combine:v1", Environments::combineExtractor).put("urn:beam:transform:pardo:v1", Environments::parDoExtractor).put("urn:beam:transform:read:v1", Environments::readExtractor).put("urn:beam:transform:window:v1", Environments::windowExtractor).build();
    private static final EnvironmentIdExtractor DEFAULT_SPEC_EXTRACTOR = transform -> null;
    private static final String JAVA_SDK_HARNESS_CONTAINER_URL = String.format("%s-%s", ReleaseInfo.getReleaseInfo().getName(), ReleaseInfo.getReleaseInfo().getVersion());
    public static final RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = RunnerApi.Environment.newBuilder().setUrl(JAVA_SDK_HARNESS_CONTAINER_URL).build();

    private Environments() {
    }

    public static Optional<RunnerApi.Environment> getEnvironment(RunnerApi.PTransform ptransform, RehydratedComponents components) {
        try {
            String envId = KNOWN_URN_SPEC_EXTRACTORS.getOrDefault(ptransform.getSpec().getUrn(), DEFAULT_SPEC_EXTRACTOR).getEnvironmentId(ptransform);
            if (envId != null) {
                return Optional.of(components.getEnvironment(envId));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parDoExtractor(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        return RunnerApi.ParDoPayload.parseFrom(pTransform.getSpec().getPayload()).getDoFn().getEnvironmentId();
    }

    private static String combineExtractor(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        return RunnerApi.CombinePayload.parseFrom(pTransform.getSpec().getPayload()).getCombineFn().getEnvironmentId();
    }

    private static String readExtractor(RunnerApi.PTransform transform) throws InvalidProtocolBufferException {
        return RunnerApi.ReadPayload.parseFrom(transform.getSpec().getPayload()).getSource().getEnvironmentId();
    }

    private static String windowExtractor(RunnerApi.PTransform transform) throws InvalidProtocolBufferException {
        return RunnerApi.WindowIntoPayload.parseFrom(transform.getSpec().getPayload()).getWindowFn().getEnvironmentId();
    }

    private static interface EnvironmentIdExtractor {
        @Nullable
        public String getEnvironmentId(RunnerApi.PTransform var1) throws IOException;
    }
}

