/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DistributionCell
implements Distribution,
MetricCell<DistributionData> {
    private final DirtyState dirty = new DirtyState();
    private final AtomicReference<DistributionData> value = new AtomicReference<DistributionData>(DistributionData.EMPTY);
    private final MetricName name;

    public DistributionCell(MetricName name) {
        this.name = name;
    }

    @Override
    public void reset() {
        this.dirty.afterModification();
        this.value.set(DistributionData.EMPTY);
    }

    public void update(long n) {
        this.update(DistributionData.singleton(n));
    }

    public void update(long sum, long count, long min, long max) {
        this.update(DistributionData.create(sum, count, min, max));
    }

    void update(DistributionData data) {
        DistributionData original;
        while (!this.value.compareAndSet(original = this.value.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public DistributionData getCumulative() {
        return this.value.get();
    }

    public MetricName getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof DistributionCell) {
            DistributionCell distributionCell = (DistributionCell)object;
            return Objects.equals(this.dirty, distributionCell.dirty) && Objects.equals(this.value.get(), distributionCell.value.get()) && Objects.equals(this.name, distributionCell.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dirty, this.value.get(), this.name);
    }
}

