/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.beam.repackaged.direct_java.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformMatchers;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CloningBundleFactory;
import org.apache.beam.runners.direct.DirectGBKIntoKeyedWorkItemsOverrideFactory;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.DirectGraphVisitor;
import org.apache.beam.runners.direct.DirectGroupByKeyOverrideFactory;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.runners.direct.DirectTestOptions;
import org.apache.beam.runners.direct.DirectWriteViewVisitor;
import org.apache.beam.runners.direct.DisplayDataValidator;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ExecutorServiceParallelExecutor;
import org.apache.beam.runners.direct.ImmutabilityCheckingBundleFactory;
import org.apache.beam.runners.direct.ImmutabilityEnforcementFactory;
import org.apache.beam.runners.direct.ImmutableListBundleFactory;
import org.apache.beam.runners.direct.KeyedPValueTrackingVisitor;
import org.apache.beam.runners.direct.ModelEnforcementFactory;
import org.apache.beam.runners.direct.MultiStepCombine;
import org.apache.beam.runners.direct.NanosOffsetClock;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.runners.direct.PipelineExecutor;
import org.apache.beam.runners.direct.RootProviderRegistry;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.runners.direct.TransformEvaluatorRegistry;
import org.apache.beam.runners.direct.WriteWithShardingFactory;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.joda.time.Duration;

public class DirectRunner
extends PipelineRunner<DirectPipelineResult> {
    private DirectOptions options;
    private final Set<Enforcement> enabledEnforcements;
    private Supplier<Clock> clockSupplier = new NanosOffsetClockSupplier();
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));

    public static DirectRunner fromOptions(PipelineOptions options) {
        return new DirectRunner((DirectOptions)options.as(DirectOptions.class));
    }

    private DirectRunner(DirectOptions options) {
        this.options = options;
        this.enabledEnforcements = Enforcement.enabled(options);
    }

    Supplier<Clock> getClockSupplier() {
        return this.clockSupplier;
    }

    void setClockSupplier(Supplier<Clock> supplier) {
        this.clockSupplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectPipelineResult run(Pipeline pipeline) {
        try {
            this.options = (DirectOptions)((PipelineOptions)MAPPER.readValue(MAPPER.writeValueAsBytes((Object)this.options), PipelineOptions.class)).as(DirectOptions.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("PipelineOptions specified failed to serialize to JSON.", e);
        }
        this.performRewrites(pipeline);
        MetricsEnvironment.setMetricsSupported((boolean)true);
        try {
            DirectGraphVisitor graphVisitor = new DirectGraphVisitor();
            pipeline.traverseTopologically((Pipeline.PipelineVisitor)graphVisitor);
            KeyedPValueTrackingVisitor keyedPValueVisitor = KeyedPValueTrackingVisitor.create();
            pipeline.traverseTopologically((Pipeline.PipelineVisitor)keyedPValueVisitor);
            DisplayDataValidator.validatePipeline(pipeline);
            DisplayDataValidator.validateOptions(this.options);
            ExecutorService metricsPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setThreadFactory(MoreExecutors.platformThreadFactory()).setDaemon(false).setNameFormat("direct-metrics-counter-committer").build());
            DirectGraph graph = graphVisitor.getGraph();
            EvaluationContext context = EvaluationContext.create((Clock)this.clockSupplier.get(), Enforcement.bundleFactoryFor(this.enabledEnforcements, graph), graph, keyedPValueVisitor.getKeyedPValues(), metricsPool);
            TransformEvaluatorRegistry registry = TransformEvaluatorRegistry.javaSdkNativeRegistry(context, this.options);
            ExecutorServiceParallelExecutor executor = ExecutorServiceParallelExecutor.create(this.options.getTargetParallelism(), registry, Enforcement.defaultModelEnforcements(this.enabledEnforcements), context, metricsPool);
            executor.start(graph, RootProviderRegistry.javaNativeRegistry(context, this.options));
            DirectPipelineResult result = new DirectPipelineResult(executor, context);
            if (this.options.isBlockOnRun()) {
                try {
                    result.waitUntilFinish();
                }
                catch (UserCodeException userException) {
                    throw new Pipeline.PipelineExecutionException(userException.getCause());
                }
                catch (Throwable t) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
            DirectPipelineResult directPipelineResult = result;
            return directPipelineResult;
        }
        finally {
            MetricsEnvironment.setMetricsSupported((boolean)false);
        }
    }

    @VisibleForTesting
    void performRewrites(Pipeline pipeline) {
        pipeline.replaceAll(this.sideInputUsingTransformOverrides());
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new DirectWriteViewVisitor());
        pipeline.replaceAll(this.groupByKeyOverrides());
        SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary(pipeline);
    }

    private List<PTransformOverride> sideInputUsingTransformOverrides() {
        DirectTestOptions testOptions = (DirectTestOptions)this.options.as(DirectTestOptions.class);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (testOptions.isRunnerDeterminedSharding()) {
            builder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.writeWithRunnerDeterminedSharding(), new WriteWithShardingFactory()));
        }
        builder.add((Object)PTransformOverride.of((PTransformMatcher)MultiStepCombine.matcher(), (PTransformOverrideFactory)MultiStepCombine.Factory.create())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.urnEqualTo("beam:transform:teststream:v1"), new TestStreamEvaluatorFactory.DirectTestStreamFactory(this)));
        return builder.build();
    }

    private List<PTransformOverride> groupByKeyOverrides() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder = builder.add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.splittableParDo(), new ParDoMultiOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.stateOrTimerParDo(), new ParDoMultiOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.urnEqualTo("beam:transform:sdf_process_keyed_elements:v1"), new SplittableParDoViaKeyedWorkItems.OverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.urnEqualTo("beam:runners_core:transforms:splittable_gbkikwi:v1"), new DirectGBKIntoKeyedWorkItemsOverrideFactory())).add((Object)PTransformOverride.of((PTransformMatcher)PTransformMatchers.urnEqualTo("beam:transform:group_by_key:v1"), new DirectGroupByKeyOverrideFactory()));
        return builder.build();
    }

    private static class NanosOffsetClockSupplier
    implements Supplier<Clock> {
        private NanosOffsetClockSupplier() {
        }

        public Clock get() {
            return NanosOffsetClock.create();
        }
    }

    public static class DirectPipelineResult
    implements PipelineResult {
        private final PipelineExecutor executor;
        private final EvaluationContext evaluationContext;
        private PipelineResult.State state;

        private DirectPipelineResult(PipelineExecutor executor, EvaluationContext evaluationContext) {
            this.executor = executor;
            this.evaluationContext = evaluationContext;
            this.state = PipelineResult.State.RUNNING;
        }

        public PipelineResult.State getState() {
            return this.state;
        }

        public MetricResults metrics() {
            return this.evaluationContext.getMetrics();
        }

        public PipelineResult.State waitUntilFinish() {
            return this.waitUntilFinish(Duration.ZERO);
        }

        public PipelineResult.State cancel() {
            this.state = this.executor.getPipelineState();
            if (!this.state.isTerminal()) {
                this.executor.stop();
                this.state = this.executor.getPipelineState();
            }
            return this.executor.getPipelineState();
        }

        public PipelineResult.State waitUntilFinish(Duration duration) {
            PipelineResult.State endState;
            if (this.state.isTerminal()) {
                return this.state;
            }
            try {
                endState = this.executor.waitUntilFinish(duration);
            }
            catch (UserCodeException uce) {
                throw new Pipeline.PipelineExecutionException(uce.getCause());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            if (endState != null) {
                this.state = endState;
            }
            return endState;
        }
    }

    static enum Enforcement {
        ENCODABILITY{

            @Override
            public boolean appliesTo(PCollection<?> collection, DirectGraph graph) {
                return true;
            }
        }
        ,
        IMMUTABILITY{

            @Override
            public boolean appliesTo(PCollection<?> collection, DirectGraph graph) {
                return !ImmutabilityEnforcementFactory.isReadTransform(graph.getProducer((PValue)collection)) && CONTAINS_UDF.contains(PTransformTranslation.urnForTransform(graph.getProducer((PValue)collection).getTransform()));
            }
        };

        private static final Set<String> CONTAINS_UDF;

        public abstract boolean appliesTo(PCollection<?> var1, DirectGraph var2);

        static Set<Enforcement> enabled(DirectOptions options) {
            EnumSet<Enforcement> enabled = EnumSet.noneOf(Enforcement.class);
            if (options.isEnforceEncodability()) {
                enabled.add(ENCODABILITY);
            }
            if (options.isEnforceImmutability()) {
                enabled.add(IMMUTABILITY);
            }
            return Collections.unmodifiableSet(enabled);
        }

        static BundleFactory bundleFactoryFor(Set<Enforcement> enforcements, DirectGraph graph) {
            BundleFactory bundleFactory;
            BundleFactory bundleFactory2 = bundleFactory = enforcements.contains((Object)ENCODABILITY) ? CloningBundleFactory.create() : ImmutableListBundleFactory.create();
            if (enforcements.contains((Object)IMMUTABILITY)) {
                bundleFactory = ImmutabilityCheckingBundleFactory.create(bundleFactory, graph);
            }
            return bundleFactory;
        }

        private static Map<String, Collection<ModelEnforcementFactory>> defaultModelEnforcements(Set<Enforcement> enabledEnforcements) {
            ImmutableMap.Builder enforcements = ImmutableMap.builder();
            ImmutableList.Builder enabledParDoEnforcements = ImmutableList.builder();
            if (enabledEnforcements.contains((Object)IMMUTABILITY)) {
                enabledParDoEnforcements.add((Object)ImmutabilityEnforcementFactory.create());
            }
            ImmutableList parDoEnforcements = enabledParDoEnforcements.build();
            enforcements.put((Object)"beam:transform:pardo:v1", (Object)parDoEnforcements);
            return enforcements.build();
        }

        static {
            CONTAINS_UDF = ImmutableSet.of((Object)"beam:transform:read:v1", (Object)"beam:transform:pardo:v1");
        }
    }
}

