/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.resources;

import io.github.classgraph.ClassGraph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.direct_java.runners.core.construction.resources.PipelineResourcesDetector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ClasspathScanningResourcesDetector
implements PipelineResourcesDetector {
    private transient @UnknownKeyFor @NonNull @Initialized ClassGraph classGraph;

    public ClasspathScanningResourcesDetector(@UnknownKeyFor @NonNull @Initialized ClassGraph classGraph) {
        this.classGraph = classGraph;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> detect(@UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) {
        List classpathContents = this.classGraph.disableNestedJarScanning().addClassLoader(classLoader).scan(1).getClasspathFiles();
        return classpathContents.stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }
}

