/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.CounterCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.HistogramCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricUpdates;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricsMap;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.ShortIdMap;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsContainerImpl
implements Serializable,
MetricsContainer {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetricsContainerImpl.class);
    protected final @Nullable @UnknownKeyFor @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized boolean isProcessWide;
    private @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized CounterCell> counters = new MetricsMap<MetricName, CounterCell>(CounterCell::new);
    private @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized DistributionCell> distributions = new MetricsMap<MetricName, DistributionCell>(DistributionCell::new);
    private @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized GaugeCell> gauges = new MetricsMap<MetricName, GaugeCell>(GaugeCell::new);
    private @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized MetricName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType>, @UnknownKeyFor @NonNull @Initialized HistogramCell> histograms = new MetricsMap<KV, HistogramCell>(HistogramCell::new);
    @SuppressFBWarnings(justification="No bug", value={"SE_BAD_FIELD"})
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>> shortIdsByMetricKey = new ConcurrentHashMap<MetricKey, Optional<String>>();

    private MetricsContainerImpl(@Nullable @UnknownKeyFor @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized boolean isProcessWide) {
        this.stepName = stepName;
        this.isProcessWide = isProcessWide;
    }

    public MetricsContainerImpl(@Nullable @UnknownKeyFor @Initialized String stepName) {
        this(stepName, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl createProcessWideContainer() {
        return new MetricsContainerImpl(null, true);
    }

    public void reset() {
        if (this.isProcessWide) {
            throw new RuntimeException("Process Wide metric containers must not be reset");
        }
        this.reset(this.counters);
        this.reset(this.distributions);
        this.reset(this.gauges);
        this.reset(this.histograms);
    }

    private void reset(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MetricCell<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> cells) {
        for (MetricCell<?> cell : cells.values()) {
            cell.reset();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized CounterCell getCounter(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
        return this.counters.get(metricName);
    }

    public @Nullable @UnknownKeyFor @Initialized CounterCell tryGetCounter(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
        return this.counters.tryGet(metricName);
    }

    public @UnknownKeyFor @NonNull @Initialized DistributionCell getDistribution(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
        return this.distributions.get(metricName);
    }

    public @Nullable @UnknownKeyFor @Initialized DistributionCell tryGetDistribution(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
        return this.distributions.tryGet(metricName);
    }

    public @UnknownKeyFor @NonNull @Initialized HistogramCell getHistogram(@UnknownKeyFor @NonNull @Initialized MetricName metricName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType) {
        return this.histograms.get((KV<MetricName, HistogramData.BucketType>)KV.of((Object)metricName, (Object)bucketType));
    }

    public @Nullable @UnknownKeyFor @Initialized HistogramCell tryGetHistogram(@UnknownKeyFor @NonNull @Initialized MetricName metricName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType) {
        return this.histograms.tryGet((KV<MetricName, HistogramData.BucketType>)KV.of((Object)metricName, (Object)bucketType));
    }

    public @UnknownKeyFor @NonNull @Initialized GaugeCell getGauge(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
        return this.gauges.get(metricName);
    }

    public @Nullable @UnknownKeyFor @Initialized GaugeCell tryGetGauge(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
        return this.gauges.tryGet(metricName);
    }

    private <UpdateT, CellT extends MetricCell<UpdateT>> @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized MetricUpdates.MetricUpdate<UpdateT>> extractUpdates(@UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            if (!((MetricCell)cell.getValue()).getDirty().beforeCommit()) continue;
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create((String)this.stepName, (MetricName)cell.getKey()), ((MetricCell)cell.getValue()).getCumulative()));
        }
        return updates.build();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricUpdates getUpdates() {
        return MetricUpdates.create(this.extractUpdates(this.counters), this.extractUpdates(this.distributions), this.extractUpdates(this.gauges));
    }

    private @Nullable @UnknownKeyFor @Initialized SimpleMonitoringInfoBuilder metricToMonitoringMetadata(@UnknownKeyFor @NonNull @Initialized MetricKey metricKey, @UnknownKeyFor @NonNull @Initialized String typeUrn, @UnknownKeyFor @NonNull @Initialized String userUrn) {
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder(true);
        builder.setType(typeUrn);
        MetricName metricName = metricKey.metricName();
        if (metricName instanceof MonitoringInfoMetricName) {
            MonitoringInfoMetricName monitoringInfoName = (MonitoringInfoMetricName)metricName;
            builder.setUrn(monitoringInfoName.getUrn());
            for (Map.Entry<String, String> e : monitoringInfoName.getLabels().entrySet()) {
                builder.setLabel(e.getKey(), e.getValue());
            }
        } else {
            if (this.stepName == null) {
                return null;
            }
            builder.setUrn(userUrn).setLabel("NAMESPACE", metricKey.metricName().getNamespace()).setLabel("NAME", metricKey.metricName().getName()).setLabel("PTRANSFORM", metricKey.stepName());
        }
        return builder;
    }

    private @Nullable @UnknownKeyFor @Initialized SimpleMonitoringInfoBuilder counterToMonitoringMetadata(@UnknownKeyFor @NonNull @Initialized MetricKey metricKey) {
        return this.metricToMonitoringMetadata(metricKey, "beam:metrics:sum_int64:v1", MonitoringInfoConstants.Urns.USER_SUM_INT64);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized MetricsApi.MonitoringInfo counterUpdateToMonitoringInfo(@UnknownKeyFor @NonNull @Initialized MetricUpdates.MetricUpdate<@UnknownKeyFor @NonNull @Initialized Long> metricUpdate) {
        SimpleMonitoringInfoBuilder builder = this.counterToMonitoringMetadata(metricUpdate.getKey());
        if (builder == null) {
            return null;
        }
        builder.setInt64SumValue(metricUpdate.getUpdate());
        return builder.build();
    }

    private @Nullable @UnknownKeyFor @Initialized SimpleMonitoringInfoBuilder distributionToMonitoringMetadata(@UnknownKeyFor @NonNull @Initialized MetricKey metricKey) {
        return this.metricToMonitoringMetadata(metricKey, "beam:metrics:distribution_int64:v1", MonitoringInfoConstants.Urns.USER_DISTRIBUTION_INT64);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized MetricsApi.MonitoringInfo distributionUpdateToMonitoringInfo(@UnknownKeyFor @NonNull @Initialized MetricUpdates.MetricUpdate<@UnknownKeyFor @NonNull @Initialized DistributionData> metricUpdate) {
        SimpleMonitoringInfoBuilder builder = this.distributionToMonitoringMetadata(metricUpdate.getKey());
        if (builder == null) {
            return null;
        }
        builder.setInt64DistributionValue(metricUpdate.getUpdate());
        return builder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> getMonitoringInfos() {
        MetricsApi.MonitoringInfo mi;
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        MetricUpdates metricUpdates = this.getUpdates();
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : metricUpdates.counterUpdates()) {
            mi = this.counterUpdateToMonitoringInfo(metricUpdate);
            if (mi == null) continue;
            monitoringInfos.add(mi);
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : metricUpdates.distributionUpdates()) {
            mi = this.distributionUpdateToMonitoringInfo(metricUpdate);
            if (mi == null) continue;
            monitoringInfos.add(mi);
        }
        return monitoringInfos;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> getMonitoringData(@UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds) {
        String shortId;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        MetricUpdates metricUpdates = this.getUpdates();
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : metricUpdates.counterUpdates()) {
            shortId = this.getShortId(metricUpdate.getKey(), this::counterToMonitoringMetadata, shortIds);
            if (shortId == null) continue;
            builder.put((Object)shortId, (Object)MonitoringInfoEncodings.encodeInt64Counter(metricUpdate.getUpdate()));
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : metricUpdates.distributionUpdates()) {
            shortId = this.getShortId(metricUpdate.getKey(), this::distributionToMonitoringMetadata, shortIds);
            if (shortId == null) continue;
            builder.put((Object)shortId, (Object)MonitoringInfoEncodings.encodeInt64Distribution((DistributionData)metricUpdate.getUpdate()));
        }
        return builder.build();
    }

    private @UnknownKeyFor @NonNull @Initialized String getShortId(@UnknownKeyFor @NonNull @Initialized MetricKey key, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder> toInfo, @UnknownKeyFor @NonNull @Initialized ShortIdMap shortIds) {
        Optional<Object> shortId = this.shortIdsByMetricKey.get(key);
        if (shortId == null) {
            MetricsApi.MonitoringInfo monitoringInfo;
            SimpleMonitoringInfoBuilder monitoringInfoBuilder = toInfo.apply(key);
            shortId = monitoringInfoBuilder == null ? Optional.empty() : ((monitoringInfo = monitoringInfoBuilder.build()) == null ? Optional.empty() : Optional.of(shortIds.getOrCreateShortId(monitoringInfo)));
            this.shortIdsByMetricKey.put(key, shortId);
        }
        return shortId.orElse(null);
    }

    private void commitUpdates(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MetricCell<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> cells) {
        for (MetricCell<?> cell : cells.values()) {
            cell.getDirty().afterCommit();
        }
    }

    public void commitUpdates() {
        this.commitUpdates(this.counters);
        this.commitUpdates(this.distributions);
        this.commitUpdates(this.gauges);
    }

    private <UserT extends Metric, UpdateT, CellT extends MetricCell<UpdateT>> @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized MetricUpdates.MetricUpdate<UpdateT>> extractCumulatives(@UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            Object update = Preconditions.checkNotNull(((MetricCell)cell.getValue()).getCumulative());
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create((String)this.stepName, (MetricName)cell.getKey()), update));
        }
        return updates.build();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricUpdates getCumulative() {
        return MetricUpdates.create(this.extractCumulatives(this.counters), this.extractCumulatives(this.distributions), this.extractCumulatives(this.gauges));
    }

    public void update(@UnknownKeyFor @NonNull @Initialized MetricsContainerImpl other) {
        this.updateCounters(this.counters, other.counters);
        this.updateDistributions(this.distributions, other.distributions);
        this.updateGauges(this.gauges, other.gauges);
        this.updateHistograms(this.histograms, other.histograms);
    }

    private void updateForSumInt64Type(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
        CounterCell counter = this.getCounter(metricName);
        counter.inc(MonitoringInfoEncodings.decodeInt64Counter(monitoringInfo.getPayload()));
    }

    private void updateForDistributionInt64Type(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
        DistributionCell distribution = this.getDistribution(metricName);
        DistributionData data = MonitoringInfoEncodings.decodeInt64Distribution(monitoringInfo.getPayload());
        distribution.update(data.sum(), data.count(), data.min(), data.max());
    }

    private void updateForLatestInt64Type(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
        GaugeCell gauge = this.getGauge(metricName);
        gauge.update(MonitoringInfoEncodings.decodeInt64Gauge(monitoringInfo.getPayload()));
    }

    public void update(@UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> monitoringInfos) {
        block10: for (MetricsApi.MonitoringInfo monitoringInfo : monitoringInfos) {
            if (monitoringInfo.getPayload().isEmpty()) {
                return;
            }
            switch (monitoringInfo.getType()) {
                case "beam:metrics:sum_int64:v1": {
                    this.updateForSumInt64Type(monitoringInfo);
                    continue block10;
                }
                case "beam:metrics:distribution_int64:v1": {
                    this.updateForDistributionInt64Type(monitoringInfo);
                    continue block10;
                }
                case "beam:metrics:latest_int64:v1": {
                    this.updateForLatestInt64Type(monitoringInfo);
                    continue block10;
                }
            }
            LOG.warn("Unsupported metric type {}", (Object)monitoringInfo.getType());
        }
    }

    private void updateCounters(@UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized CounterCell> current, @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized CounterCell> updates) {
        for (Map.Entry<MetricName, CounterCell> counter : updates.entries()) {
            current.get(counter.getKey()).inc(counter.getValue().getCumulative());
        }
    }

    private void updateDistributions(@UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized DistributionCell> current, @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized DistributionCell> updates) {
        for (Map.Entry<MetricName, DistributionCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    private void updateGauges(@UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized GaugeCell> current, @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized MetricName, @UnknownKeyFor @NonNull @Initialized GaugeCell> updates) {
        for (Map.Entry<MetricName, GaugeCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    private void updateHistograms(@UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized MetricName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType>, @UnknownKeyFor @NonNull @Initialized HistogramCell> current, @UnknownKeyFor @NonNull @Initialized MetricsMap<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized MetricName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType>, @UnknownKeyFor @NonNull @Initialized HistogramCell> updates) {
        for (Map.Entry<KV<MetricName, HistogramData.BucketType>, HistogramCell> histogram : updates.entries()) {
            HistogramCell h = histogram.getValue();
            current.get(histogram.getKey()).update(h);
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof MetricsContainerImpl) {
            MetricsContainerImpl metricsContainerImpl = (MetricsContainerImpl)object;
            return Objects.equals(this.stepName, metricsContainerImpl.stepName) && Objects.equals(this.counters, metricsContainerImpl.counters) && Objects.equals(this.distributions, metricsContainerImpl.distributions) && Objects.equals(this.gauges, metricsContainerImpl.gauges);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.stepName, this.counters, this.distributions, this.gauges);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized boolean matchMetric(@UnknownKeyFor @NonNull @Initialized MetricName metricName, @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedMetricUrns) {
        if (allowedMetricUrns == null) {
            return true;
        }
        if (metricName instanceof MonitoringInfoMetricName) {
            return allowedMetricUrns.contains(((MonitoringInfoMetricName)metricName).getUrn());
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized String getCumulativeString(@Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedMetricUrns) {
        Serializable data;
        StringBuilder message = new StringBuilder();
        for (Map.Entry<MetricName, CounterCell> entry : this.counters.entries()) {
            if (!MetricsContainerImpl.matchMetric(entry.getKey(), allowedMetricUrns)) continue;
            message.append(entry.getKey().toString());
            message.append(" = ");
            message.append(entry.getValue().getCumulative());
            message.append("\n");
        }
        for (Map.Entry<MetricName, MetricCell<Long>> entry : this.distributions.entries()) {
            if (!MetricsContainerImpl.matchMetric(entry.getKey(), allowedMetricUrns)) continue;
            message.append(entry.getKey().toString());
            message.append(" = ");
            data = ((DistributionCell)entry.getValue()).getCumulative();
            message.append(String.format("{sum: %d, count: %d, min: %d, max: %d}", ((DistributionData)data).sum(), ((DistributionData)data).count(), ((DistributionData)data).min(), ((DistributionData)data).max()));
            message.append("\n");
        }
        for (Map.Entry<MetricName, MetricCell<Long>> entry : this.gauges.entries()) {
            if (!MetricsContainerImpl.matchMetric(entry.getKey(), allowedMetricUrns)) continue;
            message.append(entry.getKey().toString());
            message.append(" = ");
            data = ((GaugeCell)entry.getValue()).getCumulative();
            message.append(String.format("{timestamp: %s, value: %d}", ((GaugeData)data).timestamp(), ((GaugeData)data).value()));
            message.append("\n");
        }
        for (Map.Entry<MetricName, MetricCell<Long>> entry : this.histograms.entries()) {
            if (!MetricsContainerImpl.matchMetric((MetricName)((KV)entry.getKey()).getKey(), allowedMetricUrns)) continue;
            message.append(((MetricName)((KV)entry.getKey()).getKey()).toString());
            message.append(" = ");
            data = ((HistogramCell)entry.getValue()).getCumulative();
            if (data.getTotalCount() > 0L) {
                message.append(String.format("{count: %d, p50: %f, p90: %f, p99: %f}", data.getTotalCount(), data.p50(), data.p90(), data.p99()));
            } else {
                message.append("{count: 0}");
            }
            message.append("\n");
        }
        return message.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl deltaContainer(@Nullable @UnknownKeyFor @Initialized MetricsContainerImpl prev, @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl curr) {
        if (prev == null) {
            return curr;
        }
        MetricsContainerImpl deltaContainer = new MetricsContainerImpl(curr.stepName);
        for (Map.Entry<MetricName, CounterCell> entry : curr.counters.entries()) {
            Long prevValue = prev.counters.get(entry.getKey()).getCumulative();
            Long currValue = entry.getValue().getCumulative();
            deltaContainer.counters.get(entry.getKey()).inc(currValue - prevValue);
        }
        for (Map.Entry<MetricName, MetricCell<Long>> entry : curr.gauges.entries()) {
            deltaContainer.gauges.get(entry.getKey()).update(((GaugeCell)entry.getValue()).getCumulative());
        }
        for (Map.Entry<MetricName, MetricCell<Long>> entry : curr.histograms.entries()) {
            HistogramData.BucketType bt = (HistogramData.BucketType)((KV)entry.getKey()).getValue();
            HistogramData prevValue = prev.histograms.get((KV<MetricName, HistogramData.BucketType>)((KV)entry.getKey())).getCumulative();
            HistogramData currValue = ((HistogramCell)entry.getValue()).getCumulative();
            HistogramCell deltaValueCell = deltaContainer.histograms.get((KV<MetricName, HistogramData.BucketType>)((KV)entry.getKey()));
            deltaValueCell.incBottomBucketCount(currValue.getBottomBucketCount() - prevValue.getBottomBucketCount());
            for (int i = 0; i < bt.getNumBuckets(); ++i) {
                Long bucketCountDelta = currValue.getCount(i) - prevValue.getCount(i);
                deltaValueCell.incBucketCount(i, bucketCountDelta);
            }
            deltaValueCell.incTopBucketCount(currValue.getTopBucketCount() - prevValue.getTopBucketCount());
        }
        return deltaContainer;
    }
}

