/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.Collection;
import java.util.Collections;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class ProcessFnRunner<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT>
implements PushbackSideInputDoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>, OutputT> underlying;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views;
    private final @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader sideInputReader;

    public ProcessFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>, OutputT> underlying, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader sideInputReader) {
        this.underlying = underlying;
        this.views = views;
        this.sideInputReader = sideInputReader;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>, OutputT> getFn() {
        return this.underlying.getFn();
    }

    @Override
    public void startBundle() {
        this.underlying.startBundle();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>>> processElementInReadyWindows(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>> windowedKWI) {
        ProcessFnRunner.checkTrivialOuterWindows(windowedKWI);
        BoundedWindow window = ProcessFnRunner.getUnderlyingWindow((KeyedWorkItem)windowedKWI.getValue());
        if (!this.isReady(window)) {
            return Collections.singletonList(windowedKWI);
        }
        this.underlying.processElement(windowedKWI);
        return Collections.emptyList();
    }

    @Override
    public void finishBundle() {
        this.underlying.finishBundle();
    }

    @Override
    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        throw new UnsupportedOperationException("User timers unsupported in ProcessFn");
    }

    @Override
    public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, KeyT key) {
        throw new UnsupportedOperationException("OnWindowExpiration unsupported in ProcessFn");
    }

    private static <T> void checkTrivialOuterWindows(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], T>> windowedKWI) {
        Collection outerWindows = windowedKWI.getWindows();
        if (!outerWindows.isEmpty()) {
            Preconditions.checkArgument((outerWindows.size() == 1 ? 1 : 0) != 0, (String)"The KeyedWorkItem itself must not be in multiple windows, but was in: %s", (Object)outerWindows);
            BoundedWindow onlyWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)outerWindows);
            Preconditions.checkArgument((boolean)(onlyWindow instanceof GlobalWindow), (String)"KeyedWorkItem must be in the Global window, but was in: %s", (Object)onlyWindow);
        }
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized BoundedWindow getUnderlyingWindow(@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], T> kwi) {
        if (Iterables.isEmpty(kwi.elementsIterable())) {
            TimerInternals.TimerData timer = (TimerInternals.TimerData)Iterables.getOnlyElement(kwi.timersIterable());
            return ((StateNamespaces.WindowNamespace)timer.getNamespace()).getWindow();
        }
        WindowedValue value = (WindowedValue)Iterables.getOnlyElement(kwi.elementsIterable());
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)value.getWindows());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isReady(@UnknownKeyFor @NonNull @Initialized BoundedWindow mainInputWindow) {
        for (PCollectionView<?> view : this.views) {
            BoundedWindow sideInputWindow;
            if (this.sideInputReader.isReady(view, sideInputWindow = view.getWindowMappingFn().getSideInputWindow(mainInputWindow))) continue;
            return false;
        }
        return true;
    }
}

