/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.ActiveWindowSet;
import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.ReduceFn;
import org.apache.beam.repackaged.direct_java.runners.core.SideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.StateContexts;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class ReduceFnContextFactory<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
    private final K key;
    private final @UnknownKeyFor @NonNull @Initialized ReduceFn<K, InputT, OutputT, W> reduceFn;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals;
    private final @UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows;
    private final @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals;
    private final @Nullable @UnknownKeyFor @Initialized SideInputReader sideInputReader;
    private final @Nullable @UnknownKeyFor @Initialized PipelineOptions options;

    ReduceFnContextFactory(K key, @UnknownKeyFor @NonNull @Initialized ReduceFn<K, InputT, OutputT, W> reduceFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, @UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows, @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals, @Nullable @UnknownKeyFor @Initialized SideInputReader sideInputReader, @Nullable @UnknownKeyFor @Initialized PipelineOptions options) {
        this.key = key;
        this.reduceFn = reduceFn;
        this.windowingStrategy = windowingStrategy;
        this.stateInternals = stateInternals;
        this.activeWindows = activeWindows;
        this.timerInternals = timerInternals;
        this.sideInputReader = sideInputReader;
        this.options = options;
    }

    private @UnknownKeyFor @NonNull @Initialized StateAccessorImpl<K, W> stateAccessor(W window, @UnknownKeyFor @NonNull @Initialized StateStyle style) {
        return new StateAccessorImpl(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, ReduceFnContextFactory.stateContextFromComponents(this.options, this.sideInputReader, window), style);
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context base(W window, @UnknownKeyFor @NonNull @Initialized StateStyle style) {
        return new ContextImpl(this.stateAccessor(window, style));
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized ProcessValueContext forValue(W window, InputT value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized StateStyle style) {
        return new ProcessValueContextImpl(this.stateAccessor(window, style), value, timestamp);
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnTriggerContext forTrigger(W window, @UnknownKeyFor @NonNull @Initialized PaneInfo pane, @UnknownKeyFor @NonNull @Initialized StateStyle style, @UnknownKeyFor @NonNull @Initialized OnTriggerCallbacks<OutputT> callbacks) {
        return new OnTriggerContextImpl(this.stateAccessor(window, style), pane, callbacks);
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnMergeContext forMerge(@UnknownKeyFor @NonNull @Initialized Collection<W> activeToBeMerged, W mergeResult, @UnknownKeyFor @NonNull @Initialized StateStyle style) {
        return new OnMergeContextImpl(new MergingStateAccessorImpl(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, style, activeToBeMerged, mergeResult));
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnMergeContext forPremerge(W window) {
        return new OnPremergeContextImpl(new PremergingStateAccessorImpl(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, window));
    }

    private static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateContext<W> stateContextFromComponents(final @Nullable @UnknownKeyFor @Initialized PipelineOptions options, final @Nullable @UnknownKeyFor @Initialized SideInputReader sideInputReader, final W mainInputWindow) {
        if (options == null || sideInputReader == null) {
            return StateContexts.windowOnlyContext(mainInputWindow);
        }
        return new StateContext<W>(){

            public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
                return options;
            }

            public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                return sideInputReader.get(view, view.getWindowMappingFn().getSideInputWindow(mainInputWindow));
            }

            public W window() {
                return mainInputWindow;
            }
        };
    }

    private static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateContext<W> stateContextForWindowOnly(final W window) {
        return new StateContext<W>(){

            public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
                throw new IllegalArgumentException("cannot call getPipelineOptions() in a window only context");
            }

            public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                throw new IllegalArgumentException("cannot call sideInput() in a window only context");
            }

            public W window() {
                return window;
            }
        };
    }

    static /* synthetic */ ReduceFn access$700(ReduceFnContextFactory x0) {
        return x0.reduceFn;
    }

    private class OnPremergeContextImpl
    extends ReduceFn.OnMergeContext {
        private final @UnknownKeyFor @NonNull @Initialized PremergingStateAccessorImpl<K, W> state;
        private final @UnknownKeyFor @NonNull @Initialized ReduceFnContextFactory. @UnknownKeyFor @NonNull @Initialized TimersImpl timers;

        private OnPremergeContextImpl(PremergingStateAccessorImpl<K, W> state) {
            this.state = state;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timers timers() {
            return this.timers;
        }
    }

    private class OnMergeContextImpl
    extends ReduceFn.OnMergeContext {
        private final @UnknownKeyFor @NonNull @Initialized MergingStateAccessorImpl<K, W> state;
        private final @UnknownKeyFor @NonNull @Initialized ReduceFnContextFactory. @UnknownKeyFor @NonNull @Initialized TimersImpl timers;

        private OnMergeContextImpl(MergingStateAccessorImpl<K, W> state) {
            this.state = state;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timers timers() {
            return this.timers;
        }
    }

    private class OnTriggerContextImpl
    extends ReduceFn.OnTriggerContext {
        private final @UnknownKeyFor @NonNull @Initialized StateAccessorImpl<K, W> state;
        private final @UnknownKeyFor @NonNull @Initialized PaneInfo pane;
        private final @UnknownKeyFor @NonNull @Initialized OnTriggerCallbacks<OutputT> callbacks;
        private final @UnknownKeyFor @NonNull @Initialized ReduceFnContextFactory. @UnknownKeyFor @NonNull @Initialized TimersImpl timers;

        private OnTriggerContextImpl(@UnknownKeyFor @NonNull @Initialized StateAccessorImpl<K, W> state, @UnknownKeyFor @NonNull @Initialized PaneInfo pane, OnTriggerCallbacks<OutputT> callbacks) {
            this.state = state;
            this.pane = pane;
            this.callbacks = callbacks;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StateAccessor<K> state() {
            return this.state;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo() {
            return this.pane;
        }

        @Override
        public void output(OutputT value) {
            this.callbacks.output(value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timers timers() {
            return this.timers;
        }
    }

    private class ProcessValueContextImpl
    extends ReduceFn.ProcessValueContext {
        private final InputT value;
        private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;
        private final @UnknownKeyFor @NonNull @Initialized StateAccessorImpl<K, W> state;
        private final @UnknownKeyFor @NonNull @Initialized ReduceFnContextFactory. @UnknownKeyFor @NonNull @Initialized TimersImpl timers;

        private ProcessValueContextImpl(StateAccessorImpl<K, W> state, @UnknownKeyFor @NonNull @Initialized InputT value, Instant timestamp) {
            this.state = state;
            this.value = value;
            this.timestamp = timestamp;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StateAccessor<K> state() {
            return this.state;
        }

        @Override
        public InputT value() {
            return this.value;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timers timers() {
            return this.timers;
        }
    }

    private class ContextImpl
    extends ReduceFn.Context {
        private final @UnknownKeyFor @NonNull @Initialized StateAccessorImpl<K, W> state;
        private final @UnknownKeyFor @NonNull @Initialized ReduceFnContextFactory. @UnknownKeyFor @NonNull @Initialized TimersImpl timers;

        private ContextImpl(StateAccessorImpl<K, W> state) {
            this.state = state;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StateAccessor<K> state() {
            return this.state;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timers timers() {
            return this.timers;
        }
    }

    static class PremergingStateAccessorImpl<@UnknownKeyFor K, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends StateAccessorImpl<K, W>
    implements MergingStateAccessor<K, W> {
        public PremergingStateAccessorImpl(@UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, W window) {
            super(activeWindows, windowCoder, stateInternals, ReduceFnContextFactory.stateContextForWindowOnly(window), StateStyle.RENAMED);
        }

        @UnknownKeyFor @NonNull @Initialized Collection<W> mergingWindows() {
            return this.activeWindows.readStateAddresses(this.context.window());
        }

        @Override
        public <StateT extends State> @UnknownKeyFor @NonNull @Initialized Map<W, StateT> accessInEachMergingWindow(@UnknownKeyFor @NonNull @Initialized StateTag<StateT> address) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BoundedWindow stateAddressWindow : this.activeWindows.readStateAddresses(this.context.window())) {
                StateT stateForWindow = this.stateInternals.state(this.namespaceFor(stateAddressWindow), address, this.context);
                builder.put((Object)stateAddressWindow, stateForWindow);
            }
            return builder.build();
        }
    }

    static class MergingStateAccessorImpl<@UnknownKeyFor K, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends StateAccessorImpl<K, W>
    implements MergingStateAccessor<K, W> {
        private final @UnknownKeyFor @NonNull @Initialized Collection<W> activeToBeMerged;

        public MergingStateAccessorImpl(@UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, @UnknownKeyFor @NonNull @Initialized StateStyle style, @UnknownKeyFor @NonNull @Initialized Collection<W> activeToBeMerged, W mergeResult) {
            super(activeWindows, windowCoder, stateInternals, ReduceFnContextFactory.stateContextForWindowOnly(mergeResult), style);
            this.activeToBeMerged = activeToBeMerged;
        }

        @Override
        public <StateT extends State> StateT access(@UnknownKeyFor @NonNull @Initialized StateTag<StateT> address) {
            switch (this.style) {
                case DIRECT: {
                    return this.stateInternals.state(this.windowNamespace(), address, this.context);
                }
                case RENAMED: {
                    return this.stateInternals.state(this.namespaceFor(this.activeWindows.mergedWriteStateAddress(this.activeToBeMerged, this.context.window())), address, this.context);
                }
            }
            throw new RuntimeException();
        }

        @Override
        public <StateT extends State> @UnknownKeyFor @NonNull @Initialized Map<W, StateT> accessInEachMergingWindow(@UnknownKeyFor @NonNull @Initialized StateTag<StateT> address) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BoundedWindow mergingWindow : this.activeToBeMerged) {
                StateNamespace namespace = null;
                switch (this.style) {
                    case DIRECT: {
                        namespace = this.namespaceFor(mergingWindow);
                        break;
                    }
                    case RENAMED: {
                        namespace = this.namespaceFor(this.activeWindows.writeStateAddress(mergingWindow));
                    }
                }
                Preconditions.checkNotNull(namespace);
                builder.put((Object)mergingWindow, this.stateInternals.state(namespace, address, this.context));
            }
            return builder.build();
        }
    }

    static class StateAccessorImpl<@UnknownKeyFor K, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    implements StateAccessor<K> {
        protected final @UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows;
        protected final @UnknownKeyFor @NonNull @Initialized StateContext<W> context;
        protected final @UnknownKeyFor @NonNull @Initialized StateNamespace windowNamespace;
        protected final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;
        protected final @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals;
        protected final @UnknownKeyFor @NonNull @Initialized StateStyle style;

        public StateAccessorImpl(@UnknownKeyFor @NonNull @Initialized ActiveWindowSet<W> activeWindows, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, @UnknownKeyFor @NonNull @Initialized StateContext<W> context, @UnknownKeyFor @NonNull @Initialized StateStyle style) {
            this.activeWindows = activeWindows;
            this.windowCoder = windowCoder;
            this.stateInternals = stateInternals;
            this.context = (StateContext)Preconditions.checkNotNull(context);
            this.windowNamespace = this.namespaceFor(context.window());
            this.style = style;
        }

        protected @UnknownKeyFor @NonNull @Initialized StateNamespace namespaceFor(W window) {
            return StateNamespaces.window(this.windowCoder, window);
        }

        protected @UnknownKeyFor @NonNull @Initialized StateNamespace windowNamespace() {
            return this.windowNamespace;
        }

        W window() {
            return (W)this.context.window();
        }

        @UnknownKeyFor @NonNull @Initialized StateNamespace namespace() {
            return this.windowNamespace();
        }

        @Override
        public <StateT extends State> StateT access(@UnknownKeyFor @NonNull @Initialized StateTag<StateT> address) {
            switch (this.style) {
                case DIRECT: {
                    return this.stateInternals.state(this.windowNamespace(), address, this.context);
                }
                case RENAMED: {
                    return this.stateInternals.state(this.namespaceFor(this.activeWindows.writeStateAddress(this.context.window())), address, this.context);
                }
            }
            throw new RuntimeException();
        }
    }

    private class TimersImpl
    implements Timers {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;

        public TimersImpl(StateNamespace namespace) {
            Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
            this.namespace = namespace;
        }

        public void setTimer(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.setTimer(TimerInternals.TimerData.of(this.namespace, timestamp, timestamp, timeDomain));
        }

        public void setTimer(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.setTimer(TimerInternals.TimerData.of(this.namespace, timestamp, outputTimestamp, timeDomain));
        }

        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.deleteTimer(TimerInternals.TimerData.of(this.namespace, timestamp, timestamp, timeDomain));
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
            return ReduceFnContextFactory.this.timerInternals.currentProcessingTime();
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
            return ReduceFnContextFactory.this.timerInternals.currentSynchronizedProcessingTime();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentEventTime() {
            return ReduceFnContextFactory.this.timerInternals.currentInputWatermarkTime();
        }
    }

    public static enum StateStyle {
        DIRECT,
        RENAMED;

    }

    public static interface OnTriggerCallbacks<@UnknownKeyFor OutputT> {
        public void output(OutputT var1);
    }
}

