/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.renderer;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.construction.renderer.PortablePipelineDotRenderer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PipelineDotRenderer
implements Pipeline.PipelineVisitor {
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder dotBuilder = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized Integer> valueToProducerNodeId = new HashMap<PValue, Integer>();
    private @UnknownKeyFor @NonNull @Initialized int indent;
    private @UnknownKeyFor @NonNull @Initialized int nextNodeId;

    public static @UnknownKeyFor @NonNull @Initialized String toDotString(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        PipelineDotRenderer visitor = new PipelineDotRenderer();
        visitor.begin();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        visitor.end();
        return visitor.dotBuilder.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String toDotString(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        return PortablePipelineDotRenderer.toDotString(pipeline);
    }

    private PipelineDotRenderer() {
    }

    public void enterPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
    }

    public void leavePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        this.writeLine("subgraph cluster_%d {", this.nextNodeId++);
        this.enterBlock();
        this.writeLine("label = \"%s\"", PipelineDotRenderer.escapeString(node.getFullName()));
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        this.exitBlock();
        this.writeLine("}", new Object[0]);
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        int nodeId = this.nextNodeId++;
        this.writeLine("%d [label=\"%s\"]", nodeId, PipelineDotRenderer.escapeString(node.getTransform().getName()));
        node.getOutputs().values().forEach(x -> this.valueToProducerNodeId.put((PValue)x, nodeId));
        node.getInputs().forEach((key, value) -> {
            int producerId = this.valueToProducerNodeId.get(value);
            String style = "solid";
            if (node.getTransform().getAdditionalInputs().containsKey(key)) {
                style = "dashed";
            }
            this.writeLine("%d -> %d [style=%s label=\"%s\"]", producerId, nodeId, style, "");
        });
    }

    public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
    }

    private void begin() {
        this.writeLine("digraph {", new Object[0]);
        this.enterBlock();
        this.writeLine("rankdir=LR", new Object[0]);
    }

    private void end() {
        this.exitBlock();
        this.writeLine("}", new Object[0]);
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    @FormatMethod
    private void writeLine(@FormatString @UnknownKeyFor @NonNull @Initialized String format, Object ... args) {
        if (this.indent != 0) {
            this.dotBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.dotBuilder.append(String.format(format, args));
        this.dotBuilder.append(System.lineSeparator());
    }

    private static @UnknownKeyFor @NonNull @Initialized String escapeString(@UnknownKeyFor @NonNull @Initialized String x) {
        return x.replace("\"", "\\\"");
    }
}

