/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Map;
import java.util.NavigableSet;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class DirectTimerInternals
implements TimerInternals {
    private final @UnknownKeyFor @NonNull @Initialized Clock processingTimeClock;
    private final  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimeDomain, @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> modifiedTimers;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> modifiedTimerIds;

    public static @UnknownKeyFor @NonNull @Initialized DirectTimerInternals create(@UnknownKeyFor @NonNull @Initialized Clock clock,  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks, @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new DirectTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private DirectTimerInternals(@UnknownKeyFor @NonNull @Initialized Clock clock,  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks, @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
        this.modifiedTimers = Maps.newHashMap();
        this.modifiedTimers.put(TimeDomain.EVENT_TIME, Sets.newTreeSet());
        this.modifiedTimers.put(TimeDomain.PROCESSING_TIME, Sets.newTreeSet());
        this.modifiedTimers.put(TimeDomain.SYNCHRONIZED_PROCESSING_TIME, Sets.newTreeSet());
        this.modifiedTimerIds = Maps.newHashMap();
    }

    @Override
    public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.setTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, target, outputTimestamp, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.setTimer(timerData);
        this.getModifiedTimersOrdered(timerData.getDomain()).add(timerData);
        this.modifiedTimerIds.put(timerData.stringKey(), timerData);
    }

    @Override
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.deleteTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, BoundedWindow.TIMESTAMP_MIN_VALUE, BoundedWindow.TIMESTAMP_MAX_VALUE, timeDomain));
    }

    @Override
    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
        throw new UnsupportedOperationException("Canceling of timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        this.timerUpdateBuilder.deletedTimer(timerData);
        this.modifiedTimerIds.put(timerData.stringKey(), timerData.deleted());
    }

    public @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getModifiedTimersOrdered(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        NavigableSet<TimerInternals.TimerData> modified = this.modifiedTimers.get(timeDomain);
        if (modified == null) {
            throw new IllegalStateException("Unexpected time domain " + timeDomain);
        }
        return modified;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getModifiedTimerIds() {
        return this.modifiedTimerIds;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }
}

