/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_JavaRowUdf_Configuration;
import org.apache.beam.sdk.schemas.transforms.providers.StringCompiler;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JavaRowUdf
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Configuration config;
    private final @UnknownKeyFor @NonNull @Initialized Schema inputSchema;
    private final @UnknownKeyFor @NonNull @Initialized Schema.FieldType outputType;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> function;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized Type> NULLABLE_PRIMITIVES = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte.class).put((Object)Schema.TypeName.INT16, Short.class).put((Object)Schema.TypeName.INT32, Integer.class).put((Object)Schema.TypeName.INT64, Long.class).put((Object)Schema.TypeName.FLOAT, Float.class).put((Object)Schema.TypeName.DOUBLE, Double.class).put((Object)Schema.TypeName.BOOLEAN, Boolean.class).put((Object)Schema.TypeName.BYTES, byte[].class).put((Object)Schema.TypeName.STRING, String.class).put((Object)Schema.TypeName.DECIMAL, BigDecimal.class).build();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized Type> NON_NULLABLE_PRIMITIVES = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte.TYPE).put((Object)Schema.TypeName.INT16, Short.TYPE).put((Object)Schema.TypeName.INT32, Integer.TYPE).put((Object)Schema.TypeName.INT64, Long.TYPE).put((Object)Schema.TypeName.FLOAT, Float.TYPE).put((Object)Schema.TypeName.DOUBLE, Double.TYPE).put((Object)Schema.TypeName.BOOLEAN, Boolean.TYPE).put((Object)Schema.TypeName.BYTES, byte[].class).put((Object)Schema.TypeName.STRING, String.class).put((Object)Schema.TypeName.DECIMAL, BigDecimal.class).build();

    public JavaRowUdf(@UnknownKeyFor @NonNull @Initialized Configuration config, @UnknownKeyFor @NonNull @Initialized Schema inputSchema) throws @UnknownKeyFor @NonNull @Initialized MalformedURLException, @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException, @UnknownKeyFor @NonNull @Initialized StringCompiler.CompileException {
        this.config = config;
        this.inputSchema = inputSchema;
        FunctionAndType functionAndType = JavaRowUdf.createFunction(config, inputSchema);
        this.outputType = functionAndType.outputType;
        this.function = functionAndType.function;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getOutputType() {
        return this.outputType;
    }

    public @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> getFunction() throws @UnknownKeyFor @NonNull @Initialized MalformedURLException, @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException, @UnknownKeyFor @NonNull @Initialized StringCompiler.CompileException {
        if (this.function == null) {
            FunctionAndType functionAndType = JavaRowUdf.createFunction(this.config, this.inputSchema);
            assert (functionAndType.outputType.equals(this.outputType));
            this.function = functionAndType.function;
        }
        return this.function;
    }

    private static @UnknownKeyFor @NonNull @Initialized FunctionAndType createFunction(@UnknownKeyFor @NonNull @Initialized Configuration config, @UnknownKeyFor @NonNull @Initialized Schema inputSchema) throws @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException, @UnknownKeyFor @NonNull @Initialized StringCompiler.CompileException, @UnknownKeyFor @NonNull @Initialized MalformedURLException {
        config.validate();
        if (!Strings.isNullOrEmpty((String)config.getExpression())) {
            return JavaRowUdf.createFunctionFromExpression(config.getExpression(), inputSchema);
        }
        if (!Strings.isNullOrEmpty((String)config.getCallable())) {
            return JavaRowUdf.createFuctionFromCallable(config.getCallable());
        }
        if (!Strings.isNullOrEmpty((String)config.getName())) {
            return JavaRowUdf.createFunctionFromName(config.getName(), config.getPath());
        }
        throw new UnsupportedOperationException(config.toString());
    }

    private static @UnknownKeyFor @NonNull @Initialized FunctionAndType createFunctionFromExpression(@UnknownKeyFor @NonNull @Initialized String expression, @UnknownKeyFor @NonNull @Initialized Schema inputSchema) throws @UnknownKeyFor @NonNull @Initialized StringCompiler.CompileException, @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException {
        if (inputSchema.hasField(expression)) {
            int ix = inputSchema.indexOf(expression);
            return new FunctionAndType(inputSchema.getField(expression).getType(), row -> row.getValue(ix));
        }
        HashMap<String, Type> fieldTypes = new HashMap<String, Type>();
        for (Schema.Field field : inputSchema.getFields()) {
            if (expression.indexOf(field.getName()) == -1) continue;
            fieldTypes.put(field.getName(), JavaRowUdf.typeFromFieldType(field.getType()));
        }
        Type type = StringCompiler.guessExpressionType(expression, fieldTypes);
        StringBuilder source = new StringBuilder();
        source.append("import java.util.function.Function;\n");
        source.append("import " + Row.class.getTypeName() + ";\n");
        source.append("public class Eval implements Function<Row, Object> {\n");
        source.append("  public Object apply(Row __row__) {\n");
        for (Map.Entry fieldEntry : fieldTypes.entrySet()) {
            source.append(String.format("    %s %s = (%s) __row__.getValue(%s);%n", ((Type)fieldEntry.getValue()).getTypeName(), fieldEntry.getKey(), ((Type)fieldEntry.getValue()).getTypeName(), inputSchema.indexOf((String)fieldEntry.getKey())));
        }
        source.append("    return " + expression + ";\n");
        source.append("  }\n");
        source.append("}\n");
        return new FunctionAndType(type, (Function<Row, Object>)((Function)StringCompiler.getInstance("Eval", source.toString())));
    }

    private static @UnknownKeyFor @NonNull @Initialized FunctionAndType createFuctionFromCallable(@UnknownKeyFor @NonNull @Initialized String callable) throws @UnknownKeyFor @NonNull @Initialized StringCompiler.CompileException, @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException {
        Matcher matcher = Pattern.compile("\\bpublic\\s+class\\s+(\\S+)", 8).matcher(callable);
        Preconditions.checkArgument((boolean)matcher.find(), (Object)"No public class defined in callable source.");
        return new FunctionAndType((Function)StringCompiler.getInstance(matcher.group(1), callable.toString()));
    }

    private static @UnknownKeyFor @NonNull @Initialized FunctionAndType createFunctionFromName(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized ReflectiveOperationException, @UnknownKeyFor @NonNull @Initialized MalformedURLException {
        String className;
        if (path != null && !new File(path).exists()) {
            try (ReadableByteChannel inChannel = FileSystems.open(FileSystems.matchNewResource(path, false));){
                File tmpJar = File.createTempFile("map-to-fields-" + name, ".jar");
                try (FileChannel outChannel = FileChannel.open(tmpJar.toPath(), StandardOpenOption.WRITE);){
                    ByteStreams.copy((ReadableByteChannel)inChannel, (WritableByteChannel)outChannel);
                }
                path = tmpJar.getPath();
            }
            catch (IOException exn) {
                throw new RuntimeException(exn);
            }
        }
        ClassLoader classLoader = path == null ? ClassLoader.getSystemClassLoader() : new URLClassLoader(new URL[]{new URL("file://" + path)}, ClassLoader.getSystemClassLoader());
        String methodName = null;
        if (name.indexOf("::") == -1) {
            className = name;
            methodName = null;
        } else {
            String[] parts = name.split("::", 2);
            className = parts[0];
            methodName = parts[1];
        }
        if (methodName == null) {
            return new FunctionAndType((Function)classLoader.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        Class<?> clazz = classLoader.loadClass(className);
        Method method = clazz.getMethod(methodName, Row.class);
        Object base = Modifier.isStatic(method.getModifiers()) ? null : clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return new FunctionAndType(method.getGenericReturnType(), row -> {
            try {
                return method.invoke(base, row);
            }
            catch (IllegalAccessException | InvocationTargetException exn) {
                throw new RuntimeException(exn);
            }
        });
    }

    private static @UnknownKeyFor @NonNull @Initialized Type typeFromFieldType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        Map<Schema.TypeName, Type> primitivesMap;
        Map<Schema.TypeName, Type> map = primitivesMap = fieldType.getNullable() != false ? NULLABLE_PRIMITIVES : NON_NULLABLE_PRIMITIVES;
        if (primitivesMap.containsKey((Object)fieldType.getTypeName())) {
            return primitivesMap.get((Object)fieldType.getTypeName());
        }
        if (fieldType.getRowSchema() != null) {
            return Row.class;
        }
        throw new UnsupportedOperationException(fieldType.toString());
    }

    private static class EmptyFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private EmptyFieldValueTypeSupplier() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
            return Collections.emptyList();
        }
    }

    private static class FunctionAndType {
        public final @UnknownKeyFor @NonNull @Initialized Schema.FieldType outputType;
        public final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> function;

        public FunctionAndType(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> function) {
            this(FunctionAndType.outputOf(function), function);
        }

        public FunctionAndType(@UnknownKeyFor @NonNull @Initialized Type outputType, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> function) {
            this(TypeDescriptor.of(outputType), function);
        }

        public FunctionAndType(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputType, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> function) {
            this(StaticSchemaInference.fieldFromType(outputType, new EmptyFieldValueTypeSupplier()), function);
        }

        public FunctionAndType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType outputType, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Object> function) {
            this.outputType = outputType;
            this.function = function;
        }

        public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputOf(@UnknownKeyFor @NonNull @Initialized Function<InputT, OutputT> fn) {
            return TypeDescriptors.extractFromTypeParameters(fn, Function.class, new TypeDescriptors.TypeVariableExtractor<Function<InputT, OutputT>, OutputT>(){});
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration
    implements Serializable {
        @SchemaFieldDescription(value="Source code of a java expression in terms of the schema fields.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getExpression();

        @SchemaFieldDescription(value="Source code of a public class implementing Function<Row, T> for some schema-compatible T.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getCallable();

        @SchemaFieldDescription(value="Path to a jar file implementing the function referenced in name.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getPath();

        @SchemaFieldDescription(value="Fully qualified name of either a class implementing Function<Row, T> (e.g. com.pkg.MyFunction), or a method taking a single Row argument (e.g. com.pkg.MyClass::methodName). If a method is passed, it must either be static or belong to a class with a public nullary constructor.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getName();

        public void validate() {
            Preconditions.checkArgument((Strings.isNullOrEmpty((String)this.getPath()) || !Strings.isNullOrEmpty((String)this.getName()) ? 1 : 0) != 0, (Object)"Specifying a path only allows if a name is provided.");
            int totalArgs = (Strings.isNullOrEmpty((String)this.getExpression()) ? 0 : 1) + (Strings.isNullOrEmpty((String)this.getCallable()) ? 0 : 1) + (Strings.isNullOrEmpty((String)this.getName()) ? 0 : 1);
            Preconditions.checkArgument((totalArgs == 1 ? 1 : 0) != 0, (Object)"Exactly one of expression, callable, or name must be provided.");
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JavaRowUdf_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setExpression(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCallable(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

