/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DelegateCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Combine {
    private Combine() {
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized Globally<V, V> globally(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner) {
        return Combine.globally(IterableCombineFn.of(combiner), Combine.displayDataForFn(combiner));
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized Globally<V, V> globally(@UnknownKeyFor @NonNull @Initialized SerializableBiFunction<V, V, V> combiner) {
        return Combine.globally(BinaryCombineFn.of(combiner), Combine.displayDataForFn(combiner));
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Globally<InputT, OutputT> globally(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn) {
        return Combine.globally(fn, Combine.displayDataForFn(fn));
    }

    private static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> displayDataForFn(T fn) {
        return DisplayData.item("combineFn", fn.getClass()).withLabel("Combiner");
    }

    private static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Globally<InputT, OutputT> globally(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
        return new Globally(fn, fnDisplayData, true, 0, (List)ImmutableList.of());
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKey<K, V, V> perKey(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> fn) {
        return Combine.perKey(IterableCombineFn.of(fn), Combine.displayDataForFn(fn));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKey<K, V, V> perKey(@UnknownKeyFor @NonNull @Initialized SerializableBiFunction<V, V, V> fn) {
        return Combine.perKey(BinaryCombineFn.of(fn), Combine.displayDataForFn(fn));
    }

    public static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PerKey<K, InputT, OutputT> perKey(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn) {
        return Combine.perKey(fn, Combine.displayDataForFn(fn));
    }

    private static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PerKey<K, InputT, OutputT> perKey(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
        return new PerKey((CombineFnBase.GlobalCombineFn)fn, (DisplayData.ItemSpec)fnDisplayData, false);
    }

    @Internal
    public static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PerKey<K, InputT, OutputT> fewKeys(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn) {
        return new PerKey((CombineFnBase.GlobalCombineFn)fn, Combine.displayDataForFn(fn), true);
    }

    private static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PerKey<K, InputT, OutputT> fewKeys(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
        return new PerKey((CombineFnBase.GlobalCombineFn)fn, (DisplayData.ItemSpec)fnDisplayData, true);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized GroupedValues<K, V, V> groupedValues(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> fn) {
        return Combine.groupedValues(IterableCombineFn.of(fn), Combine.displayDataForFn(fn));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized GroupedValues<K, V, V> groupedValues(@UnknownKeyFor @NonNull @Initialized SerializableBiFunction<V, V, V> fn) {
        return Combine.groupedValues(BinaryCombineFn.of(fn), Combine.displayDataForFn(fn));
    }

    public static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized GroupedValues<K, InputT, OutputT> groupedValues(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn) {
        return Combine.groupedValues(fn, Combine.displayDataForFn(fn));
    }

    private static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized GroupedValues<K, InputT, OutputT> groupedValues(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
        return new GroupedValues((CombineFnBase.GlobalCombineFn)fn, (DisplayData.ItemSpec)fnDisplayData);
    }

    private static void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, @UnknownKeyFor @NonNull @Initialized HasDisplayData fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayItem) {
        builder.include("combineFn", fn).add(fnDisplayItem);
    }

    private static void populateGlobalDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, @UnknownKeyFor @NonNull @Initialized int fanout, @UnknownKeyFor @NonNull @Initialized boolean insertDefault) {
        builder.addIfNotDefault(DisplayData.item("fanout", fanout).withLabel("Key Fanout Size"), 0).add(DisplayData.item("emitDefaultOnEmptyInput", insertDefault).withLabel("Emit Default On Empty Input"));
    }

    public static class GroupedValues<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<? extends KV<K, ? extends Iterable<InputT>>>, PCollection<KV<K, OutputT>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;

        private GroupedValues(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
            this.fn = SerializableUtils.clone(fn);
            this.fnDisplayData = fnDisplayData;
            this.sideInputs = ImmutableList.of();
        }

        private GroupedValues(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            this.fn = SerializableUtils.clone(fn);
            this.fnDisplayData = fnDisplayData;
            this.sideInputs = sideInputs;
        }

        public @UnknownKeyFor @NonNull @Initialized GroupedValues<K, InputT, OutputT> withSideInputs(PCollectionView<?> ... sideInputs) {
            return this.withSideInputs(Arrays.asList(sideInputs));
        }

        public @UnknownKeyFor @NonNull @Initialized GroupedValues<K, InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            return new GroupedValues<K, InputT, OutputT>(this.fn, (DisplayData.ItemSpec<Class<?>>)this.fnDisplayData, (List<PCollectionView<?>>)ImmutableList.copyOf(sideInputs));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> getFn() {
            return this.fn;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> input) {
            PCollection output = (PCollection)input.apply(ParDo.of(new DoFn<KV<K, ? extends Iterable<InputT>>, KV<K, OutputT>>(){

                @DoFn.ProcessElement
                public void processElement(final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    Object output;
                    Object key = ((KV)c.element()).getKey();
                    if (fn instanceof CombineWithContext.CombineFnWithContext) {
                        output = ((CombineWithContext.CombineFnWithContext)fn).apply((Iterable)((KV)c.element()).getValue(), new CombineWithContext.Context(){

                            @Override
                            public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
                                return c.getPipelineOptions();
                            }

                            @Override
                            public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                                return c.sideInput(view);
                            }
                        });
                    } else if (fn instanceof CombineFn) {
                        output = ((CombineFn)fn).apply((Iterable)((KV)c.element()).getValue());
                    } else {
                        throw new IllegalStateException(String.format("Unknown type of CombineFn: %s", fn.getClass()));
                    }
                    c.output(KV.of(key, output));
                }

                @Override
                public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                    builder.delegate(this);
                }
            }).withSideInputs(this.sideInputs));
            try {
                KvCoder<K, InputT> kvCoder = this.getKvCoder(input.getCoder());
                Coder<OutputT> outputValueCoder = this.fn.getDefaultOutputCoder(input.getPipeline().getCoderRegistry(), kvCoder.getValueCoder());
                output.setCoder(KvCoder.of(kvCoder.getKeyCoder(), outputValueCoder));
            }
            catch (CannotProvideCoderException cannotProvideCoderException) {
                // empty catch block
            }
            return output;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<@UnknownKeyFor @Nullable @Initialized ? super K, @UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> getAppliedFn(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> inputCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
            KvCoder<K, InputT> kvCoder = this.getKvCoder(inputCoder);
            return AppliedCombineFn.withInputCoder(this.fn, registry, kvCoder, this.sideInputs, windowingStrategy);
        }

        private @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> getKvCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> inputCoder) {
            if (!(inputCoder instanceof KvCoder)) {
                throw new IllegalStateException("Combine.GroupedValues requires its input to use KvCoder");
            }
            KvCoder kvCoder = (KvCoder)inputCoder;
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder kvValueCoder = kvCoder.getValueCoder();
            if (!(kvValueCoder instanceof IterableCoder)) {
                throw new IllegalStateException("Combine.GroupedValues requires its input values to use IterableCoder");
            }
            IterableCoder inputValuesCoder = (IterableCoder)kvValueCoder;
            Coder inputValueCoder = inputValuesCoder.getElemCoder();
            return KvCoder.of(keyCoder, inputValueCoder);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Combine.populateDisplayData(builder, this.fn, this.fnDisplayData);
        }
    }

    public static class PerKeyWithHotKeyFanout<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized ? super K, @UnknownKeyFor @NonNull @Initialized Integer> hotKeyFanout;
        private final @UnknownKeyFor @NonNull @Initialized boolean fewKeys;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;

        private PerKeyWithHotKeyFanout(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized ? super K, @UnknownKeyFor @NonNull @Initialized Integer> hotKeyFanout, @UnknownKeyFor @NonNull @Initialized boolean fewKeys, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
            this.hotKeyFanout = hotKeyFanout;
            this.fewKeys = fewKeys;
            this.sideInputs = sideInputs;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Combine.perKeyWithFanout(%s)", NameUtils.approximateSimpleName(this.fn));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
            return this.applyHelper(input);
        }

        private <AccumT> @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> applyHelper(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
            PerKey postCombineTransform;
            PerKey hotPreCombineTransform;
            CombineFnBase.AbstractGlobalCombineFn postCombine;
            CombineFnBase.AbstractGlobalCombineFn hotPreCombine;
            Coder<?> accumCoder;
            CombineFnBase.GlobalCombineFn typedFn = this.fn;
            if (!(input.getCoder() instanceof KvCoder)) {
                throw new IllegalStateException("Expected input coder to be KvCoder, but was " + input.getCoder());
            }
            final KvCoder inputCoder = (KvCoder)input.getCoder();
            try {
                accumCoder = typedFn.getAccumulatorCoder(input.getPipeline().getCoderRegistry(), inputCoder.getValueCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalStateException("Unable to determine accumulator coder.", e);
            }
            InputOrAccum.InputOrAccumCoder inputOrAccumCoder = new InputOrAccum.InputOrAccumCoder(inputCoder.getValueCoder(), accumCoder);
            if (typedFn instanceof CombineFn) {
                final CombineFn fn = (CombineFn)typedFn;
                hotPreCombine = new CombineFn<InputT, AccumT, AccumT>(){

                    @Override
                    public AccumT createAccumulator() {
                        return fn.createAccumulator();
                    }

                    @Override
                    public AccumT addInput(AccumT accumulator, InputT value) {
                        return fn.addInput(accumulator, value);
                    }

                    @Override
                    public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
                        return fn.mergeAccumulators(accumulators);
                    }

                    @Override
                    public AccumT compact(AccumT accumulator) {
                        return fn.compact(accumulator);
                    }

                    @Override
                    public AccumT extractOutput(AccumT accumulator) {
                        return accumulator;
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                        return accumCoder;
                    }

                    @Override
                    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                        builder.delegate(this);
                    }
                };
                postCombine = new CombineFn<InputOrAccum<InputT, AccumT>, AccumT, OutputT>(){

                    @Override
                    public AccumT createAccumulator() {
                        return fn.createAccumulator();
                    }

                    @Override
                    public AccumT addInput(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> value) {
                        if (value.accum == null) {
                            return fn.addInput(accumulator, value.input);
                        }
                        return fn.mergeAccumulators(ImmutableList.of(accumulator, value.accum));
                    }

                    @Override
                    public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
                        return fn.mergeAccumulators(accumulators);
                    }

                    @Override
                    public AccumT compact(AccumT accumulator) {
                        return fn.compact(accumulator);
                    }

                    @Override
                    public OutputT extractOutput(AccumT accumulator) {
                        return fn.extractOutput(accumulator);
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT>> accumulatorCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                        return fn.getDefaultOutputCoder(registry, inputCoder.getValueCoder());
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT>> inputCoder2) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                        return accumCoder;
                    }

                    @Override
                    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                        builder.delegate(this);
                    }
                };
            } else if (typedFn instanceof CombineWithContext.CombineFnWithContext) {
                final CombineWithContext.CombineFnWithContext fnWithContext = (CombineWithContext.CombineFnWithContext)typedFn;
                hotPreCombine = new CombineWithContext.CombineFnWithContext<InputT, AccumT, AccumT>(){

                    @Override
                    public AccumT createAccumulator(@UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.createAccumulator(c);
                    }

                    @Override
                    public AccumT addInput(AccumT accumulator, InputT value, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.addInput(accumulator, value, c);
                    }

                    @Override
                    public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.mergeAccumulators(accumulators, c);
                    }

                    @Override
                    public AccumT compact(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.compact(accumulator, c);
                    }

                    @Override
                    public AccumT extractOutput(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return accumulator;
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                        return accumCoder;
                    }

                    @Override
                    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                        builder.delegate(this);
                    }
                };
                postCombine = new CombineWithContext.CombineFnWithContext<InputOrAccum<InputT, AccumT>, AccumT, OutputT>(){

                    @Override
                    public AccumT createAccumulator(@UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.createAccumulator(c);
                    }

                    @Override
                    public AccumT addInput(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> value, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        if (value.accum == null) {
                            return fnWithContext.addInput(accumulator, value.input, c);
                        }
                        return fnWithContext.mergeAccumulators(ImmutableList.of(accumulator, value.accum), c);
                    }

                    @Override
                    public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.mergeAccumulators(accumulators, c);
                    }

                    @Override
                    public AccumT compact(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.compact(accumulator, c);
                    }

                    @Override
                    public OutputT extractOutput(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                        return fnWithContext.extractOutput(accumulator, c);
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT>> accumulatorCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                        return fnWithContext.getDefaultOutputCoder(registry, inputCoder.getValueCoder());
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT>> inputCoder2) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                        return accumCoder;
                    }

                    @Override
                    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                        builder.delegate(this);
                    }
                };
            } else {
                throw new IllegalStateException(String.format("Unknown type of CombineFn: %s", typedFn.getClass()));
            }
            final TupleTag hot = new TupleTag();
            final TupleTag cold = new TupleTag();
            PCollectionTuple split = (PCollectionTuple)input.apply("AddNonce", ParDo.of(new DoFn<KV<K, InputT>, KV<K, InputT>>(){
                transient @UnknownKeyFor @NonNull @Initialized int nonce;

                @DoFn.StartBundle
                public void startBundle() {
                    this.nonce = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, InputT> kv, @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
                    int spread = (Integer)hotKeyFanout.apply(kv.getKey());
                    if (spread <= 1) {
                        receiver.get(cold).output(kv);
                    } else {
                        receiver.get(hot).output(KV.of(KV.of(kv.getKey(), this.nonce % spread), kv.getValue()));
                    }
                }
            }).withOutputTags(cold, TupleTagList.of(hot)));
            WindowingStrategy<?, ?> preCombineStrategy = input.getWindowingStrategy();
            if (preCombineStrategy.getMode() == WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES) {
                preCombineStrategy = preCombineStrategy.withMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES);
            }
            PerKey perKey = hotPreCombineTransform = this.fewKeys ? Combine.fewKeys(hotPreCombine, this.fnDisplayData) : Combine.perKey(hotPreCombine, this.fnDisplayData);
            if (!this.sideInputs.isEmpty()) {
                hotPreCombineTransform = hotPreCombineTransform.withSideInputs(this.sideInputs);
            }
            PCollection precombinedHot = ((PCollection)((PCollection)((PCollection)split.get(hot).setCoder(KvCoder.of(KvCoder.of(inputCoder.getKeyCoder(), VarIntCoder.of()), inputCoder.getValueCoder())).setWindowingStrategyInternal(preCombineStrategy).apply("PreCombineHot", hotPreCombineTransform)).apply("StripNonce", MapElements.via(new SimpleFunction<KV<KV<K, Integer>, AccumT>, KV<K, InputOrAccum<InputT, AccumT>>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT>> apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Integer>, AccumT> elem) {
                    return KV.of(elem.getKey().getKey(), InputOrAccum.accum(elem.getValue()));
                }
            }))).setCoder(KvCoder.of(inputCoder.getKeyCoder(), inputOrAccumCoder)).apply(Window.remerge())).setWindowingStrategyInternal(input.getWindowingStrategy());
            PCollection preprocessedCold = ((PCollection)split.get(cold).setCoder(inputCoder).apply("PrepareCold", MapElements.via(new SimpleFunction<KV<K, InputT>, KV<K, InputOrAccum<InputT, AccumT>>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT>> apply(@UnknownKeyFor @NonNull @Initialized KV<K, InputT> element) {
                    return KV.of(element.getKey(), InputOrAccum.input(element.getValue()));
                }
            }))).setCoder(KvCoder.of(inputCoder.getKeyCoder(), inputOrAccumCoder));
            PerKey perKey2 = postCombineTransform = this.fewKeys ? Combine.fewKeys(postCombine, this.fnDisplayData) : Combine.perKey(postCombine, this.fnDisplayData);
            if (!this.sideInputs.isEmpty()) {
                postCombineTransform = postCombineTransform.withSideInputs(this.sideInputs);
            }
            return (PCollection)((PCollection)PCollectionList.of(precombinedHot).and(preprocessedCold).apply(Flatten.pCollections())).apply("PostCombine", postCombineTransform);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Combine.populateDisplayData(builder, this.fn, this.fnDisplayData);
            if (this.hotKeyFanout instanceof HasDisplayData) {
                builder.include("hotKeyFanout", (HasDisplayData)((Object)this.hotKeyFanout));
            }
            builder.add(DisplayData.item("fanoutFn", this.hotKeyFanout.getClass()).withLabel("Fanout Function"));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        private static class InputOrAccum<@UnknownKeyFor InputT, @UnknownKeyFor AccumT> {
            public final @Nullable InputT input;
            public final @Nullable AccumT accum;

            private InputOrAccum(@Nullable InputT input, @Nullable AccumT aggr) {
                this.input = input;
                this.accum = aggr;
            }

            public static <InputT, AccumT> @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> input(InputT input) {
                return new InputOrAccum<InputT, Object>(input, null);
            }

            public static <InputT, AccumT> @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> accum(AccumT aggr) {
                return new InputOrAccum<Object, AccumT>(null, aggr);
            }

            private static class InputOrAccumCoder<@UnknownKeyFor InputT, @UnknownKeyFor AccumT>
            extends StructuredCoder<InputOrAccum<InputT, AccumT>> {
                private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
                private final @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder;

                public InputOrAccumCoder(@UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder) {
                    this.inputCoder = inputCoder;
                    this.accumCoder = accumCoder;
                }

                @Override
                public void encode(@UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                    this.encode(value, outStream, Coder.Context.NESTED);
                }

                @Override
                public void encode(@UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                    if (value.input != null) {
                        outStream.write(0);
                        this.inputCoder.encode(value.input, outStream, context);
                    } else {
                        outStream.write(1);
                        this.accumCoder.encode(value.accum, outStream, context);
                    }
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                    return this.decode(inStream, Coder.Context.NESTED);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized InputOrAccum<InputT, AccumT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                    if (inStream.read() == 0) {
                        return InputOrAccum.input(this.inputCoder.decode(inStream, context));
                    }
                    return InputOrAccum.accum(this.accumCoder.decode(inStream, context));
                }

                @Override
                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
                    return ImmutableList.of(this.inputCoder, this.accumCoder);
                }

                @Override
                public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
                    this.inputCoder.verifyDeterministic();
                    this.accumCoder.verifyDeterministic();
                }
            }
        }
    }

    public static class PerKey<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;
        private final @UnknownKeyFor @NonNull @Initialized boolean fewKeys;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;

        private PerKey(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData, @UnknownKeyFor @NonNull @Initialized boolean fewKeys) {
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
            this.fewKeys = fewKeys;
            this.sideInputs = ImmutableList.of();
        }

        private PerKey(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData, @UnknownKeyFor @NonNull @Initialized boolean fewKeys, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
            this.fewKeys = fewKeys;
            this.sideInputs = sideInputs;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Combine.perKey(%s)", NameUtils.approximateSimpleName(this.fn));
        }

        public @UnknownKeyFor @NonNull @Initialized PerKey<K, InputT, OutputT> withSideInputs(PCollectionView<?> ... sideInputs) {
            return this.withSideInputs(Arrays.asList(sideInputs));
        }

        public @UnknownKeyFor @NonNull @Initialized PerKey<K, InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            Preconditions.checkState((boolean)(this.fn instanceof CombineWithContext.RequiresContextInternal));
            return new PerKey<K, InputT, OutputT>(this.fn, (DisplayData.ItemSpec<Class<?>>)this.fnDisplayData, this.fewKeys, (List<PCollectionView<?>>)ImmutableList.copyOf(sideInputs));
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeyWithHotKeyFanout<K, InputT, OutputT> withHotKeyFanout(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized ? super K, @UnknownKeyFor @NonNull @Initialized Integer> hotKeyFanout) {
            return new PerKeyWithHotKeyFanout(this.fn, this.fnDisplayData, hotKeyFanout, this.fewKeys, this.sideInputs);
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeyWithHotKeyFanout<K, InputT, OutputT> withHotKeyFanout(final @UnknownKeyFor @NonNull @Initialized int hotKeyFanout) {
            return new PerKeyWithHotKeyFanout(this.fn, this.fnDisplayData, new SimpleFunction<K, Integer>(){

                @Override
                public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                    super.populateDisplayData(builder);
                    builder.add(DisplayData.item("fanout", hotKeyFanout).withLabel("Key Fanout Size"));
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Integer apply(K unused) {
                    return hotKeyFanout;
                }
            }, this.fewKeys, this.sideInputs);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> getFn() {
            return this.fn;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
            return (PCollection)((PCollection)input.apply(this.fewKeys ? GroupByKey.createWithFewKeys() : GroupByKey.create())).apply(Combine.groupedValues(this.fn, this.fnDisplayData).withSideInputs(this.sideInputs));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Combine.populateDisplayData(builder, this.fn, this.fnDisplayData);
        }
    }

    @Deprecated
    public static class SimpleCombineFn<@UnknownKeyFor V>
    extends IterableCombineFn<V> {
        public static <V> @UnknownKeyFor @NonNull @Initialized SimpleCombineFn<V> of(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner) {
            return new SimpleCombineFn<V>(combiner);
        }

        protected SimpleCombineFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner) {
            super(combiner, 20);
        }
    }

    public static class IterableCombineFn<@UnknownKeyFor V>
    extends CombineFn<V, List<V>, V>
    implements NameUtils.NameOverride {
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 20;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner;
        private final @UnknownKeyFor @NonNull @Initialized int bufferSize;

        public static <V> @UnknownKeyFor @NonNull @Initialized IterableCombineFn<V> of(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner) {
            return IterableCombineFn.of(combiner, 20);
        }

        public static <V> @UnknownKeyFor @NonNull @Initialized IterableCombineFn<V> of(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
            return new IterableCombineFn<V>(combiner, bufferSize);
        }

        private IterableCombineFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<V>, V> combiner, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
            this.combiner = combiner;
            this.bufferSize = bufferSize;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<V> createAccumulator() {
            return new ArrayList();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<V> addInput(@UnknownKeyFor @NonNull @Initialized List<V> accumulator, V input) {
            accumulator.add(input);
            if (accumulator.size() > this.bufferSize) {
                return this.mergeToSingleton(accumulator);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<V> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized List<V>> accumulators) {
            return this.mergeToSingleton(Iterables.concat(accumulators));
        }

        @Override
        public V extractOutput(@UnknownKeyFor @NonNull @Initialized List<V> accumulator) {
            return this.combiner.apply(accumulator);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<V> compact(@UnknownKeyFor @NonNull @Initialized List<V> accumulator) {
            return accumulator.size() > 1 ? this.mergeToSingleton(accumulator) : accumulator;
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("combineFn", this.combiner.getClass()).withLabel("Combiner"));
        }

        private @UnknownKeyFor @NonNull @Initialized List<V> mergeToSingleton(@UnknownKeyFor @NonNull @Initialized Iterable<V> values) {
            ArrayList<V> singleton = new ArrayList<V>();
            singleton.add(this.combiner.apply(values));
            return singleton;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getNameOverride() {
            return NameUtils.approximateSimpleName(this.combiner);
        }
    }

    public static class GloballyAsSingletonView<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<InputT>, PCollectionView<OutputT>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;
        private final @UnknownKeyFor @NonNull @Initialized boolean insertDefault;
        private final @UnknownKeyFor @NonNull @Initialized int fanout;

        private GloballyAsSingletonView(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData, @UnknownKeyFor @NonNull @Initialized boolean insertDefault, @UnknownKeyFor @NonNull @Initialized int fanout) {
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
            this.insertDefault = insertDefault;
            this.fanout = fanout;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            PCollection combined = (PCollection)input.apply("CombineValues", Combine.globally(this.fn).withoutDefaults().withFanout(this.fanout));
            Coder outputCoder = combined.getCoder();
            PCollectionView<Object> view = PCollectionViews.singletonView(combined, () -> outputCoder != null ? outputCoder.getEncodedTypeDescriptor() : null, input.getWindowingStrategy(), this.insertDefault, this.insertDefault ? (Object)this.fn.defaultValue() : null, combined.getCoder());
            combined.apply("CreatePCollectionView", View.CreatePCollectionView.of(view));
            return view;
        }

        public @UnknownKeyFor @NonNull @Initialized int getFanout() {
            return this.fanout;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean getInsertDefault() {
            return this.insertDefault;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> getCombineFn() {
            return this.fn;
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Combine.populateDisplayData(builder, this.fn, this.fnDisplayData);
            Combine.populateGlobalDisplayData(builder, this.fanout, this.insertDefault);
        }
    }

    public static class Globally<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;
        private final @UnknownKeyFor @NonNull @Initialized boolean insertDefault;
        private final @UnknownKeyFor @NonNull @Initialized int fanout;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;

        private Globally(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData, @UnknownKeyFor @NonNull @Initialized boolean insertDefault, @UnknownKeyFor @NonNull @Initialized int fanout, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
            this.insertDefault = insertDefault;
            this.fanout = fanout;
            this.sideInputs = sideInputs;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Combine.globally(%s)", NameUtils.approximateSimpleName(this.fn));
        }

        public @UnknownKeyFor @NonNull @Initialized GloballyAsSingletonView<InputT, OutputT> asSingletonView() {
            return new GloballyAsSingletonView(this.fn, this.fnDisplayData, this.insertDefault, this.fanout);
        }

        public @UnknownKeyFor @NonNull @Initialized Globally<InputT, OutputT> withoutDefaults() {
            return new Globally<InputT, OutputT>(this.fn, this.fnDisplayData, false, this.fanout, this.sideInputs);
        }

        public @UnknownKeyFor @NonNull @Initialized Globally<InputT, OutputT> withFanout(@UnknownKeyFor @NonNull @Initialized int fanout) {
            return new Globally<InputT, OutputT>(this.fn, this.fnDisplayData, this.insertDefault, fanout, this.sideInputs);
        }

        public @UnknownKeyFor @NonNull @Initialized Globally<InputT, OutputT> withSideInputs(PCollectionView<?> ... sideInputs) {
            return this.withSideInputs(Arrays.asList(sideInputs));
        }

        public @UnknownKeyFor @NonNull @Initialized Globally<InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            Preconditions.checkState((boolean)(this.fn instanceof CombineWithContext.RequiresContextInternal));
            return new Globally<InputT, OutputT>(this.fn, (DisplayData.ItemSpec<Class<?>>)this.fnDisplayData, this.insertDefault, this.fanout, (List<PCollectionView<?>>)ImmutableList.copyOf(sideInputs));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> getFn() {
            return this.fn;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isInsertDefault() {
            return this.insertDefault;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            PCollection withKeys = ((PCollection)input.apply(WithKeys.of((Void)null))).setCoder(KvCoder.of(VoidCoder.of(), input.getCoder()));
            PerKey combine = Combine.fewKeys(this.fn, this.fnDisplayData);
            if (!this.sideInputs.isEmpty()) {
                combine = combine.withSideInputs(this.sideInputs);
            }
            PCollection combined = this.fanout >= 2 ? (PCollection)withKeys.apply(combine.withHotKeyFanout(this.fanout)) : (PCollection)withKeys.apply(combine);
            PCollection output = (PCollection)combined.apply(Values.create());
            if (this.insertDefault) {
                if (!output.getWindowingStrategy().getWindowFn().isCompatible(new GlobalWindows())) {
                    throw new IllegalStateException(this.fn.getIncompatibleGlobalWindowErrorMessage());
                }
                return this.insertDefaultValueIfEmpty(output);
            }
            return output;
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Combine.populateDisplayData(builder, this.fn, this.fnDisplayData);
            Combine.populateGlobalDisplayData(builder, this.fanout, this.insertDefault);
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> insertDefaultValueIfEmpty(@UnknownKeyFor @NonNull @Initialized PCollection<OutputT> maybeEmpty) {
            final PCollectionView maybeEmptyView = (PCollectionView)maybeEmpty.apply(View.asIterable());
            final OutputT defaultValue = this.fn.defaultValue();
            PCollection<OutputT> defaultIfEmpty = ((PCollection)((PCollection)maybeEmpty.getPipeline().apply("CreateVoid", Create.of(null, new Void[0]).withCoder(VoidCoder.of()))).apply("ProduceDefault", ParDo.of(new DoFn<Void, OutputT>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    Iterator combined = ((Iterable)c.sideInput(maybeEmptyView)).iterator();
                    if (!combined.hasNext()) {
                        c.output(defaultValue);
                    }
                }
            }).withSideInputs(maybeEmptyView))).setCoder(maybeEmpty.getCoder()).setWindowingStrategyInternal(maybeEmpty.getWindowingStrategy());
            return (PCollection)PCollectionList.of(maybeEmpty).and(defaultIfEmpty).apply(Flatten.pCollections());
        }
    }

    public static abstract class AccumulatingCombineFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT extends @UnknownKeyFor @NonNull @Initialized Accumulator<InputT, AccumT, OutputT>, @UnknownKeyFor OutputT>
    extends CombineFn<InputT, AccumT, OutputT> {
        @Override
        public final AccumT addInput(AccumT accumulator, InputT input) {
            accumulator.addInput(input);
            return accumulator;
        }

        @Override
        public final AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            Accumulator accumulator = (Accumulator)this.createAccumulator();
            for (Accumulator partial : accumulators) {
                accumulator.mergeAccumulator(partial);
            }
            return (AccumT)accumulator;
        }

        @Override
        public final OutputT extractOutput(AccumT accumulator) {
            return accumulator.extractOutput();
        }

        public static interface Accumulator<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT> {
            public void addInput(InputT var1);

            public void mergeAccumulator(AccumT var1);

            public OutputT extractOutput();
        }
    }

    public static abstract class BinaryCombineDoubleFn
    extends CombineFn<Double, double[], Double> {
        public abstract @UnknownKeyFor @NonNull @Initialized double apply(@UnknownKeyFor @NonNull @Initialized double var1, @UnknownKeyFor @NonNull @Initialized double var3);

        public abstract @UnknownKeyFor @NonNull @Initialized double identity();

        @Override
        public @UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] createAccumulator() {
            return BinaryCombineDoubleFn.wrap(this.identity());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] accumulator, @UnknownKeyFor @NonNull @Initialized Double input) {
            accumulator[0] = this.apply(accumulator[0], input);
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized []> accumulators) {
            Iterator<double[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            double[] running = iter.next();
            while (iter.hasNext()) {
                running[0] = this.apply(running[0], iter.next()[0]);
            }
            return running;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Double extractOutput(@UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            return accumulator[0];
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Double> inputCoder) {
            return DelegateCoder.of(inputCoder, new ToDoubleCodingFunction(), new FromDoubleCodingFunction());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Double> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Double> inputCoder) {
            return inputCoder;
        }

        private static @UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] wrap(@UnknownKeyFor @NonNull @Initialized double value) {
            return new double[]{value};
        }

        private static final class FromDoubleCodingFunction
        implements DelegateCoder.CodingFunction<Double, double[]> {
            private FromDoubleCodingFunction() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Double value) {
                return BinaryCombineDoubleFn.wrap(value);
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                return o instanceof FromDoubleCodingFunction;
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getClass().hashCode();
            }
        }

        private static final class ToDoubleCodingFunction
        implements DelegateCoder.CodingFunction<double[], Double> {
            private ToDoubleCodingFunction() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Double apply(@UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] accumulator) {
                return accumulator[0];
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                return o instanceof ToDoubleCodingFunction;
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getClass().hashCode();
            }
        }
    }

    public static abstract class BinaryCombineLongFn
    extends CombineFn<Long, long[], Long> {
        public abstract @UnknownKeyFor @NonNull @Initialized long apply(@UnknownKeyFor @NonNull @Initialized long var1, @UnknownKeyFor @NonNull @Initialized long var3);

        public abstract @UnknownKeyFor @NonNull @Initialized long identity();

        @Override
        public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] createAccumulator() {
            return BinaryCombineLongFn.wrap(this.identity());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] accumulator, @UnknownKeyFor @NonNull @Initialized Long input) {
            accumulator[0] = this.apply(accumulator[0], input);
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized []> accumulators) {
            Iterator<long[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            long[] running = iter.next();
            while (iter.hasNext()) {
                running[0] = this.apply(running[0], iter.next()[0]);
            }
            return running;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            return accumulator[0];
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> inputCoder) {
            return DelegateCoder.of(inputCoder, new ToLongCodingFunction(), new FromLongCodingFunction());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> inputCoder) {
            return inputCoder;
        }

        private static @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] wrap(@UnknownKeyFor @NonNull @Initialized long value) {
            return new long[]{value};
        }

        private static final class FromLongCodingFunction
        implements DelegateCoder.CodingFunction<Long, long[]> {
            private FromLongCodingFunction() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Long value) {
                return BinaryCombineLongFn.wrap(value);
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                return o instanceof FromLongCodingFunction;
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getClass().hashCode();
            }
        }

        private static final class ToLongCodingFunction
        implements DelegateCoder.CodingFunction<long[], Long> {
            private ToLongCodingFunction() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Long apply(@UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] accumulator) {
                return accumulator[0];
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                return o instanceof ToLongCodingFunction;
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getClass().hashCode();
            }
        }
    }

    public static abstract class BinaryCombineIntegerFn
    extends CombineFn<Integer, int[], Integer> {
        public abstract @UnknownKeyFor @NonNull @Initialized int apply(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2);

        public abstract @UnknownKeyFor @NonNull @Initialized int identity();

        @Override
        public @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] createAccumulator() {
            return BinaryCombineIntegerFn.wrap(this.identity());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] addInput(@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] accumulator, @UnknownKeyFor @NonNull @Initialized Integer input) {
            accumulator[0] = this.apply(accumulator[0], input);
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized []> accumulators) {
            Iterator<int[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            int[] running = iter.next();
            while (iter.hasNext()) {
                running[0] = this.apply(running[0], iter.next()[0]);
            }
            return running;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Integer extractOutput(@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] accumulator) {
            return accumulator[0];
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized []> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> inputCoder) {
            return DelegateCoder.of(inputCoder, new ToIntegerCodingFunction(), new FromIntegerCodingFunction());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> inputCoder) {
            return inputCoder;
        }

        private static @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] wrap(@UnknownKeyFor @NonNull @Initialized int value) {
            return new int[]{value};
        }

        private static final class FromIntegerCodingFunction
        implements DelegateCoder.CodingFunction<Integer, int[]> {
            private FromIntegerCodingFunction() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Integer value) {
                return BinaryCombineIntegerFn.wrap(value);
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                return o instanceof FromIntegerCodingFunction;
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getClass().hashCode();
            }
        }

        private static final class ToIntegerCodingFunction
        implements DelegateCoder.CodingFunction<int[], Integer> {
            private ToIntegerCodingFunction() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Integer apply(@UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] accumulator) {
                return accumulator[0];
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                return o instanceof ToIntegerCodingFunction;
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getClass().hashCode();
            }
        }
    }

    private static class HolderCoder<@UnknownKeyFor V>
    extends StructuredCoder<Holder<V>> {
        private @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public HolderCoder(@UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized Holder<V> accumulator, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(accumulator, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized Holder<V> accumulator, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (((Holder)accumulator).present) {
                outStream.write(1);
                this.valueCoder.encode(((Holder)accumulator).value, outStream, context);
            } else {
                outStream.write(0);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Holder<V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Holder<V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (inStream.read() == 1) {
                return new Holder(this.valueCoder.decode(inStream, context));
            }
            return new Holder();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
        }
    }

    public static class Holder<@UnknownKeyFor V> {
        private @Nullable V value;
        private @UnknownKeyFor @NonNull @Initialized boolean present;

        private Holder() {
        }

        private Holder(V value) {
            this.set(value);
        }

        private void set(V value) {
            this.present = true;
            this.value = value;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "Combine.Holder(value=" + this.value + ", present=" + this.present + ")";
        }
    }

    public static abstract class BinaryCombineFn<@UnknownKeyFor V>
    extends CombineFn<V, Holder<V>, V> {
        public static <V> @UnknownKeyFor @NonNull @Initialized BinaryCombineFn<V> of(final @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<V, V, V> combiner) {
            return new BinaryCombineFn<V>(){

                @Override
                public V apply(V left, V right) {
                    return combiner.apply(left, right);
                }
            };
        }

        public abstract V apply(V var1, V var2);

        public @Nullable V identity() {
            return null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Holder<V> createAccumulator() {
            return new Holder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Holder<V> addInput(@UnknownKeyFor @NonNull @Initialized Holder<V> accumulator, V input) {
            if (((Holder)accumulator).present) {
                ((Holder)accumulator).set(this.apply(((Holder)accumulator).value, input));
            } else {
                ((Holder)accumulator).set(input);
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Holder<V> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Holder<V>> accumulators) {
            Iterator<Holder<V>> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            Holder<V> running = iter.next();
            while (iter.hasNext()) {
                Holder<V> accum = iter.next();
                if (!((Holder)accum).present) continue;
                if (((Holder)running).present) {
                    ((Holder)running).set(this.apply(((Holder)running).value, ((Holder)accum).value));
                    continue;
                }
                ((Holder)running).set(((Holder)accum).value);
            }
            return running;
        }

        @Override
        public V extractOutput(@UnknownKeyFor @NonNull @Initialized Holder<V> accumulator) {
            if (((Holder)accumulator).present) {
                return (V)((Holder)accumulator).value;
            }
            return this.identity();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Holder<V>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<V> inputCoder) {
            return new HolderCoder<V>(inputCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<V> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<V> inputCoder) {
            return inputCoder;
        }
    }

    public static abstract class CombineFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends CombineFnBase.AbstractGlobalCombineFn<InputT, AccumT, OutputT> {
        public abstract AccumT createAccumulator();

        public abstract AccumT addInput(AccumT var1, InputT var2);

        public abstract AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> var1);

        public abstract OutputT extractOutput(AccumT var1);

        public AccumT compact(AccumT accumulator) {
            return accumulator;
        }

        public OutputT apply(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends InputT> inputs) {
            AccumT accum = this.createAccumulator();
            for (InputT input : inputs) {
                accum = this.addInput(accum, input);
            }
            return this.extractOutput(accum);
        }

        @Override
        public OutputT defaultValue() {
            return this.extractOutput(this.createAccumulator());
        }

        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputType() {
            return new TypeDescriptor<OutputT>(this.getClass()){};
        }

        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> getInputType() {
            return new TypeDescriptor<InputT>(this.getClass()){};
        }
    }
}

