/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public abstract class PartitioningWindowFn<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends NonMergingWindowFn<T, W> {
    public abstract W assignWindow(@UnknownKeyFor @NonNull @Initialized Instant var1);

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Collection<W> assignWindows( @UnknownKeyFor @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) {
        return Arrays.asList(this.assignWindow(c.timestamp()));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<W> getDefaultWindowMappingFn() {
        return new WindowMappingFn<W>(){

            @Override
            public W getSideInputWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow mainWindow) {
                if (mainWindow instanceof GlobalWindow) {
                    throw new IllegalArgumentException("Attempted to get side input window for GlobalWindow from non-global WindowFn");
                }
                return PartitioningWindowFn.this.assignWindow(mainWindow.maxTimestamp());
            }
        };
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized boolean assignsToOneWindow() {
        return true;
    }
}

