/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_java_fn_execution.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DockerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DockerCommand.class);
    private static final String DEFAULT_DOCKER_COMMAND = "docker";
    private static final Pattern CONTAINER_ID_PATTERN = Pattern.compile("\\p{XDigit}{64}");
    private final String dockerExecutable;
    private final Duration commandTimeout;

    public static DockerCommand getDefault() {
        return DockerCommand.forExecutable(DEFAULT_DOCKER_COMMAND, Duration.ofMinutes(2L));
    }

    static DockerCommand forExecutable(String dockerExecutable, Duration commandTimeout) {
        return new DockerCommand(dockerExecutable, commandTimeout);
    }

    private DockerCommand(String dockerExecutable, Duration commandTimeout) {
        this.dockerExecutable = dockerExecutable;
        this.commandTimeout = commandTimeout;
    }

    public String runImage(String imageTag, List<String> dockerOpts, List<String> args) throws IOException, TimeoutException, InterruptedException {
        Preconditions.checkArgument(!imageTag.isEmpty(), "Docker image tag required");
        try {
            this.runShortCommand((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.dockerExecutable)).add("pull")).add(imageTag)).build()));
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to pull docker image {}", (Object)imageTag, (Object)e);
            }
            LOG.warn("Unable to pull docker image {}, cause: {}", (Object)imageTag, (Object)e.getMessage());
        }
        return this.runShortCommand((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.dockerExecutable)).add("run")).add("-d")).addAll(dockerOpts)).add(imageTag)).addAll(args)).build()));
    }

    public void killContainer(String containerId) throws IOException, TimeoutException, InterruptedException {
        Preconditions.checkArgument(containerId != null);
        Preconditions.checkArgument(CONTAINER_ID_PATTERN.matcher(containerId).matches(), "Container ID must be a 64-character hexadecimal string");
        this.runShortCommand(Arrays.asList(this.dockerExecutable, "kill", containerId));
    }

    private String runShortCommand(List<String> invocation) throws IOException, TimeoutException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(invocation);
        Process process = pb.start();
        CompletableFuture<String> resultString = CompletableFuture.supplyAsync(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            return reader.lines().collect(Collectors.joining());
        });
        CompletableFuture<String> errorFuture = CompletableFuture.supplyAsync(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
            return reader.lines().collect(Collectors.joining());
        });
        boolean processDone = process.waitFor(this.commandTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (!processDone) {
            process.destroy();
            throw new TimeoutException(String.format("Timed out while waiting for command '%s'", invocation.stream().collect(Collectors.joining(" "))));
        }
        int exitCode = process.exitValue();
        if (exitCode != 0) {
            String errorString;
            try {
                errorString = errorFuture.get(this.commandTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception stderrEx) {
                errorString = String.format("Error capturing stderr: %s", stderrEx.getMessage());
            }
            throw new IOException(String.format("Received exit code %d for command '%s'. stderr: %s", exitCode, invocation.stream().collect(Collectors.joining(" ")), errorString));
        }
        try {
            return resultString.get(this.commandTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new IOException(cause);
        }
    }
}

